<?php
	namespace App\Controllers;
	use CodeIgniter\Files\File;

	class Blog extends BaseController{

		public function blog()
	    {	
	    	$db = \Config\Database::connect();
	    	$builder = $db->table('blog');
			$builder->where(['status' => 0]);
			$builder->orderBy('id', 'desc');
			$data['blogs'] = $builder->get()->getResult();
			
	        echo view('home/header');
	        echo view('blog/blog-view', $data);
	        echo view('home/footer');   
	    }

	    public function blogInner($id)
	    {
	    	$db = \Config\Database::connect();
	        $builder = $db->table('blog');
	        $builder->where('id', $id);
	        $builder->where('status', 0);
	        $data['blog'] = $builder->get()->getRow();

	        $data['getRelatedBlogs'] = $this->getRelatedBlogs($data['blog']->keywords, $data['blog']->id);

	        echo view('home/header');
	        echo view('blog/blog-inner-view', $data);
	        echo view('home/footer');   
	    }

	    public function getRelatedBlogs($keywords, $id)
	    {
	    	$array_like = explode(', ', $keywords);
	    	
			$like_statements = array();

			foreach($array_like as $value)
			{
				// $like_statements[] = "keywords LIKE '%" .str_replace(array("`","'")," ",$value)."%'";

				$db = \Config\Database::connect();
		        $builder = $db->table('blog');
		        $builder->like('keywords', $value);
		        $builder->where('status', 0);
		        $builder->where('id !=', $id);
		        $builder->limit(3);
		        $data['relatedBlog'] = $builder->get()->getResult();
			}

	        if($data['relatedBlog'] == ''){
	        	return false;
	        }else{
	        	return $data;
	        }
	    }

		public function insertBlog(){
			$dataArray = array(
				'title' => 'Advanced Asphalt Mixtures and Their Benefits in Road Durability',
				'short_description' => 'Asphalt mixtures play a crucial role in the durability and performance of road surfaces. Recent studies have focused on comparing different gradation types of mixtures like stone matrix asphalt (SMA), large stone asphalt (LSA), and stone asphalt concrete (SAC) to enhance road longevity. These mixtures have shown varying properties impacting durability, rutting resistance, and cracking resistance.',

				'description' => '<p>Asphalt mixtures play a crucial role in the durability and performance of road surfaces. Recent studies have focused on comparing different gradation types of mixtures like stone matrix asphalt (SMA), large stone asphalt (LSA), and stone asphalt concrete (SAC) to enhance road longevity. These mixtures have shown varying properties impacting durability, rutting resistance, and cracking resistance.</p>
<p><strong>Benefits of Advanced Asphalt Mixtures:</strong></p>
<ul>
<li><strong>Improved Durability</strong>:</li>
</ul>
<p>Advanced asphalt mixtures exhibit enhanced durability due to factors like better resistance to moisture damage, low-temperature cracking, and water permeability.</p>
<ul>
<li><strong>Enhanced Performance</strong>:</li>
</ul>
<p>These mixtures offer superior high-temperature rutting resistance and low-temperature cracking resistance, ensuring longevity and stability of road surfaces.</p>
<ul>
<li><strong>Environmental Sustainability</strong>:</li>
</ul>
<p>Utilizing advanced asphalt materials can lead to reduced costs, lower environmental impacts, and effective resource usage, aligning with sustainable practices in road construction.</p>
<ul>
<li><strong>Reduced Maintenance</strong>:</li>
</ul>
<p>The use of advanced asphalt mixtures can significantly reduce the need for frequent repairs and maintenance, resulting in cost savings and minimized traffic disruptions.</p>
<ul>
<li><strong>Increased Safety</strong>:</li>
</ul>
<p>By providing a smoother and more stable driving surface, advanced asphalt mixtures contribute to enhanced road safety, reducing the risk of accidents and improving overall driver experience.</p>
<ul>
<li><strong>Latest Developments</strong>:</li>
</ul>
<p>Recent advancements in asphalt technology include the use of warm mix asphalt, rubber asphalt, and bio-based asphalt materials. These innovations aim to improve pavement materials, reduce costs, and enhance environmental friendliness. Additionally, the application of mechanistic-empirical design techniques has further optimized the performance and durability of asphalt pavements.</p>
<p><strong>Applications of Advanced Asphalt Mixtures:</strong></p>
<ul>
<li><strong>High-Traffic Roads</strong>:</li>
</ul>
<p>Advanced asphalt mixtures are particularly beneficial for high-traffic roads, where they can withstand the heavy loads and frequent use without compromising on durability.</p>
<ul>
<li><strong>Airport Runways:</strong></li>
</ul>
<p>The use of advanced asphalt mixtures in airport runways ensures a smooth and stable surface, critical for safe takeoffs and landings.</p>
<ul>
<li><strong>High-Speed Roads: </strong></li>
</ul>
<p>These mixtures are ideal for high-speed roads, where they can maintain their integrity even at high velocities.</p>
<ul>
<li><strong>Challenges and Future Directions:</strong></li>
</ul>
<p>Despite the benefits of advanced asphalt mixtures, there are challenges to be addressed, such as the need for more widespread adoption, further research into their long-term performance, and the development of more sustainable production methods.</p>
<ul>
<li><strong>Conclusion:</strong></li>
</ul>
<p>By incorporating these cutting-edge asphalt mixtures and technologies, road infrastructure can be significantly strengthened, ensuring safer and more resilient transportation networks for the future. As the demand for sustainable and durable road surfaces continues to grow, the development and implementation of advanced asphalt mixtures will play a vital role in meeting these needs.<br /><br />Mark your calendars for an exciting opportunity at the RAHSTA EXPO 2024, happening on October 9-10th at the Jio World Convention Centre, Mumbai. This event will showcase the latest advancements in road construction technology and projects, providing a glimpse into the future of infrastructure development&mdash;Buckle Up for Progress! Join us at RAHSTA EXPO 2024 to explore innovative solutions and advanced asphalt technologies that are shaping the future of road construction and durability.</p>
<p>-Discover the future of road construction and durability at the upcoming RAHSTA EXPO 2024, scheduled for October 9-10th at the Jio World Convention Centre, Mumbai. Join industry leaders, innovators, and experts to explore cutting-edge asphalt technologies and sustainable solutions driving progress in infrastructure development. Dont miss this opportunity to be part of shaping the roads of tomorrow&mdash;Register now and pave the way for a resilient transportation network!</p>',
				'status' => 0,
				'date'=>'2024-06-14',
			);

			$db = \Config\Database::connect();
			$builder = $db->table('blog');
			$builder->insert($dataArray);
		}
	}
?>