<?php
namespace App\Controllers;

use App\Models\NominationModel;
use CodeIgniter\Cookie\Cookie;
// use Config\Cookie as CookieConfig;
use CodeIgniter\Files\File;


use DateTime;

class Nomination extends BaseController{

    public function index()
    {
        // return redirect()->to('/');
        $model = new NominationModel();
        $userId = session()->get('loginId'); // login id
        if(isset($userId)){
            /*$model = new NominationModel();
            $data['userDetails'] = $model->getUserDetails($userId); // get user details from db
            return view('nomination/register-form',$data);*/
            return redirect()->to('/nomination-formview');
        }

        $data['nominationCategory'] = $model->getNominationCategory();
        
        // return view('nomination/nomination-view', $data);
        return view('nomination/registration-view', $data);
    }

    public function nominationRegister()
    {
        $model = new NominationModel();
        // return redirect()->to('/');
        $userId = session()->get('loginId'); // login id
        if(isset($userId)){
            return redirect()->to('/nomination-formview');
        }

        $data['nominationCategory'] = $model->getNominationCategory();
        
        // return view('nomination/registration-view', $data);
        return view('nomination/nomination-view', $data);
    }

    public function registerUser(){
        helper(['custom']);
        $model = new NominationModel();

        // $request = \Config\Services::request();
        // echo 1;
        $postData = $this->request->getPost();
        $mandatoryFields = array('first_name','last_name','email_id','company_name', 'designation', 'city', 'password');
        
        /*foreach($mandatoryFields as $mf) {
            if(empty($postData->$mf)) {
                $response = array(
                   "Message" => "No ". $mf . " Found.",
                   "Status" => false
                );
                return $response;
            }
        }*/

        $checkUser  = $model->checkUser($postData['email_id']);
        
        if(empty($checkUser)){
            $postData['password'] = base64_encode($postData['password']);
            $result = $model->insert($postData);

            $emailBody  = "<html><body>";
            $emailBody .= "<table width='100%' bgcolor='#e0e0e0' cellpadding='0' cellspacing='0' border='0'>";
            $emailBody .= "<tr><td>";
            $emailBody .= "<table align='center' width='100%' border='0' cellpadding='0' cellspacing='0' style='max-width:650px; background-color:#fff; font-family:Verdana, Geneva, sans-serif;'>";
            $emailBody .= "<thead>
            <tr height='80'>
            <th colspan='4' style='border-bottom:solid 1px #bdbdbd; font-family:Verdana, Geneva, sans-serif; color:#333; font-size:34px;' >
            <img src='https://rahstaexpo.com/assets-home/img/logo/logo.jpg' alt='https://rahstaexpo.com'></th></tr></thead>";
            $emailBody .= "<tbody><tr><td colspan='4' style='padding:15px;'><p style='font-size:20px;'>Dear ".$postData['first_name'].",</p><p style='font-size:18px;'>
            Thank you. We have received your registration for the RAHSTAExpo Awards 2026.</p>
            <p style='font-size:18px;'>Please find your details below:</p>

            <table border='1px solid;'>
                <tr>
                    <td>Name</td>
                    <td>".$postData['first_name'] .' ' .$postData['last_name']. "</td>
                </tr>
                <tr>
                    <td>Email</td>
                    <td>".$postData['email_id']."</td>
                </tr>

                <tr>
                    <td>Company Name</td>
                    <td>".$postData['company_name']."</td>
                </tr>

                <tr>
                    <td>City</td>
                    <td>".$postData['city']."</td>
                </tr>

            </table>

            <p style='font-size:18px;'>You may login to your account from this link to complete the nomination and payment process <a target='_blank' href='https://rahstaexpo.com/nomination'>https://rahstaexpo.com/nomination</a></p>

            <p style='font-size:20px;'>Regards,</p><p style='font-size:18px;'>Team RAHSTAExpo</p></td></tr></tbody>";
            $emailBody .= "</table>";
            $emailBody .= "</td></tr>";
            $emailBody .= "</table>";
            $emailBody .= "</body></html>";

            $emaiilSubject = 'RAHSTAExpo - Nomination Registration';
            $condition = 1;
            send_email($postData['email_id'],$emaiilSubject, $emailBody, $condition);
            $message = array(
               "Message" => "Thank you for your registration, Please login to fill the form!",
               "Status" => true
            );

            $sheetName = 'nomination-registration';
            $requestBody = [
                "range" => $sheetName . "!A2:I2",
                "majorDimension" => "COLUMNS",
                "values" => [
                    [
                        $postData['first_name']
                    ],
                    [
                        $postData['last_name']
                    ],
                    [
                        $postData['email_id']
                    ],
                    [
                        $postData['mobile_no']
                    ],
                    [
                        $postData['company_name']
                    ],
                    [
                        $postData['designation']
                    ],
                    [
                        $postData['city']
                    ],
                    [
                        date('d-m-Y')
                    ],
                    [
                        $postData['sourceURL']
                    ]
                ]
            ];
            insertToGoogleSheetNomination($requestBody, $sheetName, 3);
        }else{
            $message = array(
               "Message" => "You are already a registered user. Please login to fill the form!",
               "Status" => false
            );
        }
        $this->response->setJSON($message);
        return $this->response;
    }

    public function loginUser()
    {
        $model = new NominationModel();

        $postData = $this->request->getPost();

        $chkLogin = $model->checkLogin($postData);

        if($chkLogin){
            // set session

            $ses_data = [
                'userLogged' => true,
                'loginId' => $chkLogin->user_form_make_id,
                'userName' => $chkLogin->first_name .' '. $chkLogin->last_name,
            ];
            
            $this->session->set($ses_data);
            // print_r(session()->get('loginId'));
            $message = array(
               "Message" => "Login successful, Redirection to dashboard!",
               "Status" => true
            );
        }else{
            $message = array(
               "Message" => "Please enter valid email address and password!",
               "Status" => false
            );
        }

        $this->response->setJSON($message);
        return $this->response;
    }

    public function nominationView()
    {
        $userId = session()->get('loginId'); // login id
        $data = array();
        if(isset($userId)){
            $model = new NominationModel();
            $userDetails = $model->getUserDetails($userId); // get user details from db
            
            if($userDetails->nominate_id != 0){
                $data['nominationDetails'] = $model->getNominatedDetails($userId,$userDetails->nominate_id); // get nomination details
            }

            $data['userDetails'] = $userDetails;
            
            $data['userOrderDetails'] = $model->getOrderID($userId, $userDetails);

            $data['nominationCategory'] = $model->getNominationCategory($userId);

            $data['getCategoryQuestions'] = $model->getCategoryQuestions($data['nominationCategory']);

            return view('nomination/register-form',$data);
        }else{
            return redirect()->to('/nomination'); 
        }
    }

    public function firststepSubmit()
    {
        // $validation =  \Config\Services::validation();
        // $validation->setRuleGroup('signin');
        $request = \Config\Services::request();

        if($request->getMethod() != "post") {
            // return redirect()->back()->withInput()->with('error', $validation->getErrors());
            return redirect()->to('/nomination');
        }else{
            // echo '<pre>';
            // print_r($_POST);
            $userId = session()->get('loginId'); // login id
            $dataArray = array(
                // 'address' => $this->request->getVar('address'),
                'state' => $this->request->getVar('state'),
                'postal_code' => $this->request->getVar('postal_code'),
                // 'phone_number' => $this->request->getVar('phone_number'),
                'mobile_number' => $this->request->getVar('mobile_number'),
                'designation' => $this->request->getVar('designation'),
                'company_name' => $this->request->getVar('company_name'),
                'city' => $this->request->getVar('city'),
                'state' => $this->request->getVar('state'),
                'postal_code' => $this->request->getVar('postal_code'),
                /*'company_type' => $this->request->getVar('company_type'),
                'website_url' => $this->request->getVar('website_url'),
                'product_name' => $this->request->getVar('product_name'),
                'gst_number' => $this->request->getVar('gst_number'),*/
            );
            
            $model = new NominationModel();
            $updated =  $model->updateFormDetails($dataArray);
            if($updated){
                helper(['cookie']);
                setcookie('istep1',$userId,strtotime('+1 days'));
                setcookie('istep2',$userId,time()-3600);
                // return redirect()->back()->withInput()->with('success', 'Personal Details Saved.');
                return redirect()->back()->withInput()->with('success', 'Personal Details Saved.');

                // return redirect()->back();
                // return redirect()->back()->withCookies();
            }

        }
    }

    public function secondstepFormValidation()
    {
        $model = new NominationModel();
        $nomId = $this->request->getPost('nominate');
        $getCategoryQuestionsColumn = $model->getQuestionColumnById($nomId);

        if($getCategoryQuestionsColumn){
            $message = array(
                'success' => true,
                'data' => $getCategoryQuestionsColumn
            );
        }else{
            $message = array(
                'success' => false,
            );
        }
        
        $this->response->setJSON($message);
        return $this->response;
    }

    public function secondstepSubmit()
    {   
        helper(['form']);
        $validation =  \Config\Services::validation();
        $request = \Config\Services::request();

        if($request->getMethod() != "post") {
            // return redirect()->back()->withInput()->with('error', $validation->getErrors());
            return redirect()->to('/nomination');
        }else{
            
            $model = new NominationModel();

            $userId = session()->get('loginId'); // login id
            
            $nomId = $this->request->getVar('nominate');

            $getCategoryQuestionsColumn = $model->getQuestionColumnById($nomId);

            $dataArray = array();
            foreach($getCategoryQuestionsColumn as $column){
                $dataArray[$column->column_name] = $this->request->getVar($column->column_name);
            }

            /*if($nomId == 4){

                $dataArray = array(
                    'gfy_env_pollution' => $this->request->getVar('gfy_env_pollution'),
                    'gfy_energy_cons' => $this->request->getVar('gfy_energy_cons'),
                    'gfy_minimise_wastage' => $this->request->getVar('gfy_minimise_wastage'),
                    'gfy_workplace_safety' => $this->request->getVar('gfy_workplace_safety'),
                    'gfy_env_heth_guid' => $this->request->getVar('gfy_env_heth_guid'),
                );

                $imgPreUploaded = $this->request->getVar('isImgUploaded');

                if($imgPreUploaded == 0){

                    $img = $this->request->getFile('doc_upload');
                    $validationRule = [
                        'userfile' => [
                            'label' => 'Image File',
                            'rules' => 'uploaded[doc_upload]'
                                // . '|is_image[doc_upload]'
                                . '|mime_in[doc_upload,image/jpg,image/jpeg,image/gif,image/png,image/webp,application/pdf]'
                                . '|max_size[doc_upload,2048]'
                                // . '|max_dims[doc_upload,1024,768]',
                        ],
                    ];
                    if (! $this->validate($validationRule)) {
                        $imgData = ['errors' => $this->validator->getErrors()];
                        helper(['cookie']);
                        setcookie('istep1',$userId,strtotime('+1 days'));
                        setcookie('istep2',$userId,time()-3600);
                        return redirect()->back()->withInput()->with('error', $imgData['errors']);
                    }
                    $filepath = 'assets/uploads';

                    if ($img->move($filepath)) {
                        // $filepath = WRITEPATH . 'uploads/' . $img->store();
                        // $filepath = WRITEPATH . 'uploads/' . $img->store();
                        // $data = ['uploaded_flleinfo' => new File($filepath)];
                        $data = [
                            'img_name' => $img->getClientName(),
                            'file'  => $img->getClientMimeType()
                        ];

                        $pathLocation = $filepath.'/'.$data['img_name'];

                        $dataArray['gfy_certifications'] = $pathLocation;
                    }
                }
                
                $tblName = 'tbl_green_factory_of_year';
                $formName = 'Green Factory of the Year';
            }*/
            

            $checkNom =  $model->checkNomination($userId,$nomId);

            if($checkNom){
                // update nomination details
                $model->updateNominationDetails($userId,$dataArray,$nomId);
                $nomDetails = $model->getNominatedDetails($userId,$nomId);
                $nomStatus = $nomDetails->id;
            }else{
                // insert nomination details
                $nomStatus = $model->insertNominationDetails($userId,$dataArray,$nomId);
            }

            $formArray = array(
                'nominate_id' => $nomId,
                'nomination_idd' => $nomStatus,
            );
            
            // update latest nomiantion id in main table for reference.
            $model->updateFormDetails($formArray);

            if($nomStatus){
                // return redirect()->to('/nomination');
                // echo "<script>setcookie('istep1',$userId,strtotime('+1 days'));</script>";
                // return redirect()->back()->withInput()->with('message', 'Data Submited successful!');
                helper(['cookie']);
                setcookie('istep2',$userId,strtotime('+1 days'));
                // return redirect()->back();
                return redirect()->back()->withInput()->with('success', 'Category Details Saved.');
            }

        }
    }

    public function getNominationDetailsByCategory(){
        $model = new NominationModel();

        $userId = session()->get('loginId');
        $val = $this->request->getVar('val');
        $details = $model->checkNomination($userId,$val);
        $getCategoryQuestionsColumn = $model->getQuestionColumnById($val);

        if($details){
            $message = array(
                'success' => true,
                'data' => $details,
                'nominationDetails'=> $getCategoryQuestionsColumn,
            );
        }else{
            $message = array(
                'success' => false,
                'data' => ''
            );
        }
        
        $this->response->setJSON($message);
        return $this->response;
    }

    public function nominationProfile()
    {
        $userId = session()->get('loginId'); // login id
        $data = array();
        if(isset($userId)){
            $model = new NominationModel();
            $userDetails = $model->getUserDetails($userId); // get user details from db
            
            if($userDetails->nominate_id != 0){
                $data['nominationDetails'] = $model->getNominatedDetails($userId,$userDetails->nominate_id); // get nomination details
            }

            $data['userDetails'] = $userDetails;
            
            $data['nominationOrderDetails'] = $model->getOrderDetails($userId, $userDetails);
            /*echo '<pre>';
            print_r($data['userOrderDetails']);
            exit();*/
            return view('nomination/profile',$data);
        }else{
            return redirect()->to('/nomination'); 
        }
    }

    public function registerThankyou()
    {   
        return view('nomination/register-thankyou-view');
    }
    public function logout()
    {
        $this->session->destroy();
        return redirect()->to('/');
    }
}