<?php

namespace App\Controllers;

require(APPPATH . "Libraries/razorpay-php/Razorpay.php");

use Razorpay\Api\Api;
use Razorpay\Api\Errors\SignatureVerificationError;
use App\Models\PaymentModel;

class Payment extends BaseController{
	
	public function paymentView()
	{
		$data = array();

		$data['paymentData'] = $this->request->getPost();
		if($data){
			return view('payment/payment-view',$data);
		}else{
			
			return redirect()->to('nomination');
		}
	}

	public function generateOrder()
	{
	    $key_id = RAZORPAY_LIVE_KEY;
	    $secret = RAZORPAY_LIVE_SECRET;
	    
	    $orderIdd = $this->request->getVar('orderIdd');

	    $api = new Api($key_id, $secret);
	    $amount =  2950 * 100;
	    $orderData = [
	        "receipt" => $orderIdd,
	        "amount" =>  $amount, // this is always in paise
	        "currency" => IND_CURRENCY
	    ];
	    $orderResponse = $api->order->create($orderData);
	    if($orderResponse['id'] != ''){
	        $data = array(
	            "key" => $key_id,
	            "orderId" => $orderResponse['id'],
	            "amount" => $amount
	        );

	        $result = array(
	            "data" =>$data,
	            "status" => true,
	            "message" => "Order Created"
	        );

	    } else {
	        $result = array(
	                // "orderId" => $orderResponse['id'], 
	            "status" => false,
	            "message" => "Order Not Created"
	        );
	    }	

	    $this->response->setJSON($result);
        return $this->response;
	}

	public function verfiySignature()
	{
	    $key_id = RAZORPAY_LIVE_KEY;
	    $secret = RAZORPAY_LIVE_SECRET;
	    
	    $paymentId = '';
	    $signature = '';
	    $orderId = '';
	    $amount = '';

	    if(!empty($this->request->getVar('paymentId'))){
	        $paymentId = $this->request->getVar('paymentId');
	    }

	    if(!empty($this->request->getVar('signature'))){
	        $signature = $this->request->getVar('signature');
	    }
	    
	    if(!empty($this->request->getVar('orderId'))){
	        $orderId = $this->request->getVar('orderId');
	    }
	    
	    if(!empty($this->request->getVar('amount'))){
	        $amount = $this->request->getVar('amount');
	    }
	    
	    $api = new Api($key_id, $secret);
	    
	    $success = true;

	    $error = "Payment Failed";
	    
	    try
	    {
	        // Please note that the razorpay order ID must
	        // come from a trusted source (session here, but could be database or something else)
	        $attributes = array(
	            'razorpay_order_id' => $orderId,
	            'razorpay_payment_id' => $paymentId,
	            'razorpay_signature' => $signature
	        );
	    
	        $api->utility->verifyPaymentSignature($attributes);
	        // print_r($response); exit()
	    }
	    catch(SignatureVerificationError $e)
	    {
	        $success = false;
	        $error = 'Razorpay Error : ' . $e->getMessage();
	    }
	    if ($success === true)
	    {
	        // Capture the Payment After Authorized
	        $captureData = [
		        "amount" =>  $amount,
		        "currency" => IND_CURRENCY
		    ];

		    // $api->payment->fetch($paymentId)->capture($captureData);

	        // $api->payment->fetch($paymentId)->capture(array('amount'=>$amount,'currency' => 'INR'));
	        // $res = $this->grantUserProduct($productId);
	    
	        $result = array(
	        	"remarks"=> true, 
	        	"message" => "Your payment was successful. Payment ID: {$paymentId}",
	        	"paymentId" => $paymentId,
	        );
	    }
	    else
	    {
	        $result = array(
	        	"remarks"=> false, 
	        	"message" => "Payment Failed. {$error}"
	        );
	    }
		
		$this->response->setJSON($result);
        return $this->response;
	}

	public function updatePaymentStatus()
	{
		$postData = $this->request->getPost();

		$transactionStatus = '';
		if($postData['remarks'] == true){
			$transactionStatus = 'Success';
		}

		$dataAarray = array(
			'transaction_id' => $postData['paymentId'],
			'transaction_status' => $transactionStatus,
			// 'amount_paid' => $postData['amountPaid'],
			'transaction_date' => date('Y-m-d')
		);

		$paymentModel = new PaymentModel();
		$paymentModel->updatePaymentStatus($dataAarray, $postData['orderIdd']);
		
		if($postData['remarks'] == true){
			$this->sendPaymentMail($postData);

			$message = array(
				'message' => 'Payment successful',
                'status' => true,
            );
		}else{
			$message = array(
				'message' => 'Payment failed!',
                'status' => false,
            );
		}
		
		$this->response->setJSON($message);
        return $this->response;
	}

	public function sendPaymentMail($postData)
	{	
		helper(['custom']);
		$paymentModel = new PaymentModel();

		$userDetails = $paymentModel->getUserDetailsByOrder($postData['orderIdd']);

		$categoryDetails = $paymentModel->categoryDetails($userDetails->category_id);

		$emailBody = "";

        $emailBody .="<table id='Table_01' width='600' border='0' cellpadding='0' cellspacing='0' align='center' style='background-color:#fff;'>";
        
        $emailBody .="<tr><td align='center' style='padding:10px 10px 20px 10px;'><img src='https://rahstaexpo.com/assets-home/img/logo/logo.jpg'></td></tr>";
        
        $emailBody .="<tr><td style='padding:10px 10px 20px 10px; font-family:Arial, Helvetica, sans-serif; font-size:14px; line-height:22px; color:#555'><p><strong>Dear ".ucfirst($userDetails->first_name).",</strong></p>
        <p>Thank you for nominating for RAHSTA Expo Awards 2025, Please find the below details for your reference.</p></td></tr>";
        
        $emailBody .="<tr><td style='padding:10px 10px 20px 10px;'><table width='70%' cellpadding='5' cellspacing='0' border='1' align='center' style='border-color:#fbfbfb; text-align:left;'>";

        $emailBody .="<tr>";
          	$emailBody .="<td>Name</td>";
          	$emailBody .="<td>".$userDetails->first_name.' '. $userDetails->last_name ."</td>";
        $emailBody .="</tr>";
        
        $emailBody .="<tr>";
          	$emailBody .="<td>Email</td>";
          	$emailBody .="<td>".$userDetails->email_id."</td>";
        $emailBody .="</tr>";
        
        $emailBody .="<tr>";
          	$emailBody .="<td>Mobile No</td>";
          	$emailBody .="<td>".$userDetails->mobile_number."</td>";
        $emailBody .="</tr>";

        $emailBody .="<tr>";
          	$emailBody .="<td>Company Name</td>";
          	$emailBody .="<td>".$userDetails->company_name."</td>";
        $emailBody .="</tr>";
        
        if($categoryDetails != ''){
          	$emailBody .="<tr>";
            	$emailBody .="<td>Category</td>";
            	$emailBody .="<td>".$categoryDetails->category_name."</td>";
          	$emailBody .="</tr>";
        }

        $emailBody .="<tr>";
          	$emailBody .="<td>Payment Status</td>";
          	$emailBody .="<td>".$userDetails->transaction_status."</td>";
        $emailBody .="</tr>";

	        if($userDetails->transaction_status == 'Success' || $userDetails->transaction_status == 'success'){
	        	$emailBody .="<tr>";
	            	$emailBody .="<td>Payment Date</td>";
	            	$emailBody .="<td>".$userDetails->transaction_date."</td>";
	          	$emailBody .="</tr>";

	          	/*$emailBody .="<tr>";
	            	$emailBody .="<td>Amount Paid</td>";
	            	$emailBody .="<td>".$userDetails->paymentAmt."</td>";
	          	$emailBody .="</tr>";*/
	        }
        
        	$emailBody .="</table></td></tr>";
        $emailBody .="</table>";

        $subject = 'Nomination - Payment Success -' . $userDetails->order_id;
		if($userDetails){
			
			send_email($userDetails->email_id, $subject, $emailBody);
			
			$this->insertGoogleSheet($userDetails, $categoryDetails);

			return true;
		}else{
			return false;
		}
		
	}

	public function visitorConfirmationMail()
	{
		helper(['custom']);

		$insertedId = session()->get('insertedId');
		$db = \Config\Database::connect();
        $builder = $db->table('tbl_registration');
        $builder->where(['id' => $insertedId]);
        $query = $builder->get()->getRow();

		$emailBody = "";

		$emailBody .= "Dear ".$query->name.", ";

		$emailBody .= "<p>Thank you for signing up as a <strong>Visitor</strong> for <span style='color:red;'>14th Edition of RAHSTA Expo 2025.</span> </p>";

		$emailBody .="<p>The event is seeing the participation of cement companies like Ultratech, JSW Cement, Dalmia Bharat, Star Cement, JK Cement, JK Lakshmi Cement, Shree Cement, Wonder Cement, Birla Corporation, My Home Industries, Shree Digvijay Cement, Sagar Cement among others. The 3-in-in event is supported by the Ministry of Road Transport &amp; Highways and Department for Promotion of Industry and Internal Trade (DPIIT), Ministry of Commerce and Industry, Government of India (GoI). With over 100 exhibitors, Cement EXPO (along with ICR Conference &; Awards) is expected to attract more than 5,000 quality visitors.</p>";
		$emailBody .="<p><strong>Please find the details below.</strong></p>";
		$emailBody .="<p style='color:blue;'><strong>2 Days Exhibition.</strong></p>";
		$emailBody .="<p><strong>Date: 14-12-2023 and 15-12-2023</strong></p>";
		$emailBody .="<p><strong>Timings: </strong></p>";
		$emailBody .="<p><strong>Day 1 - 10am to 5pm</strong></p>";
		$emailBody .="<p><strong>Day 2 - 10am to 4pm</strong></p>";
		$emailBody .="<p><strong>Venue: </strong>Manekshaw Centre Auditorium, Khyber Lines, Delhi Cantonment, New Delhi-110010</p>";
		$emailBody .="<p><strong style='color:red;'>Note: This registeration email will give you an access to the exbhition stalls only.</strong></p>";
		$emailBody .="<p>For any query related to the same please feel free to get in touch with us on the contact details mentioned below.</p>";
		$emailBody .="<p>Deepali Lahare <br> 8652493000</p>";

		$subject = 'CementExpo Visitor | Confirmation';
		$condition = 'visitor';
		// send_email($query->email_id, $subject, $emailBody, $condition);
		$message = array(
            'Status' => true,
        );
        
        $this->response->setJSON($message);
        return $this->response;
	}

	public function paymentThankyou()
	{
		return view('payment/thankyou');
	}

	public function getPaymentData()
    {
        $db = \Config\Database::connect();
        $builder = $db->table('tbl_transaction_details as a');
        $builder->join('user_form as b', 'a.user_id=b.user_form_make_id');
        $builder->where(['order_id'=>'CMXPO62023101816976097085']);
        $result = $builder->get()->getRow();

        // $this->sendPaymentMail();
        
    }

    public function sendPaymentMail1()
    {
    	helper(['custom']);
		$paymentModel = new PaymentModel();

		// $userDetails = $paymentModel->getUserDetailsByOrder($postData['orderIdd']);
		$db = \Config\Database::connect();
		$builder = $db->table('user_form as user');
		$builder->join('tbl_transaction_details as trans','user.user_form_make_id = trans.user_id');
		$builder->where(['registeryear' => '2025']);
		$builder->where(['transaction_status' => 'success']);
		$builder->where(['pay_for' => 'nomination']);

		$userDetails = $builder->get()->getResult();
		
		foreach ($userDetails as $key => $userDetails) {

			$categoryDetails = $paymentModel->categoryDetails($userDetails->category_id);

			$emailBody = "";

	        $emailBody .="<table id='Table_01' width='600' border='0' cellpadding='0' cellspacing='0' align='center' style='background-color:#fff;'>";
	        
	        $emailBody .="<tr><td align='center' style='padding:10px 10px 20px 10px;'><img src='https://rahstaexpo.com/assets-home/img/logo/logo.jpg'></td></tr>";
	        
	        $emailBody .="<tr><td style='padding:10px 10px 20px 10px; font-family:Arial, Helvetica, sans-serif; font-size:14px; line-height:22px; color:#555'><p><strong>Dear ".ucfirst($userDetails->first_name).",</strong></p>
	        <p>Thank you for nominating for RAHSTA Expo Awards 2025, Please find the below details for your reference.</p></td></tr>";
	        
	        $emailBody .="<tr><td style='padding:10px 10px 20px 10px;'><table width='70%' cellpadding='5' cellspacing='0' border='1' align='center' style='border-color:#fbfbfb; text-align:left;'>";

	        $emailBody .="<tr>";
	          	$emailBody .="<td>Name</td>";
	          	$emailBody .="<td>".$userDetails->first_name.' '. $userDetails->last_name ."</td>";
	        $emailBody .="</tr>";
	        
	        $emailBody .="<tr>";
	          	$emailBody .="<td>Email</td>";
	          	$emailBody .="<td>".$userDetails->email_id."</td>";
	        $emailBody .="</tr>";
	        
	        $emailBody .="<tr>";
	          	$emailBody .="<td>Mobile No</td>";
	          	$emailBody .="<td>".$userDetails->mobile_number."</td>";
	        $emailBody .="</tr>";

	        $emailBody .="<tr>";
	          	$emailBody .="<td>Company Name</td>";
	          	$emailBody .="<td>".$userDetails->company_name."</td>";
	        $emailBody .="</tr>";
	        
	        if($categoryDetails != ''){
	          	$emailBody .="<tr>";
	            	$emailBody .="<td>Category</td>";
	            	$emailBody .="<td>".$categoryDetails->category_name."</td>";
	          	$emailBody .="</tr>";
	        }

	        $emailBody .="<tr>";
	          	$emailBody .="<td>Payment Status</td>";
	          	$emailBody .="<td>".$userDetails->transaction_status."</td>";
	        $emailBody .="</tr>";

		        if($userDetails->transaction_status == 'Success' || $userDetails->transaction_status == 'success'){
		        	$emailBody .="<tr>";
		            	$emailBody .="<td>Payment Date</td>";
		            	$emailBody .="<td>".$userDetails->transaction_date."</td>";
		          	$emailBody .="</tr>";

		          	/*$emailBody .="<tr>";
		            	$emailBody .="<td>Amount Paid</td>";
		            	$emailBody .="<td>".$userDetails->paymentAmt."</td>";
		          	$emailBody .="</tr>";*/
		        }
	        
	        	$emailBody .="</table></td></tr>";
	        $emailBody .="</table>";

	        $subject = 'Nomination - Payment Success -' . $userDetails->order_id;
			if($userDetails){
				send_email($userDetails->email_id, $subject, $emailBody);
				// send_email('rahul.j@asappmedia.com', $subject, $emailBody);
				echo 'Mail send';
				// return true;
			}else{
				echo 'Mail not send';
				// return false;
			}
		}
    }

    public function insertGoogleSheet($userDetails, $categoryDetails)
    {	
    	helper(['custom']);

    	$sheetName = 'nomination-payment';

    	$blankData = '';
			$requestBody = '';
			$requestBody = [
				"range" => $sheetName . "!A2:I2",
				"majorDimension" => "COLUMNS",
				"values" => [
					[
						$userDetails->first_name.' '. $userDetails->last_name
					],
					[
						$userDetails->email_id
					],
					[
						$userDetails->mobile_number
					],
					[
						$userDetails->company_name
					],
					[
						$categoryDetails->category_name
					],
					[
						$userDetails->order_id
					],
					[
						$userDetails->transaction_status
					],
					[
						date('d-m-Y')
					],
				]
			];
			
		// insertToGoogleSheet($requestBody, $sheetName);
		insertToGoogleSheetNomination($requestBody, $sheetName, $condition = 3);

		return true;
    }
}