<?php

namespace App\Filters;

use CodeIgniter\Filters\FilterInterface;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;

class BasicauthFilter implements FilterInterface
{
    /**
     * Do whatever processing this filter needs to do.
     * By default it should not return anything during
     * normal execution. However, when an abnormal state
     * is found, it should return an instance of
     * CodeIgniter\HTTP\Response. If it does, script
     * execution will end and that Response will be
     * sent back to the client, allowing for error pages,
     * redirects, etc.
     *
     * @param RequestInterface $request
     * @param array|null       $arguments
     *
     * @return mixed
     */
    public function before(RequestInterface $request, $arguments = null)
    {
        //
        if(!empty($_SERVER['HTTP_AUTHORIZATION'])){
            $auth = explode(' ', $_SERVER['HTTP_AUTHORIZATION']);
        }

        if(!empty($_SERVER['REDIRECT_HTTP_AUTHORIZATION'])){
            $auth = explode(' ', $_SERVER['REDIRECT_HTTP_AUTHORIZATION']);
        } 

        // print_r($auth[1]);
        if(!empty($auth)){
            if($auth[1] != AUTH_SECRET){
                header("Content-type: application/json");
                echo json_encode(array(
                    "status" => false,
                    "message" => "Invalid credentials"
                ));
                die;  
            } 
        } else {
            header("Content-type: application/json");
            echo json_encode(array(
                "status" => false,
                "message" => "No Authorization Received."
            ));
            die;
        }
    }

    /**
     * Allows After filters to inspect and modify the response
     * object as needed. This method does not allow any way
     * to stop execution of other after filters, short of
     * throwing an Exception or Error.
     *
     * @param RequestInterface  $request
     * @param ResponseInterface $response
     * @param array|null        $arguments
     *
     * @return mixed
     */
    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
    {
        //
    }
}
