<?php
use App\Models\OnsiteModel;
function send_email($to, $subject, $details, $condition = false){
	
	$email = \Config\Services::email();
	$email->setTo($to);
    
    if($condition !='Event'){
    	// $email->setBCC('rahul.j@asappinfoglobal.com,delegate1@asappinfoglobal.com');
    }
    
	$email->setFrom('webmaster@asappmedia.com', 'RAHSTA EXPO');
	$email->setSubject($subject);
	// $body = view('verifyEmail', $details);
	$body = $details;
	$email->setMessage($body);


	if($condition == 2){
		$attachmentPath = FCPATH . 'assets/uploads/rahsta-brochure-2025.pdf'; // Adjust the path to your file
        $email->attach($attachmentPath);
	}

    if ($email->send()) 
    {
        return true;
    }else 
    {
        $data = $email->printDebugger(['headers']);
        return false;
	}
}

function insertDataToGoogleSheet($data, $sheetName, $condition=false)
{	
	// $ip_address = $this->request->getIPAddress();

	$stallSize = "";
	if($data['stall_size'] != ''){
		$stallSize = $data['stall_size'];
	}

	$cur_date = date('d-m-Y'); 
	$requestBody = '';
	$requestBody = [
		"range" => $sheetName . "!A2:Z2",
		"majorDimension" => "COLUMNS",
		"values" => [
			[
				$data['name']
			],
			[
				$data['email_id']
			],
			[
				$data['mobile_no']
			],
			[
				$data['company_name']
			],
			[
				$data['designation']
			],
			[
				$data['city']
			],
			[
				$data['industry']
			],
			[
				$data['interested_in']
			],
			[
				$data['order_id']
			],
			[
				$stallSize
			],
			[
				$cur_date
			],
			[
				$data['web_url']
			]
		]
	];

	$token = getGoogleAccessToken();

	if($condition == 1){
		$url = "https://sheets.googleapis.com/v4/spreadsheets/1ywZJMvpxlpRB2SEWpbTEUgJFNSMwR3KouWK0eRtno68/values/". $sheetName . "!A2:Z2:append?valueInputOption=USER_ENTERED";
	}else if($condition == 2){
		$url = "https://sheets.googleapis.com/v4/spreadsheets/11iEaz273loALrJgXfmMuGsFZ0qXOVaSQNvauzGMQUR4/values/". $sheetName . "!A2:Z2:append?valueInputOption=USER_ENTERED";
	}else{
		$url = "https://sheets.googleapis.com/v4/spreadsheets/1K7Ca5KUe3dY8cmT3GaYjNDOA3KvQpd1s8tnD5YS9Kgk/values/". $sheetName . "!A2:Z2:append?valueInputOption=USER_ENTERED";
	}
	

	$headers = array(
		
		"Content-type: application/json",
		"Authorization: Bearer ".$token
	);

	$con =  curl_init($url);

	//set options
	curl_setopt($con, CURLOPT_CONNECTTIMEOUT, 30);
	curl_setopt($con, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)");
	curl_setopt($con, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($con, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($con, CURLOPT_FOLLOWLOCATION, 1);
	curl_setopt($con, CURLOPT_HTTPHEADER, $headers);
	curl_setopt($con, CURLOPT_CUSTOMREQUEST, "POST");
	curl_setopt($con, CURLOPT_POSTFIELDS, json_encode($requestBody));

	//perform our request
	$response = curl_exec($con);
	$err = curl_error($con);
	curl_close($con);
	return true;	
}

function insertToGoogleSheet($requestBody, $sheetName, $condition)
{	
	// $ip_address = $this->request->getIPAddress(); 


	$token = getGoogleAccessToken();

	if($condition == 2){
		$url = "https://sheets.googleapis.com/v4/spreadsheets/11iEaz273loALrJgXfmMuGsFZ0qXOVaSQNvauzGMQUR4/values/". $sheetName . "!A2:Z2:append?valueInputOption=USER_ENTERED";
	}else{
		$url = "https://sheets.googleapis.com/v4/spreadsheets/1K7Ca5KUe3dY8cmT3GaYjNDOA3KvQpd1s8tnD5YS9Kgk/values/". $sheetName . "!A2:Z2:append?valueInputOption=USER_ENTERED";
	}
	
	$headers = array(
		
		"Content-type: application/json",
		"Authorization: Bearer ".$token
	);

	$con =  curl_init($url);

	//set options
	curl_setopt($con, CURLOPT_CONNECTTIMEOUT, 30);
	curl_setopt($con, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)");
	curl_setopt($con, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($con, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($con, CURLOPT_FOLLOWLOCATION, 1);
	curl_setopt($con, CURLOPT_HTTPHEADER, $headers);
	curl_setopt($con, CURLOPT_CUSTOMREQUEST, "POST");
	curl_setopt($con, CURLOPT_POSTFIELDS, json_encode($requestBody));

	//perform our request
	$response = curl_exec($con);
	$err = curl_error($con);
	curl_close($con);
	return true;	
}

function floorPlanGoogleSheet($requestBody, $sheetName)
{	
	// $ip_address = $this->request->getIPAddress(); 

	$token = getGoogleAccessToken();
	
		$url = "https://sheets.googleapis.com/v4/spreadsheets/1lBNuVPUVCT1998HhCX6YHa5EYOck1K5UP4RiJoVdIFc/values/". $sheetName . "!A2:Z2:append?valueInputOption=USER_ENTERED";
	
	
	$headers = array(
		
		"Content-type: application/json",
		"Authorization: Bearer ".$token
	);

	$con =  curl_init($url);

	//set options
	curl_setopt($con, CURLOPT_CONNECTTIMEOUT, 30);
	curl_setopt($con, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)");
	curl_setopt($con, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($con, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($con, CURLOPT_FOLLOWLOCATION, 1);
	curl_setopt($con, CURLOPT_HTTPHEADER, $headers);
	curl_setopt($con, CURLOPT_CUSTOMREQUEST, "POST");
	curl_setopt($con, CURLOPT_POSTFIELDS, json_encode($requestBody));

	//perform our request
	$response = curl_exec($con);
	$err = curl_error($con);
	curl_close($con);
	return true;	
}


function insertToGoogleSheetNomination($requestBody, $sheetName, $condition = false)
{	
	// $ip_address = $this->request->getIPAddress(); 


	$token = getGoogleAccessToken();

	// $url = "https://sheets.googleapis.com/v4/spreadsheets/1ZIHM4DSWNyy3BrP0j2TZ5AiYEkcZCQQRxz02KRbBCkI/values/". $sheetName . "!A2:I2:append?valueInputOption=USER_ENTERED";
	if($condition == 3){
		$url = "https://sheets.googleapis.com/v4/spreadsheets/1izEJUmJn_nWPqVS-WD-w0zFO81BCPCmFszdwIbrFE7w/values/". $sheetName . "!A2:I2:append?valueInputOption=USER_ENTERED";
	}else{
		$url = "https://sheets.googleapis.com/v4/spreadsheets/1ywZJMvpxlpRB2SEWpbTEUgJFNSMwR3KouWK0eRtno68/values/". $sheetName . "!A2:I2:append?valueInputOption=USER_ENTERED";
	}

	$headers = array(
		
		"Content-type: application/json",
		"Authorization: Bearer ".$token
	);

	$con =  curl_init($url);

	//set options
	curl_setopt($con, CURLOPT_CONNECTTIMEOUT, 30);
	curl_setopt($con, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)");
	curl_setopt($con, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($con, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($con, CURLOPT_FOLLOWLOCATION, 1);
	curl_setopt($con, CURLOPT_HTTPHEADER, $headers);
	curl_setopt($con, CURLOPT_CUSTOMREQUEST, "POST");
	curl_setopt($con, CURLOPT_POSTFIELDS, json_encode($requestBody));

	//perform our request
	$response = curl_exec($con);
	$err = curl_error($con);
	curl_close($con);
	return true;	
}

//Google Sheet API Access Token
function getGoogleAccessToken()
{
	$OnsiteModel = new OnsiteModel();
	
	$getToken = $OnsiteModel->getAccessToken();

	// $currentTime = time();
	$currentTime = round(microtime(true)*100);

	$getTokenTime = strtotime($getToken[0]['expires_in']);
	
	$diff = ($currentTime - $getTokenTime);

	if ($diff > 3599) {
		$token = getGoogleAccessTokenFromRefreshToken();
	} else {
		$token = $getToken[0]['access_token'];
	}
	
	return $token;
}

// Google Sheet API Refresh token
function getGoogleAccessTokenFromRefreshToken(){
	// echo '==1';
    $OnsiteModel = new OnsiteModel();
    $tokens = $OnsiteModel->getRefreshToken();
	
	$refresh_token = $tokens[0]['refresh_token'];
	
    $url = 'https://oauth2.googleapis.com/token';

    $refreshTokenData = "client_secret=dlqToRaVP1EDV4Cc3yLwKn3j&grant_type=refresh_token&refresh_token=".$refresh_token."&client_id=566286160451-75jk1glcsma2krcnaguedvfijn5lvl69.apps.googleusercontent.com";

	$headers = array (
		"Content-type: application/x-www-form-urlencoded"
	);

    $con =  curl_init($url);
    //set options
    curl_setopt($con, CURLOPT_CONNECTTIMEOUT, 30);
    curl_setopt($con, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)");
    curl_setopt($con, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($con, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($con, CURLOPT_FOLLOWLOCATION, 1);
    curl_setopt($con, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($con, CURLOPT_CUSTOMREQUEST, "POST");
    curl_setopt($con, CURLOPT_POSTFIELDS, $refreshTokenData);


    // curl_setopt( $curl_handle, CURLOPT_COOKIEFILE, uniquefilename );
    //perform our request
    $response = curl_exec($con);
    $err = curl_error($con);
    curl_close($con);
    // var_dump($response);
    $response = json_decode($response);

	$data = $OnsiteModel->updateAccessToken($response);

	if($data){
		return $data;
	}else{
		return false;
	}


}