<?php
	namespace App\Models;

	use CodeIgniter\Model;

	class AttendeesModel extends Model{

		protected $table = 'attendees_details';
		protected $primaryKey = 'id';
		protected $allowedFields = [
			'user_id',
			'first_name',
			'last_name',
			'email_id',
			'mobile_no',
			'company_name',
			'designation',
			'job_role',
			'country_id',
			'state_name',
			'city_name',
			'address',
			'postal_code',
			'email_verified',
			'profile_image',
			'gender',
			'gende_id',
			'website',
			'linkedin',
			'twitter',
			'company_size',
			'email_send_status',
			'status',
			'created_date',
			'timestamp'
		];

		protected $returnType = 'object';

		public function updateAttendeesDetails($data, $attId){

			$userId = session()->get('loginId'); // login id
			$db = \Config\Database::connect();
			$builder = $db->table('attendees_details');
			$builder->set($data);
			$builder->where(['user_id' => $userId]);
			$builder->where(['id' => $attId]);
			$builder->update();
			return true;
		}
	}
?>