<?php
namespace App\Models;
use CodeIgniter\Model;

class CommonModel extends Model{
	protected $table = 'tbl_registration';
	protected $primaryKey = 'id';
	protected $allowedFields = [
		'name',
		'email_id',
		'mobile_no',
		'company_name',
		'designation',
		'city',
		'event_name',
		'status',
		'created_date',
		'order_id',
		'web_url',
		'interested_in',
		'number_of_day',
		'event_type',
		'industry',
		'other',
		'qty',
		'stall_size',
		'country_code',
		'zoho_record_id',
	];

	protected $returnType = 'object';

	public function contactSubmit($dataArray)
	{
		$db = \Config\Database::connect();
		$builder = $db->table('tbl_enquiry');
		$builder->insert($dataArray);
		return true;
	}

	public function studioSubmit($dataArray)
	{
		$db = \Config\Database::connect();
		$builder = $db->table('tbl_studio');
		$builder->insert($dataArray);
		return true;
	}
	
	public function stallSubmit($dataArray)
	{
		$db = \Config\Database::connect();
		$builder = $db->table('tbl_stall_enquiry');
		$builder->insert($dataArray);
		return true;
	}

	public function brochureSubmit($dataArray)
	{
		$db = \Config\Database::connect();
		$builder = $db->table('tbl_brochure_download');
		$builder->insert($dataArray);
		return true;
	}

	public function updateDelegate($dataArray, $insertedId)
	{
		/*$db = \Config\Database::connect();
		$builder = $db->table('tbl_registartion_delegate');
		$builder->insert($dataArray);
		return true;*/

		$db = \Config\Database::connect();
		$builder = $db->table('tbl_registration');
		$builder->set($dataArray);
		$builder->where(['id' => $insertedId]);
		$builder->update();
		return true;
	}

	public function updateTable($dataArray, $insertedId)
	{
		$db = \Config\Database::connect();
		$builder = $db->table('tbl_registration');
		$builder->set($dataArray);
		$builder->where(['id' => $insertedId]);
		$builder->update();
		return true;
	}

	public function checkCoupon($couponCode)
	{
		$db = \Config\Database::connect();
		$builder = $db->table('coupon_details');
		$builder->where(['coupon_name' => $couponCode]);
		$builder->where(['status' => 0]);
		$query = $builder->get()->getRow();
		// echo $db->getLastQuery();
		return !empty($query) ? $query : false;
	}
}