<?php
namespace App\Models;
use CodeIgniter\Model;

class DelegatePaymentModel extends Model{

	public function updatePaymentStatus($dataAarray)
	{
		$db = \Config\Database::connect();
		$builder = $db->table('tbl_transaction_details');
		$builder->insert($dataAarray);
		return true;
	}

	public function checkCoupon($couponId)
	{
		$db = \Config\Database::connect();
		$builder = $db->table('coupon_details');
		$builder->where(['id' => $couponId]);
		$builder->where(['status' => 0]);
		$query = $builder->get()->getRow();
		// echo $db->getLastQuery();
		return !empty($query) ? $query : false;
	}

	public function getUserDetailsByOrder($orderIdd)
	{
		$db = \Config\Database::connect();
		$builder = $db->table('tbl_registration as user');
		$builder->join('tbl_transaction_details as trans','user.id = trans.user_id');
		$builder->where(['trans.pay_for' => 'delegate']);
		$builder->where(['trans.transaction_status' => 'Success']);
		$builder->where(['trans.order_id' => $orderIdd]);
		$query = $builder->get()->getRow();
		if($query){
			return $query;
		}else{
			return false;
		}
	}

	public function getDelegateDetails($id)
	{
		$db = \Config\Database::connect();
		$builder = $db->table('tbl_registration');
		$builder->where(['id' => $id]);
		$query = $builder->get()->getRow();
		if($query){
			return $query;
		}else{
			return false;
		}
	}

	public function insertDelegate($dataAarray)
	{
		$db = \Config\Database::connect();
		$builder = $db->table('tbl_registartion_delegate');
		$builder->insert($dataAarray);
		return true;
	}

	public function updateGST($insertedId, $gstNo)
	{
		$db = \Config\Database::connect();
		$builder = $db->table('tbl_registration');
		$builder->set(['gst_no' => $gstNo]);
		$builder->where(['id' => $insertedId]);
		$builder->update();
		return true;
	}

	public function getOtherDelegate($insertedId)
	{	
		$db = \Config\Database::connect();
		$builder = $db->table('tbl_registartion_delegate');
		$builder->where(['user_id' => $insertedId]);
		$query = $builder->get()->getResult();
		if($query){
			return $query;
		}else{
			return false;
		}
	}

	public function confirmDetails()
	{
		$insertedId = session()->get('insertedId');
		$userDetails = $this->getDelegateDetails($insertedId);
		$delegateDetails = $this->getOtherDelegate($insertedId);

		$couponDetails = '';
		$inviteSlug = session()->get('inviteSlug');
		if(isset($inviteSlug)){
			$query = $this->getInviteFromSlug($inviteSlug);
			$couponDetails = "Coupon Code: ". $query->coupon_code;
		}

		$str = '';
		 $str .='<div class="container">
		<div class="row d-flex justify-content-center">
			<div class="col-md-10">
				<div class="table-responsive">
					<h4>Order Details - ['.$userDetails->order_id.']</h4>
					<table class="table">
						<tr>
							<th>Name</th>
							<th>Email</th>
							<th>Designation</th>
							<th>Mobile No.</th>
						</tr>';
							
						$i = 1;
						$str .='<tr>';
							$str .='<td>'.$userDetails->name.'</td>';
							$str .='<td>'.$userDetails->email_id.'</td>';
							$str .='<td>'.$userDetails->designation.'</td>';
							$str .='<td>'.$userDetails->mobile_no.'</td>';
						$str .='</tr>';
						
						if(!empty($delegateDetails)){
							foreach($delegateDetails as $delegate){
								$str .='<tr>';
									// $str .='<td>'.$i.'</td>';
									$str .='<td>'.$delegate->name.'</td>';
									$str .='<td>'.$delegate->email_id.'</td>';
									$str .='<td>'.$delegate->designation.'</td>';
									$str .='<td>'.$delegate->mobile_no.'</td>';
								$str .='</tr>';
								$i ++;
							}
						}

						$str .='<tr>
							<td><input type="text" class="form-control" id="couponCode" placeholder="Coupon Code"><br><span>'.$couponDetails.'</span></td>
							<td><button class="primary-button" id="couponApply">Apply Coupon</button></td>
							</tr>';

						$str .='<tr>
							<th><a href="'.BASE_URL.'delegate-payment" class="primary-button">Pay Now</a></th>
						</tr>
					</table>
				</div>
			</div>
			</div>
		</div>';
		return $str;
	}

	public function getInviteFromSlug($slug)
	{
		if(!empty($slug)){
			$db = \Config\Database::connect();
			$builder = $db->table('invities');
			$builder->where(['slug' => $slug]);
			$query = $builder->get()->getRow();
			return !empty($query) ? $query : false;
		}
	}
}