<?php
	namespace App\Models;

	use CodeIgniter\Model;

	class PassesModel extends Model{

		protected $table = 'event_details';
		protected $primaryKey = 'id';
		protected $allowedFields = [
			'event_name',
			'event_time',
			'events_no_of_day',
			'description',
			'event_price',
			'event_status',
			'create_date'
		];

		protected $returnType = 'object';

		function getEventDetails(){
			$db = \Config\Database::connect();
			$builder = $db->table('event_details');
			$builder->where(['event_status' => 0]);
			$result = $builder->get()->getResult();
			return $result;
		}

		function getEventById($eventId){
			$db = \Config\Database::connect();
			$builder = $db->table('event_details');
			$builder->where(['id' => $eventId]);
			$builder->where(['event_status' => 0]);
			$row = $builder->get()->getRow();
			return $row;
		}

		public function setAttDetails($postData)
		{	
			$attData = '';

			for($i = 1; $i <= $postData['qty']; $i++){
				$country = $this->getCountry();
                $gender = $this->getGender();
                $jobRole =$this->getJobRole();

                $collapse = '';
                if($i == 1){
                  $collapse = "show";
                }
				$attData .='<div id="accordion" class="accordion">
                                       <div class="card mb-0">
                                            <div class="card-header collapsed" data-toggle="collapse" href="#collapse'.$i.'">
                                                <a class="card-title">Attendee '.$i.'</a>
                                            </div>
                                                <div id="collapse'.$i.'" class="card-body collapse '.$collapse.'" data-parent="#accordion">
                                                <form id="attndeeForm'.$i.'" method="POST" novalidate="">
                                                 <div class="form-group">
                                                    <input type="email" class="form-control wizard-required" name="attEmail'.$i.'"  id="attEmail'.$i.'" placeholder="Email">
                                                    <!-- <label for="email" class="wizard-form-text-label">Email
                                                    <span class="red-clr">*</span></label> -->
                                                    <div class="wizard-form-error"></div>
                                                 </div>
                                                 <div class="form-group">
                                                    <input type="text" class="form-control wizard-required" id="attFirstName'.$i.'" placeholder="First Name">

                                                    <div class="wizard-form-error"></div>
                                                 </div>
                                                 <div class="form-group">
                                                    <input type="text" class="form-control wizard-required" id="attLastName'.$i.'" placeholder="Last Name">
                                                    
                                                    <div class="wizard-form-error"></div>
                                                 </div>
                                                 <div class="form-group">
                                                    <input type="text" class="form-control wizard-required" id="attCompanyName'.$i.'" placeholder="Company Name">

                                                    <div class="wizard-form-error"></div>
                                                 </div>
                                                 <div class="form-group">
                                                    <select class="form-control" id="attCountry'.$i.'">
                                                    ';
                                                    $attData .= $country;
                                                    $attData .='</select>
                                                    <div class="wizard-form-error"></div>
                                                 </div>
                                                 <div class="form-group">
                                                    <input type="text" class="form-control wizard-required" id="attPostalCode'.$i.'" placeholder="Postal Code">
                                                    <div class="wizard-form-error"></div>
                                                 </div>
                                                 <div class="form-group">
                                                    <select class="form-control" id="attJobRole'.$i.'">';
                                                    $attData .= $jobRole;
                                                    $attData .='</select>
                                                    <div class="wizard-form-error"></div>
                                                 </div>
                                                 <div class="form-group">
                                                    <select class="form-control" id="attGender'.$i.'">';
                                                    $attData .= $gender;

                                                    $attData .='</select>
                                                    <div class="wizard-form-error"></div>
                                                 </div>
                                                 <div class="form-group">
                                                    <input type="text" class="form-control wizard-required" id="attMobileNo'.$i.'" placeholder="Phone Number">
                                                    <div class="wizard-form-error"></div>
                                                 </div>
                                                 <div class="form-group">
                                                    <input type="text" class="form-control wizard-required" id="attCity'.$i.'" placeholder="City">
                                                    
                                                    <div class="wizard-form-error"></div>
                                                 </div>
                                                 <div class="form-group">
                                                    <input type="text" class="form-control wizard-required" id="attState'.$i.'" placeholder="State Name">
                                                    <div class="wizard-form-error"></div>
                                                 </div>
                                                 <div class="form-group">
                                                    <input type="text" class="form-control wizard-required" id="attAddress'.$i.'" placeholder="Address">
                                                    <div class="wizard-form-error"></div>
                                                 </div>
                                                
                                                 <div class="form-group">
                                                    <input type="text" class="form-control wizard-required" id="attDesignation'.$i.'" placeholder="Position in the Company / Organization">
                                                    <div class="wizard-form-error"></div>
                                                 </div>

                                                <!-- <div class="form-group">
                                                    <label>Which of the following best describes your organization / company?<span class="red-clr">*</span></label>
                                                    <div class="form-check">
                                                       <input class="form-check-input" type="radio" name="exampleRadios" id="exampleRadios1" value="option1" checked>
                                                       <label class="form-check-label" for="exampleRadios1">
                                                       Governments
                                                       </label>
                                                    </div>
                                                    <div class="form-check">
                                                       <input class="form-check-input" type="radio" name="exampleRadios" id="exampleRadios2" value="option2" checked>
                                                       <label class="form-check-label" for="exampleRadios2">
                                                       Inter-govermental organization
                                                       </label>
                                                    </div>
                                                    <div class="form-check">
                                                       <input class="form-check-input" type="radio" name="exampleRadios" id="exampleRadios3" value="option3" checked>
                                                       <label class="form-check-label" for="exampleRadios3">
                                                       Institutions & other entities
                                                       </label>
                                                    </div>
                                                    <div class="form-check">
                                                       <input class="form-check-input" type="radio" name="exampleRadios" id="exampleRadios4" value="option4" checked>
                                                       <label class="form-check-label" for="exampleRadios4">
                                                       Academia
                                                       </label>
                                                    </div>
                                                    <div class="form-check">
                                                       <input class="form-check-input" type="radio" name="exampleRadios" id="exampleRadios5" value="option5" checked>
                                                       <label class="form-check-label" for="exampleRadios5">
                                                       Large & Global Companies
                                                       </label>
                                                    </div>
                                                 </div>
                                                 <div class="form-group">
                                                    <select class="form-control">
                                                       <option value="">Governments<span class="red-clr">*</span>
                                                       </option>
                                                       <option value="">Diplomatic Representation</option>
                                                       <option value="">Diplomatic Representation</option>
                                                    </select>
                                                    <div class="wizard-form-error"></div>
                                                 </div> -->
                                                 
                                                 <div class="form-group">
                                                    <input type="text" class="form-control wizard-required" name="attWebsite'.$i.'" id="attWebsite'.$i.'" placeholder="Website">
                                                    <div class="wizard-form-error"></div>
                                                 </div>
                                                 <div class="form-group">
                                                    <input type="text" class="form-control wizard-required" name="attLinkedIn'.$i.'" id="attLinkedIn'.$i.'" placeholder="Linked In">
                                                    <div class="wizard-form-error"></div>
                                                 </div>
                                                 <div class="form-group">
                                                    <input type="text" class="form-control wizard-required" name="attTwitter'.$i.'" id="attTwitter'.$i.'" placeholder="Twitter">

                                                    <div class="wizard-form-error"></div>
                                                 </div>
                                                 <div class="form-group">
                                                    <select class="form-control" name="attCompnaySize'.$i.'" id="attCompnaySize'.$i.'">
                                                       <option value="leass than 10">Less than 10 employees</option>
                                                       <option value="less than 20">Less than 20 employees</option>
                                                       <option value="less than 30">Less than 30 employees</option>
                                                    </select>
                                                    <div class="wizard-form-error"></div>
                                                 </div>
                                                 <div class="form-group">
                                                    <input type="checkbox" name="sendEmail'.$i.'" id="sendEmail'.$i.'">Send pass to the attendee’s email address
                                                 </div>
                                                </form>
                                                <input type="button" class="btn" name="saveAtt'.$i.'" onClick="saveAtt('.$i.')" id="saveAtt'.$i.'" value="Save">
                                            </div>
                                            <input type="hidden" name="attInsert'.$i.'" id="attInsert'.$i.'" value="0">
                                       </div>
                                    </div>';
       		}
       		return $attData;
		}

		public function setPurchaseDetails($postData){

			$eventDetails = $this->getEventById($postData['selectEvent']);

			$total = $postData['qty'] * $eventDetails->event_price;
			$purchaseData = '';
			$purchaseData .= '<div class="right-side-cont mt-4">
                              <div class="right-side-cont-time">
                                 <i class="fa fa-clock-o time-icon" aria-hidden="true"></i> 
                                 <p class="time-txt">Time remaining to complete purchase:</p>
                              </div>
                              <div class="right-side-cont-inner">
                                 <h4>MY PURCHASES</h4>
                                 <div class="intro">
                                    <h5>'.$eventDetails->event_name.'</h5>
                                    <span>'.$postData['qty'].' X <span>&#36;</span>'.$eventDetails->event_price.'</span><span class="float-right"> <span>&#36;</span> '.$total.'</span>
                                 </div>
                                 <div class="total">
                                    <span class="size-18">Total</span> <span class="float-right size-22"><span>&#36;</span> '.$total.'</span>
                                    <!-- <a href="#" class="btn" id="continueBtn">CONTINUE</a> -->
                                    <button type="button" class="btn" id="continueBtn" disabled="disabled">CONTINUE</button>
                                 </div>
                              </div>
                           </div>';

            $purchaseData .='<script>
                  $("#continueBtn").click(function(){
                     $.ajax({
                        type:"post",
                        data:{qty:'.$postData['qty'].', selectEvent:'.$postData['selectEvent'].',billEmail:$("#billEmail").val(),billFirstName:$("#billFirstName").val(),billLastName:$("#billLastName").val(),billCompanyName:$("#billCompanyName").val(),billCountry:$("#billCountry").val(),billPostalCode:$("#billPostalCode").val(),billJobRole:$("#billJobRole").val(),billGender:$("#billGender").val(),billMobileNo:$("#billMobileNo").val(),},
                        url:"get-tickets",
                        dataType:"json",
                        success:function(response){
                            if(response.Status == true){
                                $("#nextBtnHidStep2").click();
                                $("#purchaseDiv1").html("");
                                $("#purchaseDiv2").html("");
                                $("#purchaseDiv1").html(response.PurchaseData);
                                $("#purchaseDiv2").html(response.Data);
                                
                            }
                        }
                    });
                   })
               </script>';

			return $purchaseData;
		}

      public function getPurchaseBillingDetails($postData, $invId)
      {
         $billingInvoice = $this->getBillingInvoice($invId);

         $attendeesDetails = $this->getInvoiceDetails($invId);

         $str = '';

         $str .='<table class="table">';

            $str .='<tr>';
               $str .='<th colspan="3">Billing Information</th>';
            $str .='</tr>';

            $str .='<tr>';
               $str .='<th>Email</th>';
               $str .='<th>Full Name</th>';
               $str .='<th>Mobile Number</th>';
            $str .='</tr>';

            $str .='<tr>';
               $str .='<td>'.$billingInvoice->email_id.'</td>';
               $str .='<td>'.$billingInvoice->first_name. ' '. $billingInvoice->last_name .'</td>';
               $str .='<td>'.$billingInvoice->mobile_no.'</td>';
            $str .='</tr>';


            $str .='<tr>';
               $str .='<th colspan="3">Attendees Details</th>';
            $str .='</tr>';

            foreach($attendeesDetails as $attRow)
            {
               $str .='<tr>';
                  $str .='<td>'.$attRow->email_id.'</td>';
                  $str .='<td>'.$attRow->first_name. ' '. $attRow->last_name .'</td>';
                  $str .='<td>'.$attRow->mobile_no.'</td>';
               $str .='</tr>';
            }

         $str .='</table>';

         return $str;
      }
      
      public function getBillingInvoice($invId)
      {
         $db = \Config\Database::connect();
         $builder = $db->table('invoice');
         $builder->where(['id' => $invId]);
         $row = $builder->get()->getRow();
         return $row;
      }

      public function getInvoiceDetails($invId)
      {
         $db = \Config\Database::connect();
         $builder = $db->table('invoice_details');
         $builder->where(['invoice_id' => $invId]);
         $result = $builder->get()->getResult();
         // return $result;
         $attArray = array();
         foreach($result as $row){
            $attRow = $this->getAttendeesDetails($row->attendees_id);
            array_push($attArray, $attRow);
         }

         return $attArray;
      }

      public function getAttendeesDetails($attendeesId)
      {
         $db = \Config\Database::connect();
         $builder = $db->table('attendees_details');
         $builder->where(['id' => $attendeesId]);
         $row = $builder->get()->getRow();
         return $row;
      }

      public function getPurchaseDetails($postData){

         $eventDetails = $this->getEventById($postData['selectEvent']);

         $total = $postData['qty'] * $eventDetails->event_price;
         $purchaseData = '';
         $purchaseData .= '<div class="right-side-cont mt-4">
                              <div class="right-side-cont-time">
                                 <i class="fa fa-clock-o time-icon" aria-hidden="true"></i> 
                                 <p class="time-txt">Time remaining to complete purchase:</p>
                              </div>
                              <div class="right-side-cont-inner">
                                 <h4>MY PURCHASES</h4>
                                 <div class="intro">
                                    <h5>'.$eventDetails->event_name.'</h5>
                                    <span>'.$postData['qty'].' X <span>&#36;</span>'.$eventDetails->event_price.'</span><span class="float-right"> <span>&#36;</span> '.$total.'</span>
                                 </div>
                                 <div class="total">
                                    <span class="size-18">Total</span> <span class="float-right size-22"><span>&#36;</span> '.$total.'</span>
                                    <button type="button" class="btn" id="continueBtnPayment" >CONTINUE</button>
                                 </div>
                              </div>
                           </div>';

         $purchaseData .='<script>
                           $("#continueBtnPayment").click(function(){
                              window.location = "payment";
                           });
                        </script>';

         return $purchaseData;
      }

		public function getCountry()
		{	
			$db = \Config\Database::connect();
			$builder = $db->table('country');
			$result = $builder->get()->getResult();
			$str = '';
			foreach($result as $row){
				$str .='<option value="'.$row->country_id.'" >'.$row->name.'</option>';
			}
			return $str;
		}

		public function getGender()
		{	
			$db = \Config\Database::connect();
			$builder = $db->table('tbl_gender');
			$result = $builder->get()->getResult();
			$str = '';
			foreach($result as $row){
				$str .='<option value="'.$row->id.'" >'.$row->gender_type.'</option>';
			}
			return $str;
		}

		public function getJobRole()
		{	
			$db = \Config\Database::connect();
			$builder = $db->table('tbl_job_role');
			$result = $builder->get()->getResult();
			$str = '';
			foreach($result as $row){
				$str .='<option value="'.$row->id.'" >'.$row->job_role.'</option>';
			}
			return $str;
		}
	}
?>