<?php
  function getLimitedText($text, $limit) {
      if (strlen($text) > $limit) {
        // Use substr to get the substring up to the limit
        $substring = substr($text, 0, $limit);

        // Find the position of the last space in the substring
        $lastSpacePos = strrpos($substring, ' ');

        // If the last space position is not at the end, truncate at that position
        if ($lastSpacePos !== false && $lastSpacePos < $limit) {
            $limitedText = substr($substring, 0, $lastSpacePos);
        } else {
            // If there are no spaces or the last space is at the end, use the whole substring
            $limitedText = $substring;
        }

        return $limitedText.'..';
      } else {
          // If the text is within the limit, return the original text
          return $text;
      }
  }
?>
<!-- main-area -->
<main>
   <!-- search-popup -->
   <section class="modal fade bs-example-modal-lg search-bg popup1" tabindex="-1" role="dialog">
      <div class="modal-dialog modal-lg" role="document">
         <div class="modal-content search-popup">
            <div class="text-center">
               <a href="#" class="close2" data-dismiss="modal" aria-label="Close">× close</a>
            </div>
            <div class="row search-outer">
               <div class="col-md-11"><input type="text" placeholder="Search for products..." /></div>
               <div class="col-md-1 text-right"><a href="#"><i class="fa fa-search" aria-hidden="true"></i></a></div>
            </div>
         </div>
      </div>
   </section>
   <!-- /search-popup -->
   <!-- slider-area -->
   <section id="home" class="home-section slider-area fix p-relative">
      <div class="">
         <div class="single-slider slider-bg show-bg3 d-flex">
            
            <div class="container">
               <div class="row justify-content-center">
                  <div class="col-lg-5">
                     <div class="slider-content s-slider-content mt-100">
                      <img src="assets-home/img/NHBF-IRO.png">
                        <h2 data-animation="fadeInUp" data-delay=".4s">Asia's Biggest Road Exhibition </h2>
                        <!-- <h3 data-animation="fadeInUp" data-delay=".6s">Cost-Efficiency <span>| </span>Automation <span>|</span> Skilling <span>|</span> Energy-Efficiency</h3>-->
                        <h3 data-animation="fadeInUp" data-delay=".6s">
                            8<sup>th</sup> - 9<sup>th</sup> July 2026
                           <span>
                        </h3>
                        <h5 class="text-white" data-animation="fadeInUp" data-delay=".6s">Jio World Convention Centre Mumbai<span></h5> 
                     </div>
                  </div>
                  <div class="col-lg-7">
                  <section class="drybn-clap-board">

                  <div class="drybn-clap-board__overlay">
                  <div class="drybn-clap-board__content">

                  <div class="drybn-clap-board__item drybn-clap-board__item--expanded">
                  <div class="drybn-clap-item__overlay">
                  <div class="drybn-clap-item__content">
                  <header class="drybn-clap-item__header">
                  <h2 class="drybn-clap-item__title">Visitor</h2>
                  </header>
                  <div class="drybn-clap-item__body">
                  <div class="drybn-profile">
                  <p class="profile-info role">Step into a world of innovation, inspiration, and endless possibilities at The RAHSTA Expo 2025! As a visitor, you're invited to embark on a journey of discovery unlike any other. </p>
                  <p>Register now and get a one month free-copy of Construction World Magazine instantly.</p>
                  <div class="row">
                      <div class="col-lg-4">
                          <img src="assets-home/img/CW-cover.jpg" class="img-fluid">
                      </div>
                  </div>
                  <!-- <a href="https://rahstaexpo.com/register?eventType=Visitor" target="_blank" class="primary-button">Register Now</a> -->
                 <button class="primary-button" id="visitorBtnh">Register Now</button> 
                  </div>
                  </div>
                  <picture class="drybn-clap-item__art">
                  <img src="assets-home/img/visitor.jpg" />
                  </picture>
                  </div>
                  </div>
                  </div>

                  <div class="drybn-clap-board__item">
                  <div class="drybn-clap-item__overlay">
                  <div class="drybn-clap-item__content">
                  <header class="drybn-clap-item__header">
                  <h2 class="drybn-clap-item__title">Delegate</h2>
                  </header>
                  <div class="drybn-clap-item__body">
                  <div class="drybn-profile">
                  <p class="profile-info role">Seize the chance to network with industry experts, thought leaders, and fellow professionals at The RAHSTA Expo 2025! As a delegate, you'll gain exclusive access to high-profile networking events, engaging panel discussions, and hands-on workshops</p>
                  <p>Register now for a Premium/ VIP pass - Get a one-year free subscription to Construction World Magazine & Project Reporter and stay ahead of your competition!</p>
                  <!-- <a href="https://rahstaexpo.com/register?eventType=Delegate" target="_blank" class="primary-button">Register Now</a> -->
                   <div class="row">
                      <div class="col-lg-6">
                          <img src="assets-home/img/CW-PR-cover.png" class="img-fluid">
                      </div>
                  </div>
                   <button class="primary-button" id="delegateFormBtnh">Register Now</button> 
                  </div>
                  </div>
                  <picture class="drybn-clap-item__art">
                  <img src="assets-home/img/delegate.jpg" />
                  </picture>
                  </div>
                  </div>
                  </div>
                  
                  <div class="drybn-clap-board__item">
                  <div class="drybn-clap-item__overlay">
                  <div class="drybn-clap-item__content">
                  <header class="drybn-clap-item__header">
                  <h2 class="drybn-clap-item__title title-one">Exhibitor</h2>
                  </header>
                  <div class="drybn-clap-item__body">
                  <div class="drybn-profile">
                  <p class="profile-info role">Showcase your latest innovations and connect with a diverse audience at The RAHSTA Expo 2025! As an exhibitor, you'll have the opportunity to present your products and services to a captivated audience, network with industry leaders, and make lasting impressions.</p>
                  <p>Register now and get a one month free-copy of Construction World Magazine instantly.</p>
                  <!-- <a href="https://rahstaexpo.com/register?eventType=Exhibitor" target="_blank" class="primary-button">Register Now</a> -->
                  <div class="row">
                      <div class="col-lg-4">
                          <img src="assets-home/img/CW-cover.jpg" class="img-fluid">
                      </div>
                  </div>
                   <button class="primary-button" id="exhibitorBtnh">Book Your Space</button> 
                  </div>
                  </div>
                  <picture class="drybn-clap-item__art">
                  <img src="assets-home/img/Exhibitor.jpg" />
                  </picture>
                  </div>
                  </div>
                  </div>
                 
                  <div class="drybn-clap-board__item">
                  <div class="drybn-clap-item__overlay">
                  <div class="drybn-clap-item__content">
                  <header class="drybn-clap-item__header">
                  <h2 class="drybn-clap-item__title">Sponsor</h2>
                  </header>
                  <div class="drybn-clap-item__body">
                  <div class="drybn-profile">
                  <p class="profile-info role">Position your brand at the forefront of innovation and industry leadership by becoming a sponsor of The RAHSTA Expo 2025! As a sponsor, you'll enjoy unparalleled visibility, access to key decision-makers, and the opportunity to showcase your products and services to a highly engaged audience.</p>
                  <p>Register now and get a one month free-copy of Construction World Magazine instantly.</p>
                  <!-- <a href="https://rahstaexpo.com/register?eventType=Sponsor" target="_blank" class="primary-button">Register Now</a> -->
                  <div class="row">
                      <div class="col-lg-4">
                          <img src="assets-home/img/CW-cover.jpg" class="img-fluid">
                      </div>
                  </div>
                  <button class="primary-button" id="sponserBtnh">Register Now</button> 
                  </div>
                  </div>
                  <picture class="drybn-clap-item__art">
                  <img src="assets-home/img/sponsor.jpg" />
                  </picture>
                  </div>
                  </div>
                  </div> 
                   <!-- <div class="drybn-clap-board__item">
                  <div class="drybn-clap-item__overlay">
                  <div class="drybn-clap-item__content">
                  <header class="drybn-clap-item__header">
                  <h2 class="drybn-clap-item__title">Awards</h2>
                  </header>
                  <div class="drybn-clap-item__body">
                  <div class="drybn-profile">
                  <p class="profile-info role">RAHSTA Awards 2025 recognize excellence in road and highway innovation, construction and technology. Nominate projects, products or individuals setting new benchmarks in infrastructure. Nominate Now </p>
                  <a class="primary-button" href="https://rahstaexpo.com/nomination">Nominate Now</a> 
                  </div>
                  </div>
                  <picture class="drybn-clap-item__art">
                  <img src="assets-home/img/awards.jpg" />
                  </picture>
                  </div>
                  </div>
                  </div>  -->
                  </div>
                  </div>
                  </section> 
                  </div> 
               </div>
            </div>
            <!-- video -->
            <video id="my-video" class="video2" muted loop autoplay>
            <!-- <source src="assets-home/videos/metro.mp4" type="video/mp4"> -->
            <source src="assets-home/videos/Rashta-expo.mp4" type="video/mp4">
            <source src="assets-home/videos/metro.ogv" type="video/ogg">
            <source src="assets-home/videos/metro.webm" type="video/webm">
            </video><!-- /video -->
         </div>
      </div>
   </section>
   <!-- slider-area-end -->
   <!-- services-area -->
   <!-- <section id="feature-top" class="services-area services-bg services-two">
      <div class="container">
      
      
      
          <div class="row">
      
              <div class="col-lg-4 col-md-12">
      
                  <div class="s-single-services active ">
      
                      <div class="services-icon">
      
                          <div class="glyph-icon flaticon-document"></div>
      
                      </div>
      
                      <div class="services-icon2">
      
                          <div class="glyph-icon flaticon-document"></div>
      
                      </div>
      
                      <div class="second-services-content">
      
                          <h5>2 DAYS OF NETWORKING</h5>       
      
                          <p>Network with your industry colleagues and create valuable supply contacts.</p>
      
                          
                      </div>
      
                      
      
                  </div>
      
              </div>
      
              <div class="col-lg-4 col-md-12">
      
                   <div class="s-single-services ">
      
                      <div class="services-icon icon-f2">
      
                         <div class="glyph-icon flaticon-document"></div>
      
                      </div>
      
                       <div class="services-icon2">
      
                         <div class="glyph-icon flaticon-document"></div>
      
                      </div>
      
                      <div class="second-services-content">
      
                          <h5>35+ SPEAKERS IN PAST EVENT</h5>       
      
                          <p>Industry Stalwarts will share their insights on the cement industry.</p>
      
                            
      
                      </div>
      
                      
      
                  </div>
      
              </div>
      
              <div class="col-lg-4 col-md-12">
      
                  <div class="s-single-services ">
      
                      <div class="services-icon">
      
                       <div class="glyph-icon flaticon-edition"></div>
      
                      </div>
      
                      <div class="services-icon2">
      
                       <div class="glyph-icon flaticon-edition"></div>
      
                      </div>
      
                      <div class="second-services-content">
      
                          <h5>50+ EXHIBITORS IN PAST EVENT</h5>       
      
                      <p>Gain maximum visibility for your innovative products/techbnologies and solutions</p>
      
                         
                      </div>
      
                      
      
                  </div>
      
              </div>
      
            
      
              
      
          </div>
      
          
      
      </div>
      
      </section>-->
 <section id="key-statis">
   <div class="fact-counter-section gray-bg">
   <div class="fact-counter">
   <div class="container">
   <div class="section-heading mb-2">
   <!-- <h1 class="section-title text-white">KEY</span> FACTS</span></h1> -->
   </div>
  <!--  <p class="text-center text-white mb-80">India's growth on display: Witness the power of infrastructure investment firsthand, with stats like:</p> -->
   <div class="row clearfix"> 
   <!--Column-->
   <div class="column counter-column col-lg-4 col-md-4 col-sm-12 border-right">
   <div class="inner wow fadeInUp" data-wow-delay="0ms" data-wow-duration="1500ms">
   <div class="count-outer count-box"> <span class="icon1"><img src="https://rahstaexpo.com/assets-home/img/bg/Visitors-Icon.png"></span> <span class="count-text" data-speed="4500" data-stop="10000">0</span> +
   <h4 class="counter-title">Visitors</h4>
   <!-- <p>India's staggering road network, the second-largest in the world.</p> -->
   </div>
   </div>
   </div>
   <!--Column-->
   <div class="column counter-column col-lg-4 col-md-4 col-sm-12 border-right">
   <div class="inner wow fadeInUp" data-wow-delay="300ms" data-wow-duration="1500ms">
   <div class="count-outer count-box"> <span class="icon1"><img src="https://rahstaexpo.com/assets-home/img/bg/Exhibitors-Icon.png"></span> <span class="count-text" data-speed="4500" data-stop="200">0</span> +
   <h4 class="counter-title">Exhibitors</h4>
   <!-- <p>National Highways have skyrocketed since 2013, a testament to India's ambition.</p> -->
   </div>
   </div>
   </div>
   <!--Column-->
   <div class="column counter-column col-lg-4 col-md-4 col-sm-12">
   <div class="inner wow fadeInUp" data-wow-delay="600ms" data-wow-duration="1500ms">
   <div class="count-outer count-box"> <span class="icon1"><img src="https://rahstaexpo.com/assets-home/img/bg/Speakers-Icon.png"></span>  <span class="count-text" data-speed="4500" data-stop="50">0</span> +
   <h4 class="counter-title">Speakers</h4>
   
   </div>
   </div>
   </div>
   </div>
   </div>
   </div>
   <!--<div class="outer-image"><img src="https://mbphenix.com/assetsnew/images/resource/image-1.png" alt="" /></div>--> 
   </div>
   </section>


   <section class="fact-counter-section" style="background-image:url(assets-home/img/fact-bg.jpg);padding:90px 0px 90px 0px;">
      <div class="container">
         <div class="section-heading">
            <h1 class="section-title text-white">Endorsements from  Government</h1>
            <p class="text-white text-center">We're honored to receive words of encouragement and support from key policymakers driving India’s infrastructure growth.</p>
         </div>
         <div class="row">
            <div class="col-lg-6 col-md-6 col-sm-6 col-12 wow zoomIn">
              <img src="assets-home/img/Nitin-Gadkari-CF.jpg" class="img-fluid img-thumbnail">
             </div>
            <div class="col-lg-6 col-md-6 col-sm-6 col-12 wow zoomIn">
               <img src="assets-home/img/Aviation-Ministry.jpg" class="img-fluid img-thumbnail">
               
            </div>
         </div>
      </div>
   </section>

   <section class="about-sec">
   <div class="container">
   <div class="section-heading">
   <h1 class="section-title">ABOUT US</h1>
   </div>
   <div class="row">
   <div class="col-lg-8 col-md-8 col-sm-8 col-12 wow fadeInLeft">
   <!-- <div class="about-text1">
      <h4>ROADS & HIGHWAYS RAHSTA EXPO 2025: Where the road to the future gets paved</h4>
      </div> -->
   <p class="about-size"> RAHSTA (Roads and Highways Sustainable Technologies & Advancement) is back, and it’s bigger, better, and more impactful than ever! Following the immense success of RAHSTA Expo 2024, we are proud to present the next edition of this groundbreaking event. Organized by the FIRST Construction Council, a trailblazer in India’s infrastructure sector, RAHSTA 2025 promises to be a hub for innovation, collaboration, and forward-thinking solutions in the world of road construction.</p>
   <p class="about-size">As the industry continues to evolve, RAHSTA 2025 is dedicated to advancing the integration of sustainable technologies, cutting-edge machinery, and smart practices in road infrastructure development. This year, we continue to unite industry leaders, experts, and changemakers who are passionate about transforming the way we build, maintain, and innovate our roadways.</p>
   <p class="about-size">With two days of engaging discussions, hands-on demonstrations, and groundbreaking exhibitions, RAHSTA 2025 is your premier platform to explore the future of sustainable road construction. Join us as we shape the roads of tomorrow, fostering a cleaner, greener, and more connected world for future generations.</p>
  <!--  <p><strong><a href="<?php echo BASE_URL;?>about" target="_blank">RAHSTA EXPO: Why Should You Choose Us?</strong></a></p>
   <p><strong><a href="<?php echo BASE_URL;?>about" target="_blank">Benefits of Participating at The RAHSTA EXPO 2025</strong></a></p>
   <p><strong><a href="<?php echo BASE_URL;?>about" target="_blank">What to Expect at RAHSTA EXPO?</strong></a></p> -->
   <a href="<?php echo BASE_URL;?>about" target="_blank" class="primary-button mt-3">Read More<i class="fa fa-arrow-right"></i></a> 
   </div>
   <!-- <div class="list">
      <ul>
          <li class="wow fadeInUp">First EXPO focused on road construction - The RAHSTA Expo 2025 is the first of its kind, highlighting the need for an EXPO dedicated to the road infrastructure industry.</li>
          <li class="wow fadeInUp" data-wow-delay="100ms" data-wow-duration="1500ms">Connect with key decision-makers: - Meet road contractors from around the country and showcase your solutions to them</li>
          <li class="wow fadeInUp" data-wow-delay="300ms" data-wow-duration="1500ms">Hosted at the centrally located Jio World Centre at Bandra Kurla Complex at the Jio Convention Centre</li>
          
      </ul>
      <a href="<?php echo BASE_URL;?>about" target="_blank" class="primary-button mt-3">Read More<i class="fa fa-arrow-right"></i></a> 
      </div>
      </div> -->
   <div class="col-lg-4 col-md-4 col-sm-4 col-12 wow fadeInRight">
   <img src="assets-home/img/about-expo1.jpg" class="img-fluid img-thumbnail">
   </div>
   </div>
   </div>
   </section>
   <section id="key-statis">
   <div class="fact-counter-section" style="background-image:url(assets-home/img/fact-bg.jpg);padding:90px 0px 90px 0px;">
   <div class="fact-counter">
   <div class="container">
   <div class="section-heading mb-2">
   <h1 class="section-title text-white">KEY</span> FACTS</span></h1>
   </div>
   <p class="text-center text-white mb-80">India's growth on display: Witness the power of infrastructure investment firsthand, with stats like:</p>
   <div class="row clearfix"> 
   <!--Column-->
   <div class="column counter-column col-lg-4 col-md-4 col-sm-12">
   <div class="inner wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
   <div class="count-outer count-box"> <span class="icon"><img src="assets-home/img/icon/roads.png" class="key-top-icon"></span> <span class="count-text" data-speed="2200" data-stop="6.3">0</span>
   <h4 class="counter-title">Million km</h4>
   <p>India's staggering road network, the second-largest in the world.</p>
   </div>
   </div>
   </div>
   <!--Column-->
   <div class="column counter-column col-lg-4 col-md-4 col-sm-12">
   <div class="inner wow fadeInLeft" data-wow-delay="300ms" data-wow-duration="1500ms">
   <div class="count-outer count-box"> <span class="icon "><img src="assets-home/img/icon/Highway.png" class="key-top-icon"></span> <span class="count-text" data-speed="2500" data-stop="59">0</span>%
   <h4 class="counter-title">Growth</h4>
   <p>National Highways have skyrocketed since 2013, a testament to India's ambition.</p>
   </div>
   </div>
   </div>
   <!--Column-->
   <div class="column counter-column col-lg-4 col-md-4 col-sm-12">
   <div class="inner wow fadeInLeft" data-wow-delay="600ms" data-wow-duration="1500ms">
   <div class="count-outer count-box"> <span class="icon"><img src="assets-home/img/icon/rupees.png" class="key-top-icon"></span> Rs <span class="count-text" data-speed="2200" data-stop="2.6">0</span> 
   <h4 class="counter-title">Trillion</h4>
   <p>The 2023 budget, with a projected 25% rise in 2025, fuels India's infrastructure engine.</p>
   </div>
   </div>
   </div>
   </div>
   </div>
   </div>
   </div>
   </section>
   <section class="about-sec">
      <div class="container">
         <div class="section-heading">
            <h1 class="section-title">Secure your spot for all the right reasons – find out why!</h1>
         </div>
         <div class="row">
            <div class="col-lg-6 col-md-6 col-sm-6 col-12 wow fadeInLeft">
               <div class="about-text1">
                  <h4>For Exhibitors:</h4>
               </div>
               <div class="list">
                  <ul>
                     <li class="wow fadeInUp">Generate 100+ leads: Showcase your offerings to thousands of potential clients and partners.</li>
                     <li class="wow fadeInUp" data-wow-delay="100ms" data-wow-duration="1500ms">Close deals worth lakhs: Network with decision-makers and unlock lucrative business opportunities.</li>
                     <li class="wow fadeInUp" data-wow-delay="300ms" data-wow-duration="1500ms">Become a thought leader: Position your brand at the forefront of innovation and sustainability.</li>
                  </ul>
               </div>
            </div>
            <div class="col-lg-6 col-md-6 col-sm-6 col-12 wow fadeInRight">
               <div class="about-text1">
                  <h4>For Delegates:</h4>
               </div>
               <div class="list">
                  <ul>
                     <li class="wow fadeInUp">Gain cutting-edge knowledge: Learn from industry experts and discover solutions to your challenges.</li>
                     <li class="wow fadeInUp" data-wow-delay="100ms" data-wow-duration="1500ms">Connect with influential individuals: Establish valuable relationships and partnerships that advance your career.</li>
                     <li class="wow fadeInUp" data-wow-delay="300ms" data-wow-duration="1500ms">Shape the future of roads: Be part of the conversation that defines India's infrastructure landscape.</li>
                  </ul>
               </div>
            </div>
            <p>Don't just pave the path, revolutionize it!</p>
            <p>Join us at ROADS & HIGHWAYS RAHSTA EXPO 2025 and be the driving force behind India's infrastructure revolution.</p>
         </div>
          <div class="row d-flex justify-content-center">
            <a href="<?php echo BASE_URL;?>register" target="_blank" class="primary-button mt-3">Register Now<i class="fa fa-arrow-right"></i></a> 
         </div> 
      </div>
   </section>
   <!-- <section id="cta" class="cta">
      <div class="container wow zoomIn">
        <div class="row">
          <div class="col-lg-6 col-md-6 col-sm-6 col-12">
         <div class="text-center">
            <h3>RAHSTA Expo Past Exhibitors</h3>
          

           <div class="table-responsive">
            <table class="table table-bordered table-striped text-white">
                <thead>  
                  <tr>
                  <th>Company Name</th>
                
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td>Utkarsh India Limited</td>
                
                </tr>
                <tr>
                  <td>Action Construction Equipment Limited</td>
                  
                </tr>
                <tr>
                  <td>Prashant Advanced Survey LLP</td>
                  
                </tr>
                <tr>
                  <td>Intelligent Business Computer Sys Pvt Ltd</td>
                  
                </tr>
                <tr>
                  <td>UltraTech Cement Limited</td>
                  
                </tr>
                <tr>
                  <td>My Value Pack Retail Pvt Ltd</td>
                  
                </tr>

              </tbody>

            </table>
        </div>
            <a class="primary-button mt-3" href="<?php echo BASE_URL;?>exhibitor-profile">View More</a>
         </div>
       </div>

       <div class="col-lg-6 col-md-6 col-sm-6 col-12">
        <h3 class="text-center">Floor Plan</h3>

       <a href="https://rahstaexpo.com/assets-home/img/Pavilion-Floor-Plan.jpg" target="_blank"> <img src="assets-home/img/Pavilion-Floor-Plan.jpg" class="img-fluid img-thumbnail"></a>
       </div>

       </div>
      </div>

   </section> -->

    <div id="lgx-sponsors" class="lgx-sponsors lgx-sponsors-black">
        <div class="lgx-inner-bg">
            <div class="lgx-inner">
                <div class="container">
                   <div class="section-heading mb-2">
        <h1 class="section-title text-white">Sponsors</h1>
      </div>
                 
                    <div class="sponsors-area sponsors-area-bg">
                   
                   <div class="row d-flex justify-content-center">

                    <div class="col-lg-3 col-md-3 col-sm-3 col-6 wow fadeInUp" data-wow-delay="0ms" data-wow-duration="1500ms">
                      <div class="single">
                             <a href="https://www.electrotherment.com/">
                        <img src="https://rahstaexpo.com/assets-home/img/clients/Electrotherm.jpg" alt="sponsor" class="">
                          </a>
                      </div>
                      </div>
                        <div class="col-lg-3 col-md-3 col-sm-3 col-6 wow fadeInUp" data-wow-delay="100ms" data-wow-duration="1500ms">
                        <div class="single">
                                <a class="" href="https://www.bkt-tires.com/in/en/">
                                    <img src="assets-home/img/clients/BKT.jpg" alt="sponsor">
                                </a>
                          </div>
                      </div> 

                      <div class="col-lg-3 col-md-3 col-sm-3 col-6 wow fadeInUp" data-wow-delay="0ms" data-wow-duration="1500ms">
                      <div class="single">
                             <a href="https://www.tatahitachi.co.in/">
                      <img src="https://rahstaexpo.com/assets-home/img/clients/Tata-Hitachi.jpg" alt="sponsor" class="">
                          </a>
                      </div>
                      </div>

                      <div class="col-lg-3 col-md-3 col-sm-3 col-6 wow fadeInUp" data-wow-delay="0ms" data-wow-duration="1500ms">
                      <div class="single">
                  <a href="https://www.elegantsteels.com">
                  <img src="https://rahstaexpo.com/assets-home/img/clients/Elegant.jpg" alt="sponsor" class="">
                  </a>
                      </div>
                      </div>

                        </div>
                        <div class="row d-flex justify-content-center">
                      <a class="primary-button mt-3" href="<?php echo BASE_URL;?>partner">More Partners</a>
                       
                      </div>
                      
                      </div>



                   </div>
                    </div>
                </div>
                <!--//container-->
            </div>
        </div>
        <!--//lgx-inner-->
    </div>
   <section class="gallery-sec wow zoomIn">
      <div class="container">
         <div class="section-heading">
            <h1 class="section-title">GALLERY</h1>
         </div>
         <div class="row">
            <div class="col-lg-3 col-sm-3 col-sm-3 col-12 mb-3">
               <a href="assets-home/img/gallery/CWGA/1.jpg" data-fancybox="gallery" data-caption="">
               <img src="assets-home/img/gallery/CWGA/1.jpg" class="img-fluid" alt="Image Gallery">
               </a>
            </div>
            <div class="col-lg-3 col-sm-3 col-sm-3 col-12 mb-3">
               <a href="assets-home/img/gallery/CWGA/2.jpg" data-fancybox="gallery" data-caption="">
               <img src="assets-home/img/gallery/CWGA/2.jpg" class="img-fluid" alt="Image Gallery">
               </a>
            </div>
            <div class="col-lg-3 col-sm-3 col-sm-3 col-12 mb-3">
               <a href="assets-home/img/gallery/CWGA/3.jpg" data-fancybox="gallery" data-caption="">
               <img src="assets-home/img/gallery/CWGA/3.jpg" class="img-fluid" alt="Image Gallery">
               </a>
            </div>
            <div class="col-lg-3 col-sm-3 col-sm-3 col-12 mb-3">
               <a href="assets-home/img/gallery/CWGA/4.jpg" data-fancybox="gallery" data-caption="">
               <img src="assets-home/img/gallery/CWGA/4.jpg" class="img-fluid" alt="Image Gallery">
               </a>
            </div>
            <div class="col-lg-3 col-sm-3 col-sm-3 col-12 mb-3">
               <a href="assets-home/img/gallery/CWGA/5.jpg" data-fancybox="gallery" data-caption="">
               <img src="assets-home/img/gallery/CWGA/5.jpg" class="img-fluid" alt="Image Gallery">
               </a>
            </div>
            <div class="col-lg-3 col-sm-3 col-sm-3 col-12 mb-3">
               <a href="assets-home/img/gallery/CWGA/6.jpg" data-fancybox="gallery" data-caption="">
               <img src="assets-home/img/gallery/CWGA/6.jpg" class="img-fluid" alt="Image Gallery">
               </a>
            </div>
            <div class="col-lg-3 col-sm-3 col-sm-3 col-12 mb-3">
               <a href="assets-home/img/gallery/CWGA/7.jpg" data-fancybox="gallery" data-caption="">
               <img src="assets-home/img/gallery/CWGA/7.jpg" class="img-fluid" alt="Image Gallery">
               </a>
            </div>
            <div class="col-lg-3 col-sm-3 col-sm-3 col-12 mb-3">
               <a href="assets-home/img/gallery/CWGA/8.jpg" data-fancybox="gallery" data-caption="">
               <img src="assets-home/img/gallery/CWGA/8.jpg" class="img-fluid" alt="Image Gallery">
               </a>
            </div>
         </div>
         <div class="row d-flex justify-content-center">
            <a href="<?php echo BASE_URL;?>gallery" target="_blank" class="primary-button mt-3">View More<i class="fa fa-arrow-right"></i></a> 
         </div>
      </div>
   </section>

   <div id="lgx-sponsors" class="lgx-sponsors lgx-sponsors-black">
        <div class="lgx-inner-bg">
            <div class="lgx-inner">
                <div class="container">
                   <div class="section-heading mb-2">
        <h1 class="section-title text-white">Exhibitors</h1>
      </div>
                  
            <div class="sponsors-area sponsors-area-bg">
 <div class="client-slider">
        <div class="slider__item">
          <div class="single">
              <img src="assets-home/img/clients/2025/Aadi-Industries.jpg" alt="sponsor">
          </div>
         
        </div>
        <div class="slider__item">
           <div class="single">
              <img src="assets-home/img/clients/2025/Acme.jpg" alt="sponsor">
          </div>
        </div>
        <div class="slider__item">
            <div class="single">
              <img src="assets-home/img/clients/2025/Aeroscan.jpg" alt="sponsor">
          </div>
         
        </div>
        <div class="slider__item">
            <div class="single">
              <img src="assets-home/img/clients/2025/ALCOLITE.jpg" alt="sponsor">
          </div>
         
        </div>
        <div class="slider__item">
            <div class="single">
              <img src="assets-home/img/clients/2025/Astral.jpg" alt="sponsor">
          </div>
          
        </div>
        <div class="slider__item">
            <div class="single">
              <img src="assets-home/img/clients/2025/CAC.jpg" alt="sponsor">
          </div>
         
        </div>
        <div class="slider__item">
            <div class="single">
              <img src="assets-home/img/clients/2025/Classic-RMC.jpg" alt="sponsor">
          </div>
         
        </div>
         <div class="slider__item">
            <div class="single">
              <img src="assets-home/img/clients/2025/Flu-tech.jpg" alt="sponsor">
          </div>
         
        </div>
        <div class="slider__item">
            <div class="single">
              <img src="assets-home/img/clients/2025/Ginni-Spectra.jpg" alt="sponsor">
          </div>
         
        </div>
        <div class="slider__item">
            <div class="single">
              <img src="assets-home/img/clients/2025/GOEL-PIPES.jpg" alt="sponsor">
          </div>
         
        </div>
        <div class="slider__item">
            <div class="single">
              <img src="assets-home/img/clients/2025/Graphias.jpg" alt="sponsor">
          </div>
         
        </div>
        <div class="slider__item">
            <div class="single">
              <img src="assets-home/img/clients/2025/Hindustan-Road-Equipments.jpg" alt="sponsor">
          </div>
         
        </div>
        <div class="slider__item">
            <div class="single">
              <img src="assets-home/img/clients/2025/Imon.jpg" alt="sponsor">
          </div>
         
        </div>
        <div class="slider__item">
            <div class="single">
              <img src="assets-home/img/clients/2025/JIL.jpg" alt="sponsor">
          </div>
         
        </div>
        <div class="slider__item">
            <div class="single">
              <img src="assets-home/img/clients/2025/Kaushik.jpg" alt="sponsor">
          </div>
         
        </div>
        <div class="slider__item">
            <div class="single">
              <img src="assets-home/img/clients/2025/Lubeco-Greases.jpg" alt="sponsor">
          </div>
         
        </div>
        <div class="slider__item">
            <div class="single">
              <img src="assets-home/img/clients/2025/MRF.jpg" alt="sponsor">
          </div>
         
        </div>
        <div class="slider__item">
            <div class="single">
              <img src="assets-home/img/clients/2025/ORAFOL.jpg" alt="sponsor">
          </div>
         
        </div>

        <div class="slider__item">
            <div class="single">
              <img src="assets-home/img/clients/2025/Plurimo.jpg" alt="sponsor">
          </div>
         
        </div>
        <div class="slider__item">
            <div class="single">
              <img src="assets-home/img/clients/2025/PRIMA.jpg" alt="sponsor">
          </div>
         
        </div>
        <div class="slider__item">
            <div class="single">
              <img src="assets-home/img/clients/2025/Punjab-General.jpg" alt="sponsor">
          </div>
         
        </div>
        <div class="slider__item">
            <div class="single">
              <img src="assets-home/img/clients/2025/Radiant-Power.jpg" alt="sponsor">
          </div>
         
        </div>
        <div class="slider__item">
            <div class="single">
              <img src="assets-home/img/clients/2025/Scon-Infra.jpg" alt="sponsor">
          </div>
         
        </div>
        <div class="slider__item">
            <div class="single">
              <img src="assets-home/img/clients/2025/SKD-Composites.jpg" alt="sponsor">
          </div>
         
        </div>
        <div class="slider__item">
            <div class="single">
              <img src="assets-home/img/clients/2025/Suntech-Geosynthetics.jpg" alt="sponsor">
          </div>
         
        </div>
        <div class="slider__item">
            <div class="single">
              <img src="assets-home/img/clients/2025/TechFab.jpg" alt="sponsor">
          </div>
         
        </div>
        <div class="slider__item">
            <div class="single">
              <img src="assets-home/img/clients/2025/Technobit.jpg" alt="sponsor">
          </div>
         
        </div>
        <div class="slider__item">
            <div class="single">
              <img src="assets-home/img/clients/2025/Terex.JPG" alt="sponsor">
          </div>
         
        </div>
        <div class="slider__item">
            <div class="single">
              <img src="assets-home/img/clients/2025/Vizcol.jpg" alt="sponsor">
          </div>
         
        </div>
        <div class="slider__item">
            <div class="single">
              <img src="assets-home/img/clients/2025/SRMB.jpg" alt="sponsor">
          </div>
         
        </div>

         <div class="slider__item">
            <div class="single">
              <img src="assets-home/img/clients/2025/Elegant.jpg" alt="sponsor">
          </div>
         
        </div>

         <div class="slider__item">
            <div class="single">
              <img src="assets-home/img/clients/2025/shyam-metalics.jpg" alt="sponsor">
          </div>
         
        </div>

         <div class="slider__item">
            <div class="single">
              <img src="assets-home/img/clients/2025/Liugong.jpg" alt="sponsor">
          </div>
         
        </div>

      </div>

                    </div>
                </div>
                <!--//container-->
            </div>
        </div>
        <!--//lgx-inner-->
    </div>
   <section class="fact-counter-section" style="background-image:url(assets-home/img/fact-bg.jpg);padding:90px 0px 90px 0px;">
      <div class="container">
         <div class="section-heading">
            <h1 class="section-title text-white">11th India Construction Festival</h1>
         </div>
         <div class="row">
            <div class="col-lg-6 col-md-6 col-sm-6 col-12 wow zoomIn">
               <p class="text-white">The 11th India Construction Festival will be the umbrella event which will have the RAHSTA EXPO 2025 as part of it will also include the following:</p>
               <div class="icf-sec">
                  <ul>
                     <li class="wow fadeInUp"><a href="https://rahstaexpo.com/" target="_blank">15th India The RAHSTA (Roads & Highways) Conference</a></li>
                     <li class="wow fadeInUp" data-wow-delay="100ms" data-wow-duration="1500ms">
                        <a href="https://rahstaexpo.com/nomination" target="_blank">RAHSTA Awards 2025</a>
                     </li>
                     <li class="wow fadeInUp" data-wow-delay="300ms" data-wow-duration="1500ms">
                        <a href="https://equipmentindia.com/awards/" target="_blank"> 13th Equipment India Awards</a>
                     </li>
                     <li class="wow fadeInUp" data-wow-delay="500ms" data-wow-duration="1500ms">
                        <a href="https://www.constructionworld.in/awards/" target="_blank"> 23rd Construction World Global Awards</a>
                     </li>

                     <li class="wow fadeInUp" data-wow-delay="500ms" data-wow-duration="1500ms">
                        <a href="https://cwabawards.com/" target="_blank"> 20th CONSTRUCTION WORLD Architect and Builder </a>
                     </li>
                  </ul>
               </div>
            </div>
            <div class="col-lg-6 col-md-6 col-sm-6 col-12 wow zoomIn">
               <img src="assets-home/img/ICF-sec-new.png" class="img-fluid animated1">
               <p class="text-white text-center mt-3">Roads - Bridges - Highways - Tunnels</p>
            </div>
         </div>
      </div>
   </section>
   <section class="ts-blog section-bg about-sec">
      <div class="container">
         <div class="row">
            <div class="col-lg-12">
               <div class="section-heading">
                  <h1 class="section-title">News</h1>
               </div>
            </div>
            <!-- col end-->
         </div>
         <!-- row end-->
         <div class="row">

            <?php
                foreach($articles as $article){
                  $description = getLimitedText($article->short_description, 68);
            ?>
            <div class="col-lg-4 wow fadeInUp" data-wow-duration="1.5s" data-wow-delay="400ms">
                <div class="post">
             <div class="post-media post-image">
               <a href="<?php echo BASE_URL.'articles/news/'.$article->id;?>">
                 <img src="<?php echo $article->image_url;?>" class="img-fluid" alt="">
               </a>
             </div>
             <div class="post-body">
               <div class="post-meta">
                 <div class="post-meta-date">
                   <i class="fa fa-calendar" aria-hidden="true"></i> <?php echo date('M d Y', strtotime($article->date));?>
                 </div>
               </div>
               <div class="entry-header">
                 <h2 class="entry-title">
                   <a href="<?php echo BASE_URL.'articles/news/'.$article->id;?>"><?php echo $article->title;?></a>
                 </h2>
               </div>
               <!-- header end -->
               <div class="entry-content">
                 <p><?php echo $description;?></p>
               </div>
               <div class="post-footer">
                 <a href="<?php echo BASE_URL.'articles/news/'.$article->id;?>" class="primary-button1">Read More <i class="fas fa-angle-double-right"></i>
                 </a>
               </div>
             </div>
             <!-- post-body end -->
                </div>
                <!-- post end-->
            </div>
            <?php }?>

         </div>
         <!-- row end-->
         <div class="row d-flex justify-content-center">
            <a href="<?php echo BASE_URL;?>articles" target="_blank" class="primary-button mt-3">View More<i class="fa fa-arrow-right"></i></a> 
         </div>
      </div>
      <!-- container end-->
      <!-- shap image-->
   </section>

   <section  class="cta1">
      <div class="container wow zoomIn">
         <div class="text-center">
            <h3>RAHSTA Awards 2025 </h3>
            <p>Nominate the industry's best at RAHSTA EXPO 2025, recognizing excellence in road and highway innovation, construction, and technology. </p>
            <div class="row">
                <div class="col-lg-6 col-md-6 col-sm-6 col-6">
                  <div class="list1">
                      <ul>
                          <li class="wow fadeInUp">Best Green Highway Award</li>
                          <li class="wow fadeInUp" data-wow-delay="100ms" data-wow-duration="1500ms">TOP Challenger Award for outstanding work in the toughest road challenges</li>
                          <li class="wow fadeInUp" data-wow-delay="100ms" data-wow-duration="1500ms">Innovation Award in Project Execution</li>
                           <li class="wow fadeInUp" data-wow-delay="100ms" data-wow-duration="1500ms">Innovation Award in Materials</li>
                           <li class="wow fadeInUp" data-wow-delay="100ms" data-wow-duration="1500ms">Road Max Award (Contractor executing maximum kilometer of roads)</li>
                          <li class="wow fadeInUp" data-wow-delay="100ms" data-wow-duration="1500ms">Best Road Financier Award (Award to Banks/Lending firms to a maximum kilometer of roads)</li>
                         
                          <li class="wow fadeInUp" data-wow-delay="100ms" data-wow-duration="1500ms">Best Road Developer Award (Developer having the maximum kilometer of roads)</li>
                          <li class="wow fadeInUp" data-wow-delay="100ms" data-wow-duration="1500ms">Award for Excellence in Sustainable Road Construction Equipment</li>
                          
                      </ul>
                  </div>
                </div>
                 <div class="col-lg-6 col-md-6 col-sm-6 col-6">
                   <div class="list1">
                      <ul>
                        <li class="wow fadeInUp">Best Digital Technology Award in road building</li>
                          <li class="wow fadeInUp" data-wow-delay="100ms" data-wow-duration="1500ms">Best Renewable Energy Integration Award</li>
                          <li class="wow fadeInUp" data-wow-delay="100ms" data-wow-duration="1500ms">Award for best use of waste material recycling in road construction</li>
                          <li class="wow fadeInUp" data-wow-delay="100ms" data-wow-duration="1500ms">Awards for Excellence in Bridge Engineering</li>

                           <li class="wow fadeInUp" data-wow-delay="100ms" data-wow-duration="1500ms">Award for Excellence in Tunnel Engineering</li>
                          <li class="wow fadeInUp" data-wow-delay="100ms" data-wow-duration="1500ms">Award for Excellence in Project Management</li>
                         
                          <li class="wow fadeInUp" data-wow-delay="100ms" data-wow-duration="1500ms">Fastest road builder award</li>
                          <li class="wow fadeInUp" data-wow-delay="100ms" data-wow-duration="1500ms">Award for Highest standards of Excellence in Road Engineering & Construction</li>
                          
                      </ul>
                  </div>
                </div>
            </div>
             <a class="primary-button mt-3" href="<?php echo BASE_URL;?>nomination">Nominate Now</a> 
         </div>
      </div>
   </section>

   <?php echo view('blog/home-insta-fedd-view');?>

   <?php echo view('home/contact-us-form');?>
   <!-- brand-area-end -->
</main>
<!-- main-area-end -->