<!DOCTYPE html>
<html lang="en" >
<head>
  <title>India Road Conference</title>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel='stylesheet' href='https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.1.3/css/bootstrap.min.css'>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-icons/1.11.3/font/bootstrap-icons.min.css">
  <link rel="stylesheet" href="https://rahstaexpo.com/assets-home/irc/css/style.css">
  <link rel="stylesheet" href="https://rahstaexpo.com/assets-home/irc/css/aos/aos.css">
  <link rel="stylesheet" href="https://rahstaexpo.com/assets-home/irc/css/glightbox/css/glightbox.css">

</head>
<body>
<!-- partial:index.partial.html -->
<body class="hero-anime">	

	<div class="navigation-wrap bg-light start-header start-style">
		<div class="container">
			<div class="row">
				<div class="col-12">
					<nav class="navbar navbar-expand-md navbar-light">
					
						<a class="navbar-brand" href="#" target="_blank"><img src="https://rahstaexpo.com/assets-home/irc/images/IRC-Logo.png" alt=""></a>	
						
						<button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
							<span class="navbar-toggler-icon"></span>
						</button>
						
						<div class="collapse navbar-collapse" id="navbarSupportedContent">
							<ul class="navbar-nav ml-auto py-4 py-md-0">
								<li class="nav-item pl-4 pl-md-0 ml-0 ml-md-4 active">
									<a class="nav-link" href="#">Home</a>
									<!--<div class="dropdown-menu">
										<a class="dropdown-item" href="#">Action</a>
										<a class="dropdown-item" href="#">Another action</a>
										<a class="dropdown-item" href="#">Something else here</a>
										<a class="dropdown-item" href="#">Another action</a>
									</div>-->
								</li>
								<li class="nav-item pl-4 pl-md-0 ml-0 ml-md-4">
									<a class="nav-link" href="#about">About</a>
								</li>
								<li class="nav-item pl-4 pl-md-0 ml-0 ml-md-4">
									<a class="nav-link" href="#speaker">Speakers</a>
								</li>
								<!--<li class="nav-item pl-4 pl-md-0 ml-0 ml-md-4">
									<a class="nav-link dropdown-toggle" data-toggle="dropdown" href="#" role="button" aria-haspopup="true" aria-expanded="false">Services</a>
									<div class="dropdown-menu">
										<a class="dropdown-item" href="#">Action</a>
										<a class="dropdown-item" href="#">Another action</a>
										<a class="dropdown-item" href="#">Something else here</a>
										<a class="dropdown-item" href="#">Another action</a>
									</div>
								</li>-->
								<li class="nav-item pl-4 pl-md-0 ml-0 ml-md-4">
									<a class="nav-link" href="#partner">Partners</a>
								</li>
                                <li class="nav-item pl-4 pl-md-0 ml-0 ml-md-4">
									<a class="nav-link" href="#agenda">Agenda</a>
								</li>
                                  <li class="nav-item pl-4 pl-md-0 ml-0 ml-md-4">
									<a class="nav-link" href="#gallery">Gallery</a>
								</li>
								<li class="nav-item pl-4 pl-md-0 ml-0 ml-md-4">
									<a class="nav-link" href="#contact">Contact</a>
								</li>
							</ul>
						</div>
						
					</nav>		
				</div>
			</div>
		</div>
	</div>
    <section class="irc-banner-sec">
    	<div class="container-fluid">
        	<div class="row">
            	<img src="https://rahstaexpo.com/assets-home/irc/images/IRC-banner.jpg" class="img-fluid">
              <a class="register-button" id="roadConference" href="#">Register Now</a>
            </div>
        </div>
    </section>
     <section id="about" class="about-sec about section">
    	<div class="container" data-aos="fade-up">
        <div class="section-title">
        <span>About Us<br></span>
        <h2>About this event</h2>
        </div>
        
        <div class="row">

          <div class="col-xl-5 content text-left">
            
            <p>India has seen significant growth in its road network over the last five years, as the government has given priority to this sector. For the financial year 2022-23, the Central budget allocated more than Rs 2.70 trillion to the Ministry of Road Transport and Highways (MoRTH).</p>
            
            <p>India currently has one of the largest road networks in the world, spanning over 5.8 million km. Of this, around 2% are National Highways, 3% are State Highways and the rest are part of the district and rural road network. Over 64.5% of all goods and 90% of passenger traffic move by road.</p>
            
            <p>The government has identified various economic corridors help transform India’s economy. The importance attached to the sector is also evinced by the fact that it accounts for approximately 18% of the National Infrastructure Pipeline. Various state governments are also developing critical road corridors as a catalyst of economic development.</p>
            
            <p>Lately the focus has been on road safety, green initiatives, digital transformation and augmentation of funding sources.</p>
            
          </div>

          <div class="col-xl-7">
            <div class="row gy-4 icon-boxes">

              <div class="col-md-6" data-aos="fade-up" data-aos-delay="200">
                <div class="icon-box">
                  <i class="bi bi-geo-alt-fill"></i>
                  <h3>LOCATION</h3>
                  <p>JIO Convention Centre Mumbai</p>
                </div>
              </div> <!-- End Icon Box -->

              <div class="col-md-6" data-aos="fade-up" data-aos-delay="300">
                <div class="icon-box">
                  <i class="bi bi-volume-up-fill"></i>
                  <h3>PAST SPEAKERS</h3>
                  <p>50 Speakers</p>
                </div>
              </div> <!-- End Icon Box -->

              <div class="col-md-6" data-aos="fade-up" data-aos-delay="400">
                <div class="icon-box">
                  <i class="bi bi-calendar"></i>
                  <h3>DATE & TIME</h3>
                  <p>3rd & 4th September 2025 <br>10.00 AM – 5.30 PM</p>
                </div>
              </div> <!-- End Icon Box -->

              <div class="col-md-6" data-aos="fade-up" data-aos-delay="500">
                <div class="icon-box">
                  <i class="bi bi-cup-hot-fill"></i>
                  <h3>PAST SPONSORS</h3>
                  <p>20 Sponsors</p>
                </div>
              </div> <!-- End Icon Box -->

            </div>
          </div>

        </div>
        
      </div>
    </section>

   
	

	<section class="infra-sec"  data-aos="fade-up">
		<div class="container">
			   <div class="section-title mb-1 pb-1">
        			<span>INFRASTRUCTURE<br></span>
        				<h2>INFRASTRUCTURE INDUSTRY IN INDIA</h2>
        	  </div>

        	  <p>Infrastructure sector is a key driver for the Indian economy. Massive investments have been made in the construction industry by both public and private enterprises in recent years. India plans to spend US$ 1.4 trillion on infrastructure during 2019-23 to have a sustainable development of the country. The Government has suggested investment of Rs. 5,000,000 crore (US$ 750 billion) for railways infrastructure from 2018-30.</p>

        	  <p>India and Japan have joined hands for infrastructure development in India’s Northeast states and are also setting up an India-Japan Coordination Forum for Development of Northeast to undertake strategic infrastructure projects for the region</p>
		</div>
	</section>
	<section id="speaker" class="team section-bg dark-background">
		<div class="container">
			<div class="section-title text-white ">
        <span>Speakers<br></span>
        <h2>Speakers</h2>
        </div>
			<div class="row d-flex justify-content-center">
			<div class="col-lg-3 col-md-3 d-flex align-items-stretch" data-aos="fade-up" data-aos-delay="100">
            <div class="team-member">
              <div class="member-img">
                <img src="https://rahstaexpo.com/assets-home/irc/images/Atul.jpg" class="img-fluid" alt="">
              </div>
              <div class="member-info">
                <h4>ATUL BHOBE</h4>
                <span>MANAGING DIRECTOR</span>
                <p>TPF Engineering</p>
              </div>
            </div>
          </div>

          <div class="col-lg-3 col-md-3" data-aos="fade-up" data-aos-delay="200">
            <div class="team-member">
              <div class="member-img">
                <img src="https://rahstaexpo.com/assets-home/irc/images/Hardik-Agarwal.jpg" class="img-fluid" alt="">
              </div>
              <div class="member-info">
                <h4>HARDIK AGARWAL</h4>
                <span>DIRECTOR</span>
                <p>DARIL</p>
              </div>
            </div>
          </div>

          <div class="col-lg-3 col-md-3" data-aos="fade-up" data-aos-delay="300">
            <div class="team-member">
              <div class="member-img">
                <img src="https://rahstaexpo.com/assets-home/irc/images/Nitin.jpg" class="img-fluid" alt="">
              </div>
              <div class="member-info">
                <h4>NITIN CHATTWAL</h4>
                <span>CEO</span>
                <p>Shrem Invit</p>
              </div>
            </div>
          </div>

          <div class="col-lg-3 col-md-3" data-aos="fade-up" data-aos-delay="400">
            <div class="team-member">
              <div class="member-img">
                <img src="https://rahstaexpo.com/assets-home/irc/images/Sudhir-Hoshing.jpg" class="img-fluid" alt="">
              </div>
              <div class="member-info">
                <h4>SUDHIR HOSHING</h4>
                <span>JT. MANAGING DIRECTOR</span>
                <p>IRB Infra</p>
              </div>
            </div>
          </div>

          <div class="col-lg-3 col-md-3" data-aos="fade-up" data-aos-delay="400">
            <div class="team-member">
              <div class="member-img">
                <img src="https://rahstaexpo.com/assets-home/irc/images/Vijay.jpg" class="img-fluid" alt="">
              </div>
              <div class="member-info">
                <h4>VIJAY AGRAWAL</h4>
                <span>EXECUTIVE DIRECTOR</span>
                <p>Equirus Capital</p>
              </div>
            </div>
          </div>

          <div class="col-lg-3 col-md-3" data-aos="fade-up" data-aos-delay="400">
            <div class="team-member">
              <div class="member-img">
                <img src="https://rahstaexpo.com/assets-home/irc/images/Zaffar.jpg" class="img-fluid" alt="">
              </div>
              <div class="member-info">
                <h4>DR. ZAFFAR KHAN</h4>
                <span>COO</span>
                <p>Highway Concessions</p>
              </div>
            </div>
          </div>

          <div class="col-lg-3 col-md-3" data-aos="fade-up" data-aos-delay="400">
            <div class="team-member">
              <div class="member-img">
                <img src="https://rahstaexpo.com/assets-home/irc/images/Parvesh.jpg" class="img-fluid" alt="">
              </div>
              <div class="member-info">
                <h4>PARVESH MINOCHA</h4>
                <span>CHAIRMAN</span>
                <p>Feedback Infra</p>
              </div>
            </div>
          </div>

          <div class="col-lg-3 col-md-3" data-aos="fade-up" data-aos-delay="400">
            <div class="team-member">
              <div class="member-img">
                <img src="https://rahstaexpo.com/assets-home/irc/images/Somnath.jpg" class="img-fluid" alt="">
              </div>
              <div class="member-info">
                <h4>SOMNATH NANDAN</h4>
                <span>Vice President & Head Engineering</span>
                <p>TATA Projects</p>
              </div>
            </div>
          </div>

          <div class="col-lg-3 col-md-3" data-aos="fade-up" data-aos-delay="400">
            <div class="team-member">
              <div class="member-img">
                <img src="https://rahstaexpo.com/assets-home/irc/images/Vishal.jpg" class="img-fluid" alt="">
              </div>
              <div class="member-info">
                <h4>VISHAL THOMBRE</h4>
                <span>ASST ENGINEER – COSTAL ROADS</span>
                <p>MCGM</p>
              </div>
            </div>
          </div>

          <div class="col-lg-3 col-md-3" data-aos="fade-up" data-aos-delay="400">
            <div class="team-member">
              <div class="member-img">
                <img src="https://rahstaexpo.com/assets-home/irc/images/Manoj.jpg" class="img-fluid" alt="">
              </div>
              <div class="member-info">
                <h4>MANOJ KUMAR</h4>
                <span>MEMBER – PROJECTS</span>
                <p>NHAI</p>
              </div>
            </div>
          </div>

			</div>
		</div>
		
	</section>

	<section class="why-should-sec" data-aos="fade-up">
		<div class="container">
				<div class="row">
					<div class="col-lg-12 col-md-12 col-sm-12 col-12" data-aos="fade-up">
						<div class="section-title mb-1 pb-1">
        					<span>WHY ATTEND<br></span>
        						<h2>WHY ATTEND</h2>
        	  				</div>
        	  				<div class="row">
        	  					<div class="col-lg-6 col-md-6 col-sm-6 col-12">
						<ul>
             			 <li><i class="bi bi-check2-all"></i><span> Reinforce your position as a thought leader in the Infrastructure Industry</span></li>
              			 <li><i class="bi bi-check2-all"></i> <span>Get a chance to interact with Industry Stalwarts and Policy Makers</span></li>
              			<li><i class="bi bi-check2-all"></i> <span>Get effective solutions to Infrastructure related queries shared by the industry experts</span></li>
              			
           				 </ul>
           				</div>

           				<div class="col-lg-6 col-md-6 col-sm-6 col-12">
						<ul>
             			
              			<li><i class="bi bi-check2-all"></i> <span>Get yourself updated through recent trends</span></li>
              			<li><i class="bi bi-check2-all"></i> <span>Take advantage of focused networking sessions to enter the strategic partnerships</span></li>
           				 </ul>
           				</div>
           			</div>
					</div>
				</div>

				<div class="row">
					<div class="col-lg-12 col-md-12 col-sm-12 col-12" data-aos="fade-up">
						<div class="section-title mb-1 pb-1">
        					<span>WHO SHOULD ATTEND<br></span>
        						<h2>WHO SHOULD ATTEND</h2>
        	  				</div>
        	  				<div class="row">
        	  					<div class="col-lg-7 col-md-7 col-sm-7 col-12">
						<ul>
             			 <li><i class="bi bi-check2-all"></i><span> Road operators – Road products (Geosynthetics, Steel, Bitumen, etc.)</span></li>
              			 <li><i class="bi bi-check2-all"></i> <span>Construction firms and contractors</span></li>
              			<li><i class="bi bi-check2-all"></i> <span>Infrastructure development organizations</span></li>
              			<li><i class="bi bi-check2-all"></i> <span>Construction equipment providers</span></li>
              			<li><i class="bi bi-check2-all"></i> <span>OMT organizations and service providers</span></li>
              			<li><i class="bi bi-check2-all"></i> <span>Government agencies</span></li>
              			
           				 </ul>
           				</div>
           				<div class="col-lg-5 col-md-5 col-sm-5 col-12">
						<ul>
             			 
              			<li><i class="bi bi-check2-all"></i> <span>International financial agencies</span></li>
              			<li><i class="bi bi-check2-all"></i> <span>Technology solution providers (GIS, RAMS, etc.)</span></li>
              			<li><i class="bi bi-check2-all"></i> <span>Financial institutions and banks</span></li>
              			<li><i class="bi bi-check2-all"></i> <span>Consultants – Coir geotextile manufacturers</span></li>
              			<li><i class="bi bi-check2-all"></i> <span>Road development agencies – Legal firms, etc.</span></li>
           				 </ul>
           				</div>
           			</div>
					</div>
				</div>
		</div>
		
	</section>

	<section id="partner" class="partner-sec" data-aos="fade-up">
		
<div class="container">
	<div class="section-title text-white mb-1 pb-1">
        <span>Partners<br></span>
        <h2>Past Partners</h2>
        </div>
	<div class="sponsors-area1 sponsors-area-bg1">

                         <div class="row d-flex justify-content-center">
                   <!--  <div class="col-lg-12 col-md-12 col-12">
                   
                  </div> -->
                      <div class="col-lg-3 col-md-3 col-sm-3 col-12">
                         <h3 class="sponsored-heading text-center mb-2">Presenting</h3>
                          <div class="single">
                                <a class="" href="https://www.bkt-tires.com/in/en/">
                                    <img src="https://rahstaexpo.com/assets-home/irc/images/BKT.jpg" alt="sponsor" class="">
                                </a>
                          </div>
                      </div>

                       <div class="col-lg-3 col-md-3 col-sm-3 col-12">
                         <h3 class="sponsored-heading text-center mb-2">Silver</h3>
                          <div class="single">
                                <a class="" href="https://www.nemetschek.com/en">
                                <img src="https://rahstaexpo.com/assets-home/irc/images/Nem-India.jpg" alt="sponsor" class="">
                                </a>
                          </div>
                      </div>

                      <div class="col-lg-3 col-md-3 col-sm-3 col-12" >
                        <h3 class="sponsored-heading text-center mb-2">Equipment</h3>
                          <div class="single">
                                <a class="" href="https://www.tatahitachi.co.in/">
                                    <img src="https://rahstaexpo.com/assets-home/irc/images/Tata-hitachi.jpg" alt="sponsor" class="">
                                </a>
                          </div>
                      </div>

                      <div class="col-lg-3 col-md-3 col-sm-3 col-12">
                        <h3 class="sponsored-heading text-center mb-2">Associate</h3>
                          <div class="single">
                                <a class="" href="https://www.ace-cranes.com">
                                    <img src="assets-home/img/clients/ACE-new.jpg" alt="sponsor">
                                </a>
                               
                          </div>
                      </div>
                   </div>

                   

              </div>  
                 

                
                    </div>
                </section>
	<section id="agenda" class="agenda-sec" data-aos="fade-up">
		<div class="container">
			<div class="section-title mb-1 pb-1">
        					<span>EVENT SCHEDULE<br></span>
        						<h2>EVENT SCHEDULE</h2>
        	  				</div>
			<div class="table-responsive">
				<table class="table table-bordered">
  <tbody><tr>
    <th style="width: 10%;">Duration</th>
    <td style="width: 10%;">TIME</td>
    <td>SESSION DETAILS</td>
  </tr>
  <tr>
    <th>&nbsp;</th>
    <td>9.00 am</td>
    <td>REGISTRATION</td>
  </tr>
  <tr>
    <th colspan="3" style="text-align: center;">INDIA ROADS CONFERENCE</th>
  </tr>
  <tr>
    <th>10 mins</th>
    <td>9.30 am</td>
    <td>Welcome</td>
  </tr>
  <tr>
    <th>10 mins</th>
    <td>9.40 am</td>
    <td><b>Inaugural Address </b><br>Pratap Padode, Founder &amp; President, FIRST Construction Council</td>
  </tr>
  <tr>
    <th>15 mins</th>
    <td>9.50 am</td>
    <td><b>Guest of Honour</b><br>Lt. General Harpal Singh, Former Engineer – In – Chief, Indian Army</td>
  </tr>
  <tr>
    <th>15 mins</th>
    <td>10.05 am</td>
    <td><b>Technology Keynote</b> Innovation and Technology in Roads Sector <br>Dr. Manoranjan Parida, Director, CSIR-CRRI</td>
  </tr>
  <tr>
    <th>15 mins</th>
    <td>10.20 am</td>
    <td><b>Finance Keynote</b> REITs and InvITs: A new era for India  <br>Suresh Goyal, MD &amp; CEO, National Highways Infra Investment Managers (NHAI InvIT)</td>
  </tr>
  <tr>
    <th>10 mins</th>
    <td>10.35 am</td>
    <td><b>BREAK</b></td>
  </tr>
  <tr>
    <th>60 mins</th>
    <td>10.45 am</td>
    <td><b>PANEL DISCUSSION: Policy: Shaping Regulations for Safe and Sustainable Roads</b><br>
		Experts and policymakers will share insights, experiences, and best practices in developing effective policies that prioritize road safety and sustainability. The discussion will cover
		<ul>
			<li>Policy Frameworks: Assessing the strengths, and gaps in the existing regulations</li>
			<li>Road Safety: Enhancing road safety through policy interventions</li>
			<li>Eco-friendly materials, energy efficiency, and minimizing environmental impact</li>
			<li>Role of technology, enforcement agencies in promoting quality &amp; safety standards</li>
		</ul>
		&nbsp;
		<p><b>SPEAKERS : </b></p>
		<p><b>MODERATOR :</b>Mr. Dibyendu Sengupta, Director, PwC</p>
		<ul>
			<li>Mr. Ajay Kumar Mishra, President, Dilip Buildcon</li>
			<li>Mr. Akhilesh Srivastava, Road Safety Ambassador-International Roads Federation (IC)</li>
			<li>Mr. Indrabhushan Gokhale, Country Manager, TEREX India</li>
			<li>Mr. RK Pandey, Former Member Projects, NHAI &amp; Former ADG, MoRTH </li>
			<li>Mr. SK Nirmal, Secretary General, India Roads Congress</li>
			<li>Dr. Satish Pandey, Principal Scientist at Central Road Research Institute (CRRI)</li>
		</ul>
	</td>
  </tr>
  <tr>
    <th colspan="3" style="text-align: center;">TECHNOLOGY: Revolutionizing Road Construction with Innovation</th>
  </tr>
  <tr>
    <th>20 mins</th>
    <td>11.45 am</td>
    <td><b>KEYNOTE: Tunnelling Technology</b>	<br>Col. Parikshit Mehra, Border Roads Organisation</td>
  </tr>
  <tr>
    <th>55 mins</th>
    <td>12.05 pm</td>
    <td><b>PANEL DISCUSSION: Revolutionizing Road Project Management: Empowering Success through Technology</b>
	<br>This panel discussion will delve into the realm of utilizing technology to enhance road project management. The discussion aims to showcase successful case studies, highlight emerging technologies, and provide insights on implementing technology-driven solutions for effective road project management.
		<ul>
			<li>Pre-Construction Assessment: Tech intervention in effective planning of roads</li>
			<li>Real Time Monitoring &amp; Tracking: Exploring how data-driven insights, predictive modelling, and machine learning can improve decision-making, risk management, and resource allocation.</li>
			<li>Building Material Management: Overcoming Implementation Challenges by addressing common challenges and roadblocks in adopting technology in project management.</li>
			<li>Terrain Efficient Equipment: Autonomous construction equipment, robotic surveying, and machine-guided construction techniques to improve productivity, safety, and quality control</li>
		</ul>
		&nbsp;
		<p><b>SPEAKERS </b></p>
		<p><b>MODERATOR </b> Mr. Ameya Kulkarni, Director, KPMG</p>
		<ul>
			<li>Mr. Dhawal Ashar, Sr. Manager – Integrated Transport, WRI India</li>
			<li>Mr. Kasturi Srinivas, Industry Sales Director, Transportation, Bentley Systems</li>
			<li>Mr. Manideep Saha, Consultant - Digital Transformation, Project Management</li>
			<li>Mr. Nilanjan Sarkar, CTO, Tiki Tar and Shell India</li>
			<li>Dr. Smruti Ranjan Parida, DGM – System &amp; IT Automation, ADANI Road Transport</li>
			<li>Mr. Sunil Desai, Director – Dextra India</li>
			<li>Mr. Thumu Karthik, CEO, LivSYT (DevIndia Technologies)</li>
		</ul>
	</td>
  </tr>
  <tr>
    <th>45 mins</th>
    <td>1.00 pm</td>
    <td><b>LUNCH</b></td>
  </tr>
  <tr>
    <th>5 mins</th>
    <td>1.45 pm</td>
    <td><b>Sponsor Presentation</b></td>
  </tr>
  <tr>
    <th colspan="3" style="text-align: center;"><b>FINANCE: Monetisation &amp; Funding the Future of Road Construction</b></th>
  </tr>
  <tr>
    <th>20 mins</th>
    <td>1.50 pm</td>
    <td><b>KEYNOTE ADDRESS:  Monetization opportunities in Road space with  InvITs &amp; REITs </b><br>
		Mr. Pawan Kant, CEO, LTIDPL IndVIT Services Ltd (IM to IndInfraVIT Trust)</td>
  </tr>
  <tr>
    <th>60 mins</th>
    <td>2.15 pm</td>
    <td><b>PANEL DISCUSSION: Accelerating Road Infra with better Monetisation &amp; Financing opportunities</b><br>
		This panel aims to shed light on the various financial mechanisms that can fuel the growth of road infrastructure and foster collaboration between public and private sectors. It will focus on exploring innovative financing models, the role of public-private partnerships (PPPs) in sustainable road development, and strategies to attract capital for road construction. 
		<ul>
			<li>Model for monetizing public infrastructure assets with <b>InViTs</b></li>
			<li><b>Exploring alternative funding options</b> for road infrastructure projects</li>
			<li><b>Green bonds, crowd-funding, asset recycling</b>, and other innovative approaches to attract capital from diverse sources</li>
			<li><b>Successful PPP projects,</b> addressing challenges, and showcasing best practices for effective collaboration between public and private entities.</li>
			<li><b>ESG Considerations in Road Financing</b></li>
		</ul>
		&nbsp;
		<p><b>SPEAKERS</b></p>
		<p><b>MODERATOR: </b>Mr. Suneet Maheshwari, Udvik Infra </p>
		<ul>
			<li>Mr. Abhishek Mukherjee, Senior Infrastructure Specialist &amp; Freelance Consultant, ADB</li>
			<li>Mr. Harsh Singhal, Founding Partner, Edhina Capital</li>
			<li>Mr. Neeraj Sanghi, CEO, Highway Concessions </li>
			<li>Mr. Palash Srivastava, CEO, IIFCL Projects</li>
			<li>Mr. Pawan Kant, CEO, LTIDPL IndVIT Services Ltd (IM to IndInfraVIT Trust)</li>
			<li>Mr. Satyan Kumar, Head – Project Finance &amp; Treasury, Sekura India Management</li>
		</ul>
	</td>
  </tr>
  <tr>
    <th colspan="3" style="text-align: center;">LEADER’s FORUM</th>
  </tr>
  <tr>
    <th>55 mins</th>
    <td>3.15 pm</td>
    <td><b>PANEL DISCUSSION: EPC, HAM, BOT - The Right Ratio for Business?</b><br>
		Gain a comprehensive understanding of the thought processes behind selecting the right financing model for road projects, the practical implications for project execution, and the strategies employed by industry leaders to strike the optimal balance. By the end of the panel discussion, participants will be better equipped to navigate the intricate decisions involved in road infrastructure development, ensuring a sustainable, efficient, and successful future for the industry.
		<ul>
			<li><b>Decoding the models:</b> Evaluating the risks and returns to align with the business goals.</li>
			<li><b>Financial Viability vs Operational Sustainability: </b>Exploring Financial viability and long-term operational sustainability, maintenance, and road quality.</li>
			<li><b>Investor Confidence and Learning from Experiences</b></li>
		</ul>
		&nbsp;
		<p><b>SPEAKERS  </b></p>
		<p><b>Moderator: </b>Emell D. Adolphus, Sr. Editor, ENR</p>
		<ul>
			<li>Mr. Ashok Kumar, Dy. Director, BL Kashyap &amp; Sons </li>
			<li>Mr. DK Sen, Whole-time Director and Sr. Executive VP (Development Projects), L&amp;T</li>
			<li>Mr. Hardik Agarwal, Director, DRAIPL</li>
			<li>Mr. Mandeep Singh, COO - Engineering and Contracting Division, Casagrand</li>
			<li>Mr. Premjit Singh, CEO – Transportation, Welspun Enterprises</li>
			<li>Mr. TR Rao, Director (Infra), PNC Infratech </li>
		</ul>
</td>
  </tr>
  <tr>
    <th>5 mins</th>
    <td>4.00 pm</td>
    <td><b>VOTE OF THANKS</b></td>
  </tr>
  <tr>
    <th>&nbsp;</th>
    <td>4.05 pm</td>
    <td><b>BREAK</b></td>
  </tr>
  <tr>
    <th colspan="3" style="text-align: center;">EQUIPMENT INDIA AWARDS</th>
  </tr>
  <tr>
    <th>10 mins</th>
    <td>4.30 pm</td>
    <td>Welcome Address</td>
  </tr>
  <tr>
    <th>5 mins</th>
    <td>4.40 pm</td>
    <td>Awards Methodology</td>
  </tr>
  <tr>
    <th>5 mins</th>
    <td>4.45 pm</td>
    <td>Jury Introduction and Unveiling - Infrastructure Today Anniversary Issue</td>
  </tr>
  <tr>
    <th>20 mins</th>
    <td>4.50 pm</td>
    <td>KEYNOTE ADDRESS</td>
  </tr>
  <tr>
    <th>30 mins</th>
    <td>5.10 pm</td>
    <td><b>AWARDS PRESENTATAION </b><br>
		<ul>
			<li>Best Sellers Category</li>
			<li>Innovation of the Year</li>
			<li>Trainer of the Year</li>
			<li>Emerging Construction Equipment Company</li>
		</ul>
</td>
  </tr>
  <tr>
    <th>5 mins</th>
    <td>5.40 pm</td>
    <td><b>EQUIPMENT INDIA – PERSON OF THE YEAR AWARD</b></td>
  </tr>
  <tr>
    <th>5 mins</th>
    <td>5.45 pm</td>
    <td>Vote of Thanks </td>
  </tr>
  <tr>
    <th>&nbsp;</th>
    <td>5.50 pm</td>
    <td>Hi Tea Networking </td>
  </tr>
  <tr>
    <th>40 mins</th>
    <td>5.50 pm</td>
    <td><b>VIP NETWORKING <br><i>(Invite Only Event)</i></b></td>
  </tr>
  <tr>
    <th colspan="3" style="text-align: center;">CONSTRUCTION WORLD GLOBAL AWARDS</th>
  </tr>
  <tr>
    <th>10 mins</th>
    <td>6.30 pm</td>
    <td>INAUGURAL</td>
  </tr>
  <tr>
    <th>5 mins</th>
    <td>6.40 pm</td>
    <td>Lamp Lighting</td>
  </tr>
  <tr>
    <th>10 mins</th>
    <td>6.45 pm</td>
    <td><b>Welcome Note</b><br>Mr. Pratap Padode, Founder &amp; President, FIRST Construction Council</td>
  </tr>
  <tr>
    <th>5 mins</th>
    <td>6.55 pm</td>
    <td><b>Address</b><br>Mr. Tanveer Padode, Head – Digital, ASAPP Info Global</td>
  </tr>
  <tr>
    <th>5 mins</th>
    <td>7.00 pm</td>
    <td><b>FIRST CONSTRUCTION COUNCIL – Board of Governors Felicitation</b></td>
  </tr>
  <tr>
    <th>10 mins</th>
    <td>7.05 pm</td>
    <td><b>JURY Introduction &amp; Unveiling of CONSTRUCTION WORLD Annual Issue</b></td>
  </tr>
  <tr>
    <th>15 mins</th>
    <td>7.15 pm</td>
    <td><b>Guest of Honour Address</b> <br>Lieutenant General Arvind Walia, Engineer-in-Chief, Indian Army</td>
  </tr>
  <tr>
    <th>40 mins</th>
    <td>7.30 pm</td>
    <td><b>Award Presentation</b><br>
		<ul>
			<li>Top Challengers 2022-23</li>
			<li>India’s Most Admired Brands</li>
			<li>Fastest Growing Construction Companies </li>
			<li>Largest Construction Company </li>
			<li>Project and Emerging Company of the Year</li>
		</ul>
	</td>
  </tr>
  <tr>
    <th>15 mins</th>
    <td>8.10 pm</td>
    <td><b>CONSTRUCTION WORLD - PERSON OF THE YEAR (Public &amp; Private)</b></td>
  </tr>
  <tr>
    <th>5 mins</th>
    <td>8.25 pm</td>
    <td>Vote of Thanks</td>
  </tr>
  <tr>
    <th>&nbsp;</th>
    <td>8.30 pm</td>
    <td>Cocktail &amp; Dinner</td>
  </tr>
</tbody></table>
			</div>
		</div>
		
	</section>

  <section id="gallery" class="gallery">

      <!-- Section Title -->
      <div class="container section-title" data-aos="fade-up">
        <h2>Gallery</h2>
        <div><span>Gallery</span></div>
      </div><!-- End Section Title -->

      <div class="container" data-aos="fade-up" data-aos-delay="100">

        <div class="row no-gutter">

          <div class="col-lg-3 col-md-3 pl-1 pr-1">
            <div class="gallery-item">
              <a href="https://rahstaexpo.com/assets-home/irc/images/gallery/1.jpg" class="glightbox" data-gallery="images-gallery">
                <img src="https://rahstaexpo.com/assets-home/irc/images/gallery/1.jpg" alt="" class="img-fluid">
              </a>
            </div>
          </div><!-- End Gallery Item -->

          <div class="col-lg-3 col-md-3 pl-1 pr-1">
            <div class="gallery-item">
              <a href="https://rahstaexpo.com/assets-home/irc/images/gallery/2.jpg" class="glightbox" data-gallery="images-gallery">
                <img src="https://rahstaexpo.com/assets-home/irc/images/gallery/2.jpg" alt="" class="img-fluid">
              </a>
            </div>
          </div><!-- End Gallery Item -->

          <div class="col-lg-3 col-md-3 pl-1 pr-1">
            <div class="gallery-item">
              <a href="https://rahstaexpo.com/assets-home/irc/images/gallery/3.jpg" class="glightbox" data-gallery="images-gallery">
                <img src="https://rahstaexpo.com/assets-home/irc/images/gallery/3.jpg" alt="" class="img-fluid">
              </a>
            </div>
          </div><!-- End Gallery Item -->

          <div class="col-lg-3 col-md-3 pl-1 pr-1">
            <div class="gallery-item">
              <a href="https://rahstaexpo.com/assets-home/irc/images/gallery/4.jpg" class="glightbox" data-gallery="images-gallery">
                <img src="https://rahstaexpo.com/assets-home/irc/images/gallery/4.jpg" alt="" class="img-fluid">
              </a>
            </div>
          </div><!-- End Gallery Item -->

          <div class="col-lg-3 col-md-3 pl-1 pr-1">
            <div class="gallery-item">
              <a href="https://rahstaexpo.com/assets-home/irc/images/gallery/5.jpg" class="glightbox" data-gallery="images-gallery">
                <img src="https://rahstaexpo.com/assets-home/irc/images/gallery/5.jpg" alt="" class="img-fluid">
              </a>
            </div>
          </div><!-- End Gallery Item -->

          <div class="col-lg-3 col-md-3 pl-1 pr-1">
            <div class="gallery-item">
              <a href="https://rahstaexpo.com/assets-home/irc/images/gallery/6.jpg" class="glightbox" data-gallery="images-gallery">
                <img src="https://rahstaexpo.com/assets-home/irc/images/gallery/6.jpg" alt="" class="img-fluid">
              </a>
            </div>
          </div><!-- End Gallery Item -->

          <div class="col-lg-3 col-md-3 pl-1 pr-1">
            <div class="gallery-item">
              <a href="https://rahstaexpo.com/assets-home/irc/images/gallery/7.jpg" class="glightbox" data-gallery="images-gallery">
                <img src="https://rahstaexpo.com/assets-home/irc/images/gallery/7.jpg" alt="" class="img-fluid">
              </a>
            </div>
          </div><!-- End Gallery Item -->

          <div class="col-lg-3 col-md-3 pl-1 pr-1">
            <div class="gallery-item">
              <a href="https://rahstaexpo.com/assets-home/irc/images/gallery/8.jpg" class="glightbox" data-gallery="images-gallery">
                <img src="https://rahstaexpo.com/assets-home/irc/images/gallery/8.jpg" alt="" class="img-fluid">
              </a>
            </div>
          </div><!-- End Gallery Item -->

          <div class="col-lg-3 col-md-3 pl-1 pr-1">
            <div class="gallery-item">
              <a href="https://rahstaexpo.com/assets-home/irc/images/gallery/9.jpg" class="glightbox" data-gallery="images-gallery">
                <img src="https://rahstaexpo.com/assets-home/irc/images/gallery/9.jpg" alt="" class="img-fluid">
              </a>
            </div>
          </div><!-- End Gallery Item -->

          <div class="col-lg-3 col-md-3 pl-1 pr-1">
            <div class="gallery-item">
              <a href="https://rahstaexpo.com/assets-home/irc/images/gallery/10.jpg" class="glightbox" data-gallery="images-gallery">
                <img src="https://rahstaexpo.com/assets-home/irc/images/gallery/10.jpg" alt="" class="img-fluid">
              </a>
            </div>
          </div><!-- End Gallery Item -->

          <div class="col-lg-3 col-md-3 pl-1 pr-1">
            <div class="gallery-item">
              <a href="https://rahstaexpo.com/assets-home/irc/images/gallery/11.jpg" class="glightbox" data-gallery="images-gallery">
                <img src="https://rahstaexpo.com/assets-home/irc/images/gallery/11.jpg" alt="" class="img-fluid">
              </a>
            </div>
          </div><!-- End Gallery Item -->

          <div class="col-lg-3 col-md-3 pl-1 pr-1">
            <div class="gallery-item">
              <a href="https://rahstaexpo.com/assets-home/irc/images/gallery/12.jpg" class="glightbox" data-gallery="images-gallery">
                <img src="https://rahstaexpo.com/assets-home/irc/images/gallery/12.jpg" alt="" class="img-fluid">
              </a>
            </div>
          </div><!-- End Gallery Item -->

        </div>

      </div>

    </section><!-- /Gallery Section -->

    <section id="contact" class="contact section">

      <!-- Section Title -->
      <div class="container section-title aos-init aos-animate" data-aos="fade-up">
        <div class="section-title mb-1 pb-1">
                  <span>Contact us<br></span>
                    <h2>Contact us</h2>
                    </div>
      </div><!-- End Section Title -->

      <div class="container aos-init aos-animate" data-aos="fade-up" data-aos-delay="100">

        <div class="row gy-4">
          <div class="col-lg-6 ">
            <div class="row gy-4">

              <div class="col-lg-12">
                <div class="info-item d-flex flex-column justify-content-center align-items-center aos-init aos-animate" data-aos="fade-up" data-aos-delay="200">
                  <i class="bi bi-telephone"></i>
                  <h3>For Delegate Registrations</h3>
                  <p>Name: Amar</p>
                  <p>Phone: +91-8652493000</p>
                  <p>Email: delegate1@asappmedia.com</p>
                </div>
              </div><!-- End Info Item -->

            

            </div>
          </div>

           <div class="col-lg-6 ">
            <div class="row gy-4">

              <div class="col-lg-12">
                <div class="info-item d-flex flex-column justify-content-center align-items-center aos-init aos-animate" data-aos="fade-up" data-aos-delay="200">
                  <i class="bi bi-mic-fill"></i>
                  <h3>For Partnerships and Speaking Opportunity</h3>
                  <p>Name: Kajal</p>
                  <p>Phone:+91-7096775263</p>
                  <p>Email: conference2@asappinfoglobal.com</p>
                </div>
              </div><!-- End Info Item -->

            

            </div>
          </div>

         

        </div>

      </div>

    </section>

  <footer>
    &copy; 2025 INDIA ROADS CONFERENCE ALL RIGHTS RESERVED
  </footer>
  
<!-- Link to page
================================================== -->

	<!--<a href="https://front.codes/" class="logo" target="_blank">
		<img src="https://assets.codepen.io/1462889/fcy.png" alt="">
	</a>
-->
</body>

<div class="modal" id="visitor-reg" data-backdrop="static">
  <input type="hidden" name="homePageStatus" id="homePageStatus" value="">
  <div class="modal-dialog">
    <div class="modal-content">
      <!-- Modal Header -->
      <div class="modal-header">
        <h4 class="modal-title" id="formName">Visitor Registration</h4>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <!-- Modal body -->
      <div class="modal-body">
        <form method="post" id="registrationForm">
          <div class="form-area">
            <div class="form-inner">
              <div class="form-group">
                <input type="text" class="form-control" name="name" placeholder="Full Name">
              </div>
              <div class="form-group">
                <input type="text" class="form-control" name="email_id" placeholder="Email">
              </div>
              <div class="form-group">
                <input type="text" class="form-control mobile_code" placeholder="Mobile No" name="mobile_no" id="mobile_no">
                <input type="hidden" id="country_code" name="country_code" value="91">
              </div>
              <div class="form-group">
                <input type="text" class="form-control" name="company_name" placeholder="Company Name">
              </div>
              <div class="form-group">
                <input type="text" class="form-control" name="designation" placeholder="Designation">
              </div>
              <div class="form-group">
                <input type="text" class="form-control" name="city" placeholder="City">
              </div>

              <div class="form-group">
                <input type="number" min="1" max="10" class="form-control" name="qty" id="qty" placeholder="Quantity" style="display:none;">
              </div>

              <div class="form-group" style="display:none;" id="stallSel">
                <select class="form-control" name="stall_size" id="stall_size" required >
                  <option value="">What size of stall are you looking for?</option>
                  <option value="9 sq.m">9 sq.m</option>
                  <option value="18-54 sq.m">18-54 sq.m</option>
                  <option value="54-100 sq.m">54-100 sq.m</option>
                </select>
              </div>

              <div class="form-group">
                <select class="form-control" name="industry" id="industry">
                  <option value="">Industry</option>
                  <option value="Technological Innovations">Technological Innovations</option>
                  <option value="Infrastructure Providers">Infrastructure Providers</option>
                  <option value="Smart Mobility Solutions">Smart Mobility Solutions</option>
                  <option value="Safety and Security">Safety and Security</option>
                  <option value="Policy and Finance">Policy and Finance</option>
                  <option value="Government and Regulatory Bodies">Government and Regulatory Bodies</option>
                  <option value="Project Owners">Project Owners</option>
                  <option value="Consultants and Designers">Consultants and Designers</option>
                  <option value="Construction Contractors">Construction Contractors</option>
                  <option value="Suppliers and Manufacturers">Suppliers and Manufacturers</option>
                  <option value="Quality and Safety Inspectors">Quality and Safety Inspectors</option>
                  <option value="Financial Institutions">Financial Institutions</option>
                  <option value="Legal and Compliance Experts">Legal and Compliance Experts</option>
                  <option value="Stakeholders and Community Groups">Stakeholders and Community Groups</option>
                  <option value="Maintenance and Operations Teams">Maintenance and Operations Teams</option>
                  <option value="Others">Others</option>

                </select>
              </div>

              <div class="form-group">
                <input type="text" class="form-control" name="other" id="other" placeholder="Enter your input" style="display:none;">
              </div>

              <div class="form-group">
                <input type="checkbox" class="" name="privacy_policy"> I have read and understood the <a target="_blank" href="https://rahstaexpo.com/privacy" style="text-decoration: underline;color: blue;">privacy and cookies policy</a> and agree to receiving all communications from the RAHSTA EXPO team via WhatsApp, Email, SMS, and phone calls.
              </div>

              <div class="form-group">
                <input type="hidden" class="form-control" name="number_of_day" value="0">
                <input type="hidden" class="form-control" name="interested_in" value="">
                <input type="hidden" class="form-control" name="web_url" value='<?php echo "https://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";?>'>
              </div>

              <div class="form-group">
                <button type="submit" id="visitorFormBtn" class="primary-button mt-3">Submit</button>
              </div>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>

<!-- partial -->
  <script src='https://cdnjs.cloudflare.com/ajax/libs/jquery/3.3.1/jquery.min.js'></script>
<script src='https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/js/bootstrap.min.js'></script>
<script src="https://rahstaexpo.com/assets-home/irc/css/aos/aos.js" type="text/javascript"></script>
<script src="https://rahstaexpo.com/assets-home/irc/css/glightbox/js/glightbox.js" type="text/javascript"></script>
<script  src="https://rahstaexpo.com/assets-home/irc/js/script.js"></script>
<script src="<?php echo BASE_URL; ?>assets-home/js/vendor/jquery.validate.min.js"></script>
<script src="<?php echo BASE_URL; ?>assets-home/js/vendor/main.js"></script>

<script>
  $("#roadConference").click(function(){
    $("#homePageStatus").val(1);
    $('input[name="interested_in"]').val('Delegate');
    $("#formName").html("Delegate Registration");
    $("#qty").css('display','block');
    $("#stallSel").css('display','none');
    $("#visitor-reg").modal('show');
  })
</script>
</body>
</html>
