<!DOCTYPE html>
<html lang="en">

<head>
   <!-- Basic Page Needs ================================================== -->
   <meta charset="utf-8">

   <!-- Mobile Specific Metas ================================================== -->
   <meta http-equiv="X-UA-Compatible" content="IE=edge">
   <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">

   <!-- Site Title -->
  <title>Mumbai Redevelopment Summit</title>

   <!-- CSS
         ================================================== -->
   <!-- Bootstrap -->
   <link rel="stylesheet" href="css/bootstrap.min.css">

   <!-- FontAwesome -->
   <link rel="stylesheet" href="css/font-awesome.min.css">
   <!-- Animation -->
   <link rel="stylesheet" href="css/animate.css">
   <!-- magnific -->
   <link rel="stylesheet" href="css/magnific-popup.css">
   <!-- carousel -->
   <link rel="stylesheet" href="css/owl.carousel.min.css">
   <!-- isotop -->
   <link rel="stylesheet" href="css/isotop.css">
   <!-- ico fonts -->
   <link rel="stylesheet" href="css/xsIcon.css">
   <!-- Template styles-->
   <link rel="stylesheet" href="css/style.css">
   <!-- Responsive styles-->
   <link rel="stylesheet" href="css/responsive.css">

   <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
   <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
   <!--[if lt IE 9]>
      <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
      <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
      <![endif]-->

</head>

<body>
   <div class="body-inner">
      <!-- Header start -->
      <header id="header" class="header header-transparent">
         <div class="container">
            <nav class="navbar navbar-expand-lg navbar-light">
               <!-- logo-->
               <a class="navbar-brand" href="index.html">
                  <img src="images/logos/logo.jpg" alt="">
               </a>
               <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNavDropdown"
                  aria-controls="navbarNavDropdown" aria-expanded="false" aria-label="Toggle navigation">
                  <span class="navbar-toggler-icon"><i class="icon icon-menu"></i></span>
               </button>
               <div class="collapse navbar-collapse" id="navbarNavDropdown">
                  <ul class="navbar-nav ml-auto">
                     <li class="nav-item active">
                        <a href="index.html" >Home </a>
                      </li>
                      <li class="nav-item">
                        <a href="about.html">About us</a>
                     </li>
                     <li class="nav-item">
                        <a href="speakers.html">Speakers</a>
                     </li>
                      <li class="nav-item">
                        <a href="agenda.html">Agenda</a>
                     </li>
                      <li class="nav-item">
                        <a href="partners.html">Partners</a>
                     </li>
                      <li class="nav-item">
                        <a href="#">Contact us</a>
                     </li>
                    
                  </ul>
               </div>
            </nav>
         </div><!-- container end-->
      </header>
      <!--/ Header end -->

      <div id="page-banner-area" class="page-banner-area" style="background-image:url(./images/hero_area/banner_bg.jpg)">
         <!-- Subpage title start -->
         <div class="page-banner-title">
            <div class="text-center">
               <h2>About us</h2>
               <ol class="breadcrumb">
                  <li>
                     <a href="#">Home /</a>
                  </li>
                  <li>
                     Agenda
                  </li>
               </ol>
            </div>
         </div><!-- Subpage title end -->
      </div><!-- Page Banner end -->

      <section id="intro" class="intro section">

       <!-- Section Title -->
     

      <div class="container">
         <h2 class="section-title text-center">
                     <!-- <span>Listen to the</span> -->
                     About us
                  </h2>

        <div class="row g-4">

          <div class="col-lg-6 wow fadeInRight" data-wow-duration="1.5s" data-wow-delay="400ms">
            <div class="content">
                <h2>Reimagining Mumbai’s Skyline — Unlocking Opportunities in Urban Regeneration</h2>  
              <p>Mumbai’s redevelopment journey is reshaping the city’s built environment, driving urban renewal and unlocking massive real estate potential. With new policies, regulatory clarity, and private–public collaboration, redevelopment is no longer a niche segment — it’s the future of Mumbai’s growth story.</p>

              <p>The <strong>2nd Mumbai Redevelopment Summit 2025,</strong> organised by <strong>ASAPP Info Global Group,</strong> brings together <strong>developers, investors, policymakers, architects, and legal experts</strong> to discuss the next wave of transformation under DCPR 2034 and the government’s urban regeneration agenda.</p>

              <p>Join the leaders building the new Mumbai — where policy, finance, and innovation converge to redefine city living.</p>
             
            </div>
          </div>

          <div class="col-lg-6 wow fadeInLeft" data-wow-duration="1.5s" data-wow-delay="400ms">
            <div class="visual-section">
              <div class="image-wrapper">
                <img src="images/about/about.jpg" alt="Tech Summit" class="img-fluid">
                <div class="gradient-overlay"></div>
               <!--  <div class="floating-badge">
                  <i class="bi bi-calendar-event"></i>
                  <span>November 7, 2025</span>
                </div>  -->
              </div>
            </div>
          </div>

        </div>

      

      </div>

    </section>
      <!-- ts intro end-->
      <!-- ts funfact start-->
      <section class="ts-funfact" style="background-image: url(./images/funfact_bg.jpg)">
         <div class="container">
            <div class="row">
               <div class="col-lg-3 col-md-3">
                  <div class="ts-single-funfact">
                     <h3 class="funfact-num"><span class="counterUp" data-counter="910">910</span>+</h3>
                     <h4 class="funfact-title">Redevelopment projects initiated since 2020
                        </h4>
                  </div>
               </div><!-- col end-->
              <!--  <div class="col-lg-2 col-md-2">
                  <div class="ts-single-funfact">
                     <h3 class="funfact-num"><span class="counterUp" data-counter="1">1.3</span></h3>
                     <h4 class="funfact-title">Trillion value unlocked across Mumbai Metropolitan Region</h4>
                  </div>
               </div> --><!-- col end-->
               <div class="col-lg-3 col-md-3">
                  <div class="ts-single-funfact">
                     <h3 class="funfact-num"><span class="counterUp" data-counter="44000">44,000</span>+</h3>
                     <h4 class="funfact-title">New housing units planned under cessed & cluster schemes</h4>
                  </div>
               </div><!-- col end-->
               <div class="col-lg-3 col-md-3">
                  <div class="ts-single-funfact">
                     <h3 class="funfact-num"><span class="counterUp" data-counter="30">30</span>%</h3>
                     <h4 class="funfact-title">Growth in redevelopment-linked FDI inflows (2023–25)</h4>
                  </div>
               </div><!-- col end-->
               <div class="col-lg-3 col-md-3">
                  <div class="ts-single-funfact">
                     <h3 class="funfact-num"><span class="counterUp" data-counter="5000">5,000</span>+</h3>
                     <h4 class="funfact-title">Buildings identified for reconstruction under DCR 33 (5/7/9/11)</h4>
                  </div>
               </div><!-- col end-->
            </div><!-- row end-->
            <p class="text-white text-center">Mumbai’s redevelopment boom is a once-in-a-generation opportunity for developers, financiers, and urban planners</p>
         </div><!-- container end-->
      </section>

      <!-- ts footer area start-->
       <div class="footer-area">
         <!-- footer start-->
         <footer class="ts-footer">
            <div class="container">
               <div class="row">
                  <div class="col-lg-4">
                     <h2 class="text-white">Contact us</h2>
                     <h4 class="text-white">Conference Enquiries:</h4>
                     <p>Kajal – Conference1@ASAPPinfoGlobal.com</p>

                     <h4 class="text-white">Sponsorship Opportunities:</h4>
                     <p>Ratan – Ratan.R@ASAPPinfoGlobal.com</p>

                     <h4 class="text-white">Delegate Registration:</h4>
                     <p>Siraj – Siraj.K@ASAPPinfoGlobal.com</p>
                  </div>
                  <div class="col-lg-4">
                      <h2 class="text-white">Quick Links</h2>
                      <div class="footer-menu text-center mb-25">
                        <ul>
                           <li><a href="#">About us</a></li>
                           <li><a href="#">Speakers</a></li>
                           <li><a href="#">Agenda</a></li>
                           <li><a href="#">Contact us</a></li>
                          <!--  <li><a href="#">Venue</a></li> -->
                        </ul>
                     </div>
                  </div>
                  <div class="col-lg-4">
                     <h2 class="text-white">Follows On</h2>
                     <div class="ts-footer-social mb-30">
                        <ul>
                           <li>
                              <a href="#"><i class="fa fa-facebook"></i></a>
                           </li>
                           <!-- <li>
                              <a href="#"><i class="fa fa-twitter"></i></a>
                           </li>
                           <li>
                              <a href="#"><i class="fa fa-google-plus"></i></a>
                           </li> -->
                           <li>
                              <a href="#"><i class="fa fa-linkedin"></i></a>
                           </li>
                           <li>
                              <a href="#"><i class="fa fa-instagram"></i></a>
                           </li>
                        </ul>
                     </div>
                  </div>
               </div>
               <div class="row">
                  <div class="col-lg-8 mx-auto">
                    
                     <!-- footer social end-->
                   
                     <div class="copyright-text text-center">
                        <p>Copyright © 2025 All Rights Reserved.</p>
                     </div>
                  </div>
               </div>
            </div>
         </footer>
         <!-- footer end-->
         <div class="BackTo">
            <a href="#" class="fa fa-angle-up" aria-hidden="true"></a>
         </div>

      </div>
      <!-- ts footer area end-->



      <!-- Javascript Files
            ================================================== -->
      <!-- initialize jQuery Library -->
      <script src="js/jquery.js"></script>

      <script src="js/popper.min.js"></script>
      <!-- Bootstrap jQuery -->
      <script src="js/bootstrap.min.js"></script>
      <!-- Counter -->
      <script src="js/jquery.appear.min.js"></script>
      <!-- Countdown -->
      <script src="js/jquery.jCounter.js"></script>
      <!-- magnific-popup -->
      <script src="js/jquery.magnific-popup.min.js"></script>
      <!-- carousel -->
      <script src="js/owl.carousel.min.js"></script>
      <!-- Waypoints -->
      <script src="js/wow.min.js"></script>
      <!-- isotop -->
      <script src="js/isotope.pkgd.min.js"></script>

      <!-- Template custom -->
      <script src="js/main.js"></script>
   </div>
   <!-- Body inner end -->
</body>

</html>