$(function () {

    // Add custom validation method for international phone number
    $.validator.addMethod("phoneInternational", function(value, element) {
        /*var countryCode = $(".mobile_code").intlTelInput("getSelectedCountryData").dialCode;
        var isValid = $("#mobile_no").intlTelInput("isValidNumber");
        console.log(countryCode + isValid);*/
        // return isValid && value.startsWith("+" + countryCode);
      $('#mobile_no').formValidation('revalidateField', 'phoneNumber');
    }, "Please enter a valid phone number for the selected country.");

    $.validator.addMethod('customphone', function (value, element) {
        return this.optional(element) || /^[6-9]\d{9}$/.test(value);
    }, "Please enter a valid mobile number");

    $.validator.addMethod("validPhoneNumber", function(value, element) {
        return this.optional(element) || $('#mobile_no').intlTelInput('isValidNumber');
    }, "Please enter a valid phone number.");

    $.validator.addMethod("noGamilDomain", function(value, element) {
        // Check if the email ends with @gamil.com
        return this.optional(element) || !/^[a-zA-Z0-9._%+-]+@gamil\.com$/i.test(value);
    }, "Please enter only official email addresses.");

    /*$.validator.addMethod("noGamilDomain", function(value, element) {
        // Check if the email contains @gamil.com (case insensitive)
        return this.optional(element) || value.toLowerCase().indexOf("@gamil.com") === -1;
    }, "Email addresses from gamil.com are not allowed.");*/
    
    $("#registrationForm").validate({
            rules: {
              name: {
                minlength: 2,
                maxlength: 50,
                required: true
              },
              email_id: {
                required: true,
                email: true
              },
              mobile_no: {
                // customphone: true,
                required: true,
                validPhoneNumber: true,
                // phoneInternational: true
              },
              company_name: {
                required: true,
              },
              designation: {
                required: true,
              },
              city: {
                required: true,
              },
              qty: {
                required: true,
              },
              industry: {
                required: true,
              },
              privacy_policy:{
                required: true,
              }
            },
            messages: {
              name: {
                required: " Please enter your name"
              },
              email_id: {
                required: "Please enter a valid email address",
                email: "Please enter a valid email address"
              },
              mobile_no: {
                required: "Please enter a valid mobile number",
              },
              company_name: {
                required: "Please enter company name",
              },
              designation: {
                required: "Please enter designation",
              },
              city: {
                required: "Please enter city"
              },
              qty: {
                required: "Please enter quantity"
              },
              industry: {
                required: "Please select industry"
              },
              privacy_policy:{
                required: "Please accept privacy and policy",
              }
            },
            submitHandler: function (form) {

                $("#visitorFormBtn").attr('disabled',true);

                var hostName = window.location.origin;
                if(hostName == 'http://localhost'){
                    baseUrl = 'http://localhost/mumbai-redevelopment-summit';
                }else{
                    baseUrl = 'https://events.asappinfoglobal.com/mumbai-redevelopment-summit';
                }

                $.ajax({
                  type: "POST",
                  url: baseUrl + '/form-submit',
                  data: $('#registrationForm').serialize(),
                  dataType:'JSON',
                  success: function (response) {

                    $("#registrationForm")[0].reset();
                    $("#visitor-reg").modal('hide');
                    $("#visitorFormBtn").attr('disabled',false);
                  
                    if (response.Status == true) {

                      $("#hiddenVal").val(response.insertedId);

                      window.localStorage.setItem('EventType', response.EventType);

                      inviteVal = $("#inviteVal").val();

                      if(response.EventType == 'Delegate'){

                        homePageStatus = $("#homePageStatus").val();
                        
                        if(homePageStatus == 1){
                          window.location.href = baseUrl+"/register?eventType=Delegate";
                        }

                        window.location.href = baseUrl+"/register?eventType=Delegate";
                        
                        $("#delegateFormDiv").css('display', 'none');
                        $("#visitorDiv").css('display', 'none');
                        $("#exhibitorDiv").css('display', 'none');
                        $("#sponsorDiv").css('display', 'none');
                        $("#otherDiv").css('display', 'none');
                        $("#delegateDiv").css('display', 'block');

                      }else if(inviteVal == 1){

                        $("#visitor-reg").modal('hide');
                        alert(response.Message);

                        $("#registerDelegate").removeClass('disabled-link');
                        $("#companyCouponCode").css('display', 'block');

                        $("#delegateFormDiv").css('display', 'none');
                        $("#visitorDiv").css('display', 'none');
                        $("#exhibitorDiv").css('display', 'none');
                        $("#sponsorDiv").css('display', 'none');
                        $("#otherDiv").css('display', 'none');
                        $("#delegateDiv").css('display', 'block');

                      }else{
                          // window.location.href = baseUrl+"/thankYou";
                        if(response.EventType == 'Exhibitor'){
                          window.location.href = baseUrl+"/exhibitor-thankYou";
                        }

                        if(response.EventType == 'Visitor'){
                          window.location.href = baseUrl+"/visitor-thankYou";
                        }

                        if(response.EventType == 'Sponsor'){
                          window.location.href = baseUrl+"/sponsor-thankYou";
                        }

                      }
                        
                    } else {
                        alert(response.Message);
                    }
                  }
                });
            }
    });

    $("#studioForm").validate({
      rules: {
        sfname: {
          minlength: 2,
          maxlength: 50,
          required: true
        },
        slname: {
          minlength: 2,
          maxlength: 50,
          required: true
        },
        semail: {
          required: true,
          email: true,
          noGamilDomain: true
        },
        smobile: {
          required: true,
          customphone: true,
        },
        scompany: {
          required: true,
        },
        sdesignation: {
          required: true,
        },
        srequirement:{
          minlength: 2,
          maxlength: 100,
          required:true,
        }
      },
      messages: {
        sfname: {
          required: " Please enter your first name"
        },
        slname: {
          required: " Please enter your last name",
        },
        semail: {
          required: "Please enter a valid email address",
          email: "Please enter a valid email address",
          noGamilDomain : 'Please enter only official email addresses'
        },
        smobile: {
          required: "Please enter a valid mobile number",
        },
        scompany: {
          required: "Please enter company name",
        },
        sdesignation: {
          required: "Please enter designation",
        },
        srequirement:{
          // minlength: "Please enter Minimum length 2 character",
          maxlength: "Max length exceeded!",
          required: "Please enter requirement",
        }
      },
      submitHandler: function (form) {

        $("#SudioSubmitBtn").attr('disabled',true);

        var hostName = window.location.origin;
        if(hostName == 'http://localhost'){
            baseUrl = 'http://localhost/mumbai-redevelopment-summit';
        }else{
            baseUrl = 'https://events.asappinfoglobal.com/mumbai-redevelopment-summit';
        }

        $.ajax({
          type: "POST",
          url: baseUrl + '/studio-form-submit',
          data: $('#studioForm').serialize(),
          dataType:'JSON',
          success: function (response) {

            $("#SudioSubmitBtn").attr('disabled',false);
          
            if (response.Status == true) {
              $("#studioForm")[0].reset();
              $("#studios").modal('hide');
                window.location.href = baseUrl+"/thankYou";
            } else {
                alert(response.Message);
            }
          }
        });
      }
    });

    $("#brochureForm").validate({
            rules: {
              bname: {
                minlength: 2,
                maxlength: 50,
                required: true
              },
              bemail_id: {
                required: true,
                email: true
              },
              bmobile_no: {
                customphone: true,
                required: true
              },
              bcompany_name: {
                required: true,
              },
              bdesignation: {
                required: true,
              }
            },
            messages: {
              bname: {
                required: " Please enter your name"
              },
              bemail_id: {
                required: "Please enter a valid email address",
                email: "Please enter a valid email address"
              },
              bmobile_no: {
                required: "Please enter a valid mobile number",
              },
              bcompany_name: {
                required: "Please enter company name",
              },
              bdesignation: {
                required: "Please enter designation",
              }
            },
            submitHandler: function (form) {

                $("#bSubmitBtn").attr('disabled',true);

                var hostName = window.location.origin;
                if(hostName == 'http://localhost'){
                    baseUrl = 'http://localhost/mumbai-redevelopment-summit';
                }else{
                    baseUrl = 'https://events.asappinfoglobal.com/mumbai-redevelopment-summit';
                }

                $.ajax({
                  type: "POST",
                  url: baseUrl + '/download-form-submit',
                  data: $('#brochureForm').serialize(),
                  dataType:'JSON',
                  success: function (response) {

                    $("#bSubmitBtn").attr('disabled',false);
                    if (response.Status == true) {
                        
                        $("#brochureForm")[0].reset();
                        $("#brochure").modal('hide');

                        var type = $("#type").val();

                        // window.location.href = baseUrl+"/thankYou";
                        var fileContent = response.fileUrl;

                        var pdftype = $("#type").val(); 
                        // console.log("Category value:", pdftype);
                        /*if (fileContent) {
                          $("#download_pdf").trigger("click");
                          window.location.href = baseUrl+"/thankYou";
                        } else {
                          // Handle other responses as needed
                          console.error("Unexpected response from the server");
                        }*/

                        if (fileContent) {
                         
                          if(pdftype == "Brochure"){
                            $("#download_pdf").trigger("click");
                            window.location.href = baseUrl+"/thankYou";
                          } else if(pdftype == "PSR"){
                           $("#download_PSRpdf").trigger("click");
                            window.location.href = baseUrl+"/thankYou";
                          }
                        
                        } else {
                          if(type == 'floor-plan'){
                            // alert('floor-plan submited');
                            $('.floor-image').css('filter', 'none');
                            $('.floor-text').hide();
                          }else{
                            // Handle other responses as needed
                            console.error("Unexpected response from the server");
                          }
                        }
                    } else {
                        alert(response.Message);
                    }
                  }
                });
            }
    });

    $("#bisForm").validate({
            rules: {
              bname: {
                minlength: 2,
                maxlength: 50,
                required: true
              },
              bemail_id: {
                required: true,
                email: true
              },
              bmobile_no: {
                customphone: true,
                required: true
              },
              bcompany_name: {
                required: true,
              },
              bdesignation: {
                required: true,
              },
              bindustry: {
                required: true,
              },
              topic_of_interest: {
                required: true,
              }
            },
            messages: {
              bname: {
                required: " Please enter your name"
              },
              bemail_id: {
                required: "Please enter a valid email address",
                email: "Please enter a valid email address"
              },
              bmobile_no: {
                required: "Please enter a valid mobile number",
              },
              bcompany_name: {
                required: "Please enter company name",
              },
              bdesignation: {
                required: "Please enter designation",
              },
              bindustry: {
                required: "Please select industry",
              },
               topic_of_interest: {
                required: "Please select Topic of interest",
              }
            },
            submitHandler: function (form) {

                $("#bisSubmitBtn").attr('disabled',true);

                var hostName = window.location.origin;
                if(hostName == 'http://localhost'){
                    baseUrl = 'http://localhost/mumbai-redevelopment-summit';
                }else{
                    baseUrl = 'https://events.asappinfoglobal.com/mumbai-redevelopment-summit';
                }

                $.ajax({
                  type: "POST",
                  url: baseUrl + '/download-form-submit',
                  data: $('#bisForm').serialize(),
                  dataType:'JSON',
                  success: function (response) {

                    $("#bisSubmitBtn").attr('disabled',false);
                    if (response.Status == true) {
                        
                        $("#bisForm")[0].reset();
                        $("#bis").modal('hide');

                        var type = $("#type").val();

                        // window.location.href = baseUrl+"/thankYou";
                        var fileContent = response.fileUrl;

                        var pdftype = $("#type").val(); 
                        
                        if (fileContent) {
                         
                          if(pdftype == "BIS-Report"){
                            $("#download_Bispdf").trigger("click");
                            window.location.href = baseUrl+"/thankYou";
                          } 
                        } else {
                          console.error("Unexpected response from the server");
                        }
                    } else {
                        alert(response.Message);
                    }
                  }
                });
            }
    });

    $("#floorPlanForm").validate({
            rules: {
              bname: {
                minlength: 2,
                maxlength: 50,
                required: true
              },
              bemail_id: {
                required: true,
                email: true
              },
              bmobile_no: {
                customphone: true,
                required: true
              },
              bcompany_name: {
                required: true,
              },
              bdesignation: {
                required: true,
              }
            },
            messages: {
              bname: {
                required: " Please enter your name"
              },
              bemail_id: {
                required: "Please enter a valid email address",
                email: "Please enter a valid email address"
              },
              bmobile_no: {
                required: "Please enter a valid mobile number",
              },
              bcompany_name: {
                required: "Please enter company name",
              },
              bdesignation: {
                required: "Please enter designation",
              }
            },
            submitHandler: function (form) {

                $("#FSubmitBtn").attr('disabled',true);

                var hostName = window.location.origin;
                if(hostName == 'http://localhost'){
                    baseUrl = 'http://localhost/mumbai-redevelopment-summit';
                }else{
                    baseUrl = 'https://events.asappinfoglobal.com/mumbai-redevelopment-summit';
                }
                
                $.ajax({
                  type: "POST",
                  url: baseUrl + '/floorPlan-form-submit',
                  data: $('#floorPlanForm').serialize(),
                  dataType:'JSON',
                  success: function (response) {
                    $("#FSubmitBtn").attr('disabled',false);
                    if (response.Status == true) {
                        
                        $("#floorPlanForm")[0].reset();
                        $("#floorPlan").modal('hide');

                        // window.location.href = baseUrl+"/thankYou";
                        // var fileContent = response.fileUrl;

                        var formtype = $("#type2").val(); 
                        // console.log("Category value:", pdftype);
                        /*if (fileContent) {
                          $("#download_pdf").trigger("click");
                          window.location.href = baseUrl+"/thankYou";
                        } else {
                          // Handle other responses as needed
                          console.error("Unexpected response from the server");
                        }*/

                          if(formtype == "Floorplan"){
                        
                              $("#floor-img").removeClass("floor-image"); 
                      
                        } else {
                          // Handle other responses as needed
                          console.error("Unexpected response from the server");
                        }
                    } else {
                        alert(response.Message);
                    }
                  }
                });
            }
    });

    $("#contactForm").validate({
            rules: {
              cname: {
                minlength: 2,
                maxlength: 50,
                required: true
              },
              cemail_id: {
                required: true,
                email: true
              },
              cmobile_no: {
                customphone: true,
                required: true
              },
              ccompany_name: {
                required: true,
              },
              cdesignation: {
                required: true,
              },
              ccity: {
                required: true,
              },
             /* interested_in[]: {
                required: true,
              },*/
              privacy_policy:{
                required: true,
              },
              cIndustry:{
                required: true,
              }
            },
            messages: {
              cname: {
                required: " Please enter your name"
              },
              cemail_id: {
                required: "Please enter a valid email address",
                email: "Please enter a valid email address"
              },
              cmobile_no: {
                required: "Please enter a valid mobile number",
              },
              ccompany_name: {
                required: "Please enter company name",
              },
              cdesignation: {
                required: "Please enter designation",
              },
              ccity: {
                required: "Please enter city"
              },
              /*interested_in[]: {
                required: "Please select interested in"
              },*/
              privacy_policy:{
                required: "Please accept privacy and policy",
              },
              cIndustry:{
                required: "Please select industry",
              }
            },
            submitHandler: function (form) {

                $("#conSubBtn").attr('disabled',true);

                var hostName = window.location.origin;
                if(hostName == 'http://localhost'){
                    baseUrl = 'http://localhost/mumbai-redevelopment-summit';
                }else{
                    baseUrl = 'https://events.asappinfoglobal.com/mumbai-redevelopment-summit';
                }

                $.ajax({
                  type: "POST",
                  url: baseUrl + '/contact-form-submit',
                  data: $('#contactForm').serialize(),
                  dataType:'JSON',
                  success: function (response) {
                    $("#contactForm")[0].reset();
                    $("#conSubBtn").attr('disabled',false);
                  
                    if (response.Status == true) {
                      /*window.localStorage.setItem('EventType', response.EventType);
                      if(response.EventType == 'Delegate'){
                        window.location.href = baseUrl+"/register?eventType=Delegate";

                        $("#delegateFormDiv").css('display', 'none');
                        $("#visitorDiv").css('display', 'none');
                        $("#exhibitorDiv").css('display', 'none');
                        $("#sponsorDiv").css('display', 'none');
                        $("#otherDiv").css('display', 'none');
                        $("#delegateDiv").css('display', 'block');

                      }else{
                        window.location.href = baseUrl+"/thankYou";
                      }*/
                      // window.location.href = baseUrl+"/thankYou";
                      if(response.EventType == 'Exhibitor'){
                        window.location.href = baseUrl+"/exhibitor-thankYou";
                      }

                      else if(response.EventType == 'Visitor'){
                        window.location.href = baseUrl+"/visitor-thankYou";
                      }

                      else if(response.EventType == 'Sponsor'){
                        window.location.href = baseUrl+"/sponsor-thankYou";
                      }else{
                        window.location.href = baseUrl+"/thankYou";
                      }
                    } else {
                        alert(response.Message);
                    }
                  }
                });
            }
    });

    $("#whyExhibitor").validate({
            rules: {
              wname: {
                minlength: 2,
                maxlength: 50,
                required: true
              },
              wemail_id: {
                required: true,
                email: true
              },
              wmobile_no: {
                customphone: true,
                required: true
              },
              wcompany_name: {
                required: true,
              },
              wcity: {
                required: true,
              },
              wdesignation: {
                required: true,
              },
              stallSize: {
                required: true,
              },
              industry: {
                required: true,
              },
             
             
              privacy_policy:{
                required: true,
              }
            },
            messages: {
              wname: {
                required: " Please enter your name"
              },
              wemail_id: {
                required: "Please enter a valid email address",
                email: "Please enter a valid email address"
              },
              wmobile_no: {
                required: "Please enter a valid mobile number",
              },
              wcompany_name: {
                required: "Please enter company name",
              },
              wcity: {
                required: "Please enter city",
              },
              wdesignation: {
                required: "Please enter designation",
              },
              stallSize: {
                required: "Please enter stall size"
              },
              industry: {
                required: "Please select industry"
              },
            
              privacy_policy:{
                required: "Please accept privacy and policy",
              }
            },
            
            submitHandler: function (form) {

                $("#whyExhibitorBtn").attr('disabled',true);

                var hostName = window.location.origin;
                if(hostName == 'http://localhost'){
                    baseUrl = 'http://localhost/mumbai-redevelopment-summit';
                }else{
                    baseUrl = 'https://events.asappinfoglobal.com/mumbai-redevelopment-summit';
                }

                $.ajax({
                  type: "POST",
                  url: baseUrl + '/stall-form-submit',
                  data: $('#whyExhibitor').serialize(),
                  dataType:'JSON',
                  success: function (response) {
                    $("#whyExhibitor")[0].reset();
                    $("#whyExhibitorBtn").attr('disabled',false);
                    
                    window.localStorage.setItem('EventType', 'Exhibitor');

                    if (response.Status == true) {
                      // window.location.href = baseUrl+"/thankYou";
                      window.location.href = baseUrl+"/exhibitor-thankYou";
                    } else {
                        alert(response.Message);
                    }
                  }
                });

            }
    });
  // });

    
    $("#newsletterSignUp").validate({
            rules: {
              sName: {
                minlength: 2,
                maxlength: 50,
                required: true
              },
              sEmail: {
                required: true,
                email: true
              },
              sMobileNo: {
                customphone: true,
                required: true,
              },
              sprivacyPolicy:{
                required: true,
              }
            },
            messages: {
              sName: {
                required: " Please enter your name"
              },
              sEmail: {
                required: "Please enter a valid email address",
                email: "Please enter a valid email address"
              },
              sMobileNo: {
                required: "Please enter a valid mobile number",
              },
              sprivacyPolicy:{
                required: "Please accept privacy and policy",
              }
            },
            submitHandler: function (form) {

                // $("#visitorFormBtn").attr('disabled',true);

                var hostName = window.location.origin;
                if(hostName == 'http://localhost'){
                    baseUrl = 'http://localhost/mumbai-redevelopment-summit';
                }else{
                    baseUrl = 'https://events.asappinfoglobal.com/mumbai-redevelopment-summit';
                }

                $.ajax({
                  type: "POST",
                  url: baseUrl + '/newsletter-signup',
                  data: $('#newsletterSignUp').serialize(),
                  dataType:'JSON',
                  success: function (response) {

                    $("#newsletterSignUp")[0].reset();
                  
                    if (response.Status == true) {
                      alert(response.Message);
                    } else {
                        alert(response.Message);
                    }
                  }
                });
            }
    });

    $("#newsletterForm").validate({
            rules: {
              newsletterEmail: {
                required: true,
                email: true
              }
            },
            messages: {
              newsletterEmail: {
                required: "Please enter a valid email address",
                email: "Please enter a valid email address"
              }
            },
            submitHandler: function (form) {

                var hostName = window.location.origin;
                if(hostName == 'http://localhost'){
                    baseUrl = 'http://localhost/mumbai-redevelopment-summit';
                }else{
                    baseUrl = 'https://events.asappinfoglobal.com/mumbai-redevelopment-summit';
                }

                $.ajax({
                  type: "POST",
                  url: baseUrl + '/after-newsletter-signup',
                  data: $('#newsletterForm').serialize(),
                  dataType:'JSON',
                  success: function (response) {

                    $("#newsletterForm")[0].reset();
                  
                    if (response.Status == true) {
                      alert(response.Message);
                      $("#closeBtn").click();
                    } else {
                        alert(response.Message);
                    }
                  }
                });
            }
    });

    $("#inflcencerForm").validate({
            rules: {
              iName: {
                minlength: 2,
                maxlength: 50,
                required: true
              },
              instaId:{
                required: true,
              },
              iemailId: {
                required: true,
                email: true
              },
              iMobileNo: {
                customphone: true,
                required: true,
              },
              iCity:{
                required: true,
              }
              /*sprivacyPolicy:{
                required: true,
              }*/
            },
            messages: {
              iName: {
                required: " Please enter your name"
              },
              instaId:{
                required: "Please enter insta id",
              },
              iemailId: {
                required: "Please enter a valid email address",
                email: "Please enter a valid email address"
              },
              iMobileNo: {
                required: "Please enter a valid mobile number",
              },
              iCity:{
                required: "Please enter city",
              }
              /*sprivacyPolicy:{
                required: "Please accept privacy and policy",
              }*/
            },
            submitHandler: function (form) {

                // $("#visitorFormBtn").attr('disabled',true);

                var hostName = window.location.origin;
                if(hostName == 'http://localhost'){
                    baseUrl = 'http://localhost/mumbai-redevelopment-summit';
                }else{
                    baseUrl = 'https://events.asappinfoglobal.com/mumbai-redevelopment-summit';
                }

                $.ajax({
                  type: "POST",
                  url: baseUrl + '/influencer-submit',
                  data: $('#inflcencerForm').serialize(),
                  dataType:'JSON',
                  success: function (response) {

                    $("#inflcencerForm")[0].reset();
                  
                    if (response.Status == true) {
                      alert(response.Message);
                    } else {
                        alert(response.Message);
                    }
                  }
                });
            }
    });

    $("#registerDelegate").click(function(){
      var hostName = window.location.origin;
      if(hostName == 'http://localhost'){
          baseUrl = 'http://localhost/mumbai-redevelopment-summit';
      }else{
          baseUrl = 'https://events.asappinfoglobal.com/mumbai-redevelopment-summit';
      }

      $.ajax({
        type: "POST",
        url: baseUrl + '/check-delegate',
        // data: $('#inflcencerForm').serialize(),
        dataType:'JSON',
        success: function (response) {
          if (response.Status == true) {
            // alert(response.Message);
            
            $("#hiddenVal").val(response.insertedId);
            window.localStorage.setItem('EventType', response.EventType);
            window.location.href = baseUrl+"/register?eventType=Delegate";
            
            $("#delegateFormDiv").css('display', 'none');
            $("#visitorDiv").css('display', 'none');
            $("#exhibitorDiv").css('display', 'none');
            $("#sponsorDiv").css('display', 'none');
            $("#otherDiv").css('display', 'none');
            $("#delegateDiv").css('display', 'block');

          } else {
              alert(response.Message);
          }
        }
      });
    })
});