<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

// Load the system's routing file first, so that the app and ENVIRONMENT
// can override as needed.
if (is_file(SYSTEMPATH . 'Config/Routes.php')) {
    require SYSTEMPATH . 'Config/Routes.php';
}

/*
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Home');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
// The Auto Routing (Legacy) is very dangerous. It is easy to create vulnerable apps
// where controller filters or CSRF protection are bypassed.
// If you don't want to define all routes, please use the Auto Routing (Improved).
// Set `$autoRoutesImproved` to true in `app/Config/Feature.php` and set the following to true.
// $routes->setAutoRoute(false);

/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.
$routes->get('/', 'Home::index');
$routes->get('/demo', 'Home::demo');
$routes->get('/privacy', 'Home::privacy');
$routes->get('/refund-policy', 'Home::refundPolicy');
$routes->get('/terms-conditions', 'Home::termsConditions');
$routes->get('/awards-categories', 'Home::awardsCategories');
$routes->get('/delegate', 'Home::delegate');
$routes->get('/why-exhibit', 'Home::whyExhibit');
$routes->post('/set-delegate', 'Home::setDelegateType');
$routes->get('/about', 'Home::aboutUs');
$routes->get('/speakers', 'Home::speakers');
$routes->get('/agenda', 'Home::agenda');
$routes->get('/partners', 'Home::partners');
$routes->get('/exhibitor-partner', 'Home::exhibitorPartner');
$routes->get('/contact', 'Home::contact');
$routes->get('/gallery', 'Home::gallery');
$routes->get('/visitor-profile', 'Home::visitorProfile');
$routes->get('/sectors', 'Home::sectors');
$routes->get('/faq', 'Home::faq');
$routes->get('/exhibitor-profile', 'Home::ExhibitorProfile');
$routes->get('/book-your-space', 'Home::bookYourSpace');
$routes->get('/newsletter', 'Home::newsletter');
$routes->get('/road-conference', 'Home::roadConference');
$routes->get('/rahsta-conference', 'Home::rahstaConference');
$routes->get('/conference', 'Home::conference');

$routes->get('/floor-plan', 'Home::floorPlan');
$routes->get('/live-updates', 'Home::liveUpdates');
$routes->get('/live-updates-inside', 'Home::liveUpdatesInner');

$routes->get('/invite/(:any)', 'Register::invite/$1');
$routes->get('/updateCouponCode', 'Register::updateCouponCode');

$routes->post('/check-delegate', 'Common::checkDelegate');

$routes->get('/check', 'Common::check');

$routes->get('/checkZohoLeads', 'Common::checkZohoLeads');

$routes->get('/createCode', 'Common::createCode');

$routes->get('/getAccessRefreshToken', 'Common::getAccessRefreshToken');

$routes->get('/blog', 'Blog::blog');
// $routes->get('/blog-insite', 'Blog::blogInner');
$routes->get('/blog/insight/(:num)', 'Blog::blogInner/$1');

$routes->get('/blog-insert', 'Blog::insertBlog');


// form submit
$routes->post('/form-submit', 'Common::formSubmit');
$routes->post('/studio-form-submit', 'Common::studioFormSubmit');
$routes->post('/form-submit-update', 'Common::formSubmitUpdate');
$routes->post('/download-form-submit', 'Common::brochureFormSubmit');
$routes->post('/floorPlan-form-submit', 'Common::floorFormSubmit');
$routes->post('/contact-form-submit', 'Common::contactFormSubmit');
$routes->post('/stall-form-submit', 'Common::stallFormSubmit');
$routes->get('/thankYou', 'Home::thankYou');
$routes->get('/thank-you-', 'Home::thankYouPage');

$routes->get('/visitor-thankYou', 'Thankyou::VistitorthankYouPage');
$routes->get('/exhibitor-thankYou', 'Thankyou::exhibitorthankYouPage');
$routes->get('/sponsor-thankYou', 'Thankyou::sponsorthankYouPage');
$routes->get('/delegate-thankYou', 'Thankyou::delegatethankYouPage');

$routes->post('/check-coupon', 'Common::checkCoupon');

$routes->post('/newsletter-signup', 'Common::newsletterSignup');
$routes->post('/after-newsletter-signup', 'Common::newsletterSignupAfterEvent');

$routes->get('/articles', 'Articles::newsHome');
$routes->get('/latest-articles', 'Articles::getLatestArticles');
$routes->cli('/cron-job', 'Articles::getLatestArticles');
$routes->get('/articles/news/(:num)', 'Articles::newsArtilces/$1');

/*$routes->get('/zoho', 'Common::zohoLeads');
$routes->get('/getRefresh', 'Common::generateAuthTokenFromRefresh');*/

// 
$routes->get('/register', 'Register::index');

$routes->get('/register-new', 'Users::registerNew');

$routes->post('/user-register', 'Users::registerUser');
$routes->post('/user-login', 'Users::loginUser');

$routes->post('/social-login', 'Users::SocialLogin');
$routes->post('/set-user-sessions', 'Users::setUserSession');

$routes->get('/user-profile', 'Users::getProfile');
$routes->post('/user-profile-update', 'Users::updateProfile');

$routes->get('/logout', 'Users::logout');

$routes->get('/ticket', 'Passes::getPasses');
$routes->post('/set-tickets', 'Passes::setTickets');
$routes->post('/submit-attend', 'Passes::submitAttenData');
$routes->post('/get-tickets', 'Passes::getTickets');

// nomination 
$routes->get('/nomination', 'Nomination::index');
$routes->get('/nomination-registration', 'Nomination::nominationRegister');
$routes->post('/nomination-register', 'Nomination::registerUser');
$routes->get('/nomination-thankyou', 'Nomination::registerThankyou');
$routes->post('/nomination-login', 'Nomination::loginUser');
$routes->get('/nomination-formview', 'Nomination::nominationView');
$routes->get('/nomination-logout', 'Nomination::logout');
$routes->add('/first-submit', 'Nomination::firststepSubmit');
$routes->add('/secnod-submit', 'Nomination::secondstepSubmit');
$routes->add('/secnod-form-validation', 'Nomination::secondstepFormValidation');
$routes->add('/third-submit', 'Nomination::thirdstepSubmit');
$routes->post('/nomination-category-details', 'Nomination::getNominationDetailsByCategory');
$routes->get('/nomination-profile', 'Nomination::nominationProfile');

$routes->get('/get-nomination', 'Nomination::getNominationFile');

// payment
$routes->post('/payment', 'Payment::paymentView');
$routes->post('/generate-order', 'Payment::generateOrder');
$routes->post('/verify-signature', 'Payment::verfiySignature');
$routes->post('/update-payment-status', 'Payment::updatePaymentStatus');
$routes->get('/thank-you', 'Payment::paymentThankyou');
$routes->get('/payment-email', 'Payment::sendPaymentMail1');
$routes->get('/Payment', 'Home::Paymentpage');

// delegate payment
$routes->get('/delegate-payment', 'DelegatePayment::paymentView');
$routes->get('/add-users', 'DelegatePayment::addUsers');
$routes->post('/add-users-submit', 'DelegatePayment::addUsersSubmit');

$routes->post('/delegate-generate-order', 'DelegatePayment::generateOrder');
$routes->post('/delegate-verify-signature', 'DelegatePayment::verfiySignature');
$routes->post('/delegate-update-payment-status', 'DelegatePayment::updatePaymentStatus');
$routes->get('/delegate-thank-you', 'DelegatePayment::paymentThankyou');

$routes->get('/test-pay', 'DelegatePayment::testPayment');

$routes->get('/zoho-payment', 'DelegatePayment::zohoPaymentStatus');

$routes->get('/rss-news', 'Sitemap::zohoRssNews');
$routes->get('/rss-newsletter', 'Sitemap::zohoRssNewsletter');

$routes->get('/insta-feed', 'Social::getInstagramFeed');
$routes->get('/insta-reels', 'Social::getInstagramReels');
$routes->get('/event-gallery', 'Social::getEventImages');
$routes->get('/events-gallery-dropbox', 'Social::dropBox');
$routes->get('/events-gallery-js', 'Social::dropBoxJavaScript');
$routes->get('/events-gallery-choose', 'Social::dropBoxJavaScriptChoose');
$routes->get('/events-gallery-images', 'Social::getGalleryImages');

$routes->get('admin/login', 'Admin\Admin::login');
$routes->post('admin/do-login', 'Admin\Admin::doLogin');
$routes->get('admin/logout', 'Admin\Admin::logout');
$routes->get('/admin/add-blog', 'Admin\Admin::AddBlog');
$routes->post('/admin/save-blog', 'Admin\Admin::saveBlog');
$routes->get('/admin/blog-list', 'Admin\Admin::blogList');
$routes->get('/admin/blog-get/(:num)', 'Admin\Admin::getBlog/$1');
$routes->post('/admin/blog-update/(:num)', 'Admin\Admin::updateBlog/$1');
$routes->post('/admin/blog-delete/(:num)', 'Admin\Admin::deleteBlog/$1');

$routes->get('exhibitor/login', 'Admin\Admin::login');
$routes->get('exhibitor/dashboard', 'Admin\Admin::dashboard');
$routes->get('exhibitor/company-profile', 'Admin\Admin::companyProfile');

$routes->get('/influencer', 'Influencer::index');
$routes->post('/influencer-submit', 'Influencer::Submit');

$routes->get('/delete-account', 'Social::deleteAccount');

$routes->group("api/(:any)/ImpacctLeads", ["namespace" => "App\Controllers", "filter" => "basicauth"], function($routes){

    $routes->post('saveDetails', 'Impacct::saveDetails');
});

// nomination-thank-you

/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (is_file(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {
    require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
