<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\Admin\UserModel;
use CodeIgniter\Files\File;

class Admin extends BaseController
{
    public function login()
    {
        helper(['form','url']);
        echo view('admin/login');
    }

    public function doLogin()
    {
        $postData = $this->request->getPost();

        if(empty($postData))
        {
            // redirect('/');
        }
        else
        {   
            $userModel = new UserModel();
            $user = $userModel->getUserLogin($postData['email'], $postData['password']);

            if ($user != null)
            {   
                $userDetails = array(
                    'first_name' => $user->first_name,
                    'last_name' => $user->last_name,
                    'email' => $user->email_id,
                    'login' => true,
                );

                $this->session->set('userDetails',$userDetails);

                // return redirect()->to('/exhibitor/dashboard');
                return redirect()->to('/admin/blog-list');
            }
            else
            {
                return redirect()->to('/exhibitor/login');
            }
        }
    }

    public function dashboard()
    {
        echo view('admin/dashboard');
    }

    public function companyProfile()
    {
        echo view('admin/company-profile-view');
    }

    public function blogList()
    {
        $userDetails = session()->get('userDetails');

        if($userDetails == ''){
            return redirect()->to('/admin/login');
        }

        $db = \Config\Database::connect();
        $builder = $db->table('blog');
        // $builder->where('id', $id);
        $builder->where('status', 0);
        $data['blog'] = $builder->get()->getResult();

        echo view('blog/blog-list-view', $data);

    }

    public function AddBlog()
    {
        $userDetails = session()->get('userDetails');

        if($userDetails == ''){
            return redirect()->to('/admin/login');
        }

        echo view('admin/blog/add-blog');
    }

    public function getBlog($id)
    {
        $db = \Config\Database::connect();
        $builder = $db->table('blog');
        $builder->where('id', $id);
        $builder->where('status', 0);
        $data['blog'] = $builder->get()->getRow();

        // echo view('home/header');
        echo view('blog/blog-update-view', $data);
        // echo view('home/footer'); 
    }

    public function updateBlog($id)
    {   
        $userDetails = session()->get('userDetails');

        if($userDetails == ''){
            return redirect()->to('/admin/login');
        }

        $postData = $this->request->getPost();

        $img = $this->request->getFile('doc_upload');

        if($img != ''){

            $validationRule = [
                'userfile' => [
                    'label' => 'Image File',
                    'rules' => 'uploaded[doc_upload]'. '|mime_in[doc_upload,image/jpg,image/jpeg,image/gif,image/png,image/webp,application/pdf]'. '|max_size[doc_upload,2048]'
                ],
            ];
            if (! $this->validate($validationRule)) {

                $imgData = ['errors' => $this->validator->getErrors()];
                // return redirect()->back()->withInput()->with('error', $imgData['errors']);
            }
            
            $filepath = 'assets-home/blog';

            if ($img->move($filepath)) {
                $data = [
                    'img_name' => $img->getClientName(),
                    'file'  => $img->getClientMimeType()
                ];

                $postData['image_url'] = $data['img_name'];
            }
        }

        $db = \Config\Database::connect();
        $builder = $db->table('blog');
        $builder->set($postData);
        $builder->where(['id' => $id]);
        $builder->update();

        return redirect()->to('/admin/blog-list');
    }

    public function deleteBlog($id)
    {   
        $userDetails = session()->get('userDetails');

        if($userDetails == ''){
            return redirect()->to('/admin/login');
        }

        $db = \Config\Database::connect();
        $builder = $db->table('blog');
        $builder->where(['id' => $id]);
        $builder->update(['status' => 1]);

        return redirect()->to('/admin/blog-list');
    }

    public function saveBlog()
    {   
        $postData = $this->request->getPost();

        $img = $this->request->getFile('doc_upload');

        if($img != ''){

            $validationRule = [
                'userfile' => [
                    'label' => 'Image File',
                    'rules' => 'uploaded[doc_upload]'. '|mime_in[doc_upload,image/jpg,image/jpeg,image/gif,image/png,image/webp,application/pdf]'. '|max_size[doc_upload,2048]'
                ],
            ];
            if (! $this->validate($validationRule)) {

                $imgData = ['errors' => $this->validator->getErrors()];
                return redirect()->back()->withInput()->with('error', $imgData['errors']);
            }
            
            $filepath = 'assets-home/blog';

            if ($img->move($filepath)) {
                $data = [
                    'img_name' => $img->getClientName(),
                    'file'  => $img->getClientMimeType()
                ];

                $postData['image_url'] = $data['img_name'];
            }
        }

        $db = \Config\Database::connect();
        $builder = $db->table('blog');
        $builder->insert($postData);
        
        return redirect()->back()->withInput()->with('success', 'Blog added!');
    }

    public function logout(){
        $this->session->destroy();
        return redirect()->to('/admin/login');
    }
}
