<?php
namespace App\Controllers;
use App\Models\CommonModel;
use App\Models\OnsiteModel;
use App\Models\ZohotokenModel;

class Common extends BaseController{

	public function formSubmit()
	{	
		helper(['custom', 'evenuefy']);
		// 'evenuefy'
		$postData = $this->request->getPost();

		$postData['order_id'] = $this->generateRandomString();

		$commonModel = new CommonModel();

		$checkUser = $commonModel->checkUserExist($postData['email_id'],$postData['mobile_no']);
	
		$result = $commonModel->insert($postData);
		$insertedId = $commonModel->insertID();
		
		$this->session->set('insertedId',$insertedId);
		
		$condition = '';

		/*if($postData['interested_in'] == 'Delegate'){
			$sheetName = 'Delegate';
		}

		if($postData['interested_in'] == 'Exhibitor'){
			$sheetName = 'Exhibitor';
			$condition = 2;
		}
		// send email
		if($postData['interested_in'] == 'Visitor'){
			// $this->sendEmail($postData);
			// evenuefyAPI($postData);
			$sheetName = 'Visitor';
		}

		if($postData['interested_in'] == 'Sponsor'){
			$sheetName = 'Sponsor';
			$condition = 2;
		}*/
        
    if($postData['form_type'] == 'Sponsor-form'){
      $sheetName = 'Sponsor-Registration';

    }elseif($postData['form_type'] == 'Registration-Form'){
    $sheetName = 'Registration';  
    }    

    if($postData['form_type'] == 'Registration-Form'){
    	$this->sendEmail($postData);
    }
    
		// $this->zohoLeads($postData, $insertedId);

		/*if($result){
			$message = array(
               "Message" => "Thank you for your registration!",
               // "EventType" => $postData['interested_in'],
               // "insertedId"=> $insertedId,
               "Status" => true
            );
		}else{
			$message = array(
               "Message" => "Something went wrong, Please try again!",
               "Status" => false
            );
		}*/

		if($checkUser){

				$message = array(
	               "Message" => "You are already registered!",
	               "Status" => true,
	               "UserAccess"=> 2
	               // "insertedId"=> $insertedId,
	      );
		}else{

			if($result){
				$message = array(
               "Message" => "Thank you for your registration!",
               // "insertedId"=> $insertedId,
               "Status" => true
            );

				insertDataToGoogleSheet($postData, $sheetName, $condition);
			}else{
				$message = array(
	               "Message" => "Something went wrong, Please try again!",
	               "Status" => false
	            );
			}
		}

		$this->response->setJSON($message);
        return $this->response;
	}

	public function check()
	{
		echo '<pre>';
		print_r($_GET['code']);
	}

	public function checkDelegate()
	{
		$insertedId = session()->get('insertedId');

		if(isset($insertedId)){

			$db = \Config\Database::connect();
			$builder = $db->table('tbl_registration');
			$builder->where(['id' => $insertedId]);
			$postData = $builder->get()->getRowArray();

			$postData['interested_in'] = 'Delegate';
			$postData['qty'] = 1;

			$commonModel = new CommonModel();

			$result = $commonModel->insert($postData);

			$insertedId = $commonModel->insertID();
			
			$this->session->set('insertedId',$insertedId);

			helper(['custom', 'evenuefy']);
			
			// evenuefyAPI($postData);

			$sheetName = 'Delegate';

			// insert data into google sheet
			insertDataToGoogleSheet($postData, $sheetName);
			
			$this->zohoLeads($postData, $insertedId);

			if($result){
				$message = array(
	               "Message" => "Thank you for your registration!",
	               "EventType" => $postData['interested_in'],
	               "insertedId"=> $insertedId,
	               "Status" => true
	            );
			}else{
				$message = array(
	               "Message" => "Something went wrong, Please try again!",
	               "Status" => false
	            );
			}

			$this->response->setJSON($message);
	        return $this->response;

		}else{
			$message = array(
               "Message" => "Something went wrong, Please try again!",
               "Status" => false
            );

            $this->response->setJSON($message);
	        return $this->response;
		}
	}
	public function formSubmitUpdate(){

		$postData = $this->request->getPost();

		$commonModel = new CommonModel();
		
		$insertedId = session()->get('insertedId');
		
		// $postData['user_id'] = $insertedId;

		$result = $commonModel->updateDelegate($postData, $insertedId);

		/*$delegateId = $commonModel->insertID();

		$this->session->set('delegateId',$delegateId);*/

		if($result){
			$message = array(
               "Message" => "Payment intiated!",
               "PaymentLink"  => true,
               "Qty" => '',
               "Status" => true
            );
		}else{
			$message = array(
               "Message" => "Something went wrong, Please try again!",
               "PaymentLink"  => false,
               "Status" => false
            );
		}

		$this->response->setJSON($message);
        return $this->response;
	
	}

	public function contactFormSubmit()
	{

		$postData = $this->request->getPost();

		$commonModel = new CommonModel();		

		$orderId = $this->generateRandomString();

		$dataArray = array(
			'name' => $postData['name'],
			'email_id' => $postData['email'],
			'mobile_no' => $postData['mobile'],
			'company_name' => $postData['company'],
			'designation' => $postData['designation'],
			'city' => $postData['city'],
			'interested_in' => $postData['interested_in'],
			'web_url' => $postData['web_url1'],
			'order_id' => $orderId,
			'industry' => $postData['industry'],
			'privacy_policy' => $postData['privacy_policy'],

		);
				
		$checkUser = $commonModel->UserExistcontact($postData['email'],$postData['mobile']);		
		
		$result = $commonModel->contactSubmit($dataArray);
		
		$insertedId = $commonModel->insertID();
		
		$this->session->set('insertedId',$insertedId);

		helper(['custom']);

		$condition = '';

		if($postData['interested_in'] == 'Delegate'){
			$sheetName = 'Registration';
		}
	
		if($postData['interested_in'] == 'Sponsor'){
			$sheetName = 'Sponsor-Registration';
		}

		$blankData = '';
		$requestBody = '';
		$requestBody = [
			"range" => $sheetName . "!A2:Z2",
			"majorDimension" => "COLUMNS",
			"values" => [
				[
					$dataArray['name']
				],
				[
					$dataArray['email_id']
				],
				[
					$dataArray['mobile_no']
				],
				[
					$dataArray['company_name']
				],
				[
					$dataArray['designation']
				],
				[
					$dataArray['city']
				],
				[
					$dataArray['industry']
				],
				[
					$orderId
				],
				
				[
					date('d-m-Y')
				],
				[
					$dataArray['web_url']
				],
			]
		];
		
		// $this->zohoLeads($dataArray);

		/*$nameArray = explode(' ', $postData['cname']);
		$lastName = '-';
		if(count($nameArray) > 1){
			$lastName = $nameArray[1];
		}

		$lead_data = [
		    'data' => [
		        [
		            'First_Name' => $nameArray[0],
		            'Last_Name' => $lastName,
		            'Email' => $postData['cemail_id'],
		            'Mobile' => $postData['cmobile_no'],
		            'Phone' => $postData['cmobile_no'],
		            'Company' => $postData['ccompany_name'],
		            'Designation_Name' => $postData['cdesignation'],
		            'City' => $postData['ccity'],
		            'Event_Name' => 'RahstaExpo',
		            'Lead_From' => $postData['web_url1'],
		            // 'Lead_From' => '',
		            'Type_Of_Leads' => $postData['interested_in'],
		            'Stall_Size' => '',
		            'Industry' => $postData['cIndustry'],
		            'OrderId' => '',
		            'Payment_Status' => 'Pending',
		        ]
		    ]
		];

		$this->AddZohoLeads($lead_data);*/

		if($checkUser){

				$message = array(
	               "Message" => "You are already registered!",
	               "Status" => true,
	               "UserAccess"=> 2
	               // "insertedId"=> $insertedId,
	      );
		}else{

			if($result){
				$message = array(
               "Message" => "Thank you for your registration!",
               // "insertedId"=> $insertedId,
               "Status" => true
            );

				insertToGoogleSheet($requestBody, $sheetName, $condition);
			}else{
				$message = array(
	               "Message" => "Something went wrong, Please try again!",
	               "Status" => false
	            );
			}
		}

		$this->response->setJSON($message);
        return $this->response;
	}

	public function studioFormSubmit()
	{
		$postData = $this->request->getPost();

		$commonModel = new CommonModel();

		$emialIdArr = explode('@',strtolower($postData['semail']));

		$emialId = strtolower($emialIdArr[1]);

		if($emialId == 'gmail.com' || $emialId == 'yahoo.com' || $emialId == 'hotmail.com' || $emialId == 'icloud.com' || $emialId == 'reddif.com' || $emialId == 'outlook.com'){
			$message = array(
               "Message" => "Please enter official email address.",
               "Status" => false
            );

            $this->response->setJSON($message);
        	return $this->response;
		}

		$dataArray = array(
			'name' => $postData['sfname'],
			'lname' => $postData['slname'],
			'email_id' => $postData['semail'],
			'mobile_no' => $postData['smobile'],
			'company_name' => $postData['scompany'],
			'designation' => $postData['sdesignation'],
			'requirement' => $postData['srequirement'],
		);
		
		$result = $commonModel->studioSubmit($dataArray);

		// $this->sendStudioEmail($dataArray);

		/*helper(['custom']);

		$sheetName = 'Registration';
		
		$blankData = '';
		$requestBody = '';
		$requestBody = [
			"range" => $sheetName . "!A2:I2",
			"majorDimension" => "COLUMNS",
			"values" => [
				[
					$dataArray['name']
				],
				[
					$dataArray['email_id']
				],
				[
					$dataArray['mobile_no']
				],
				[
					$dataArray['company_name']
				],
				[
					$dataArray['designation']
				],
				[
					$dataArray['city']
				],
				[
					$dataArray['industry']
				],
				[
					$dataArray['interested_in']
				],
				[
					$orderId
				],
				[
					$blankData
				],
				[
					date('d-m-Y')
				],
				[
					$dataArray['web_url']
				],
			]
		];*/
		
		// insertToGoogleSheet($requestBody, $sheetName);

		if($result){
			$message = array(
               "Message" => "Thank you for your registration!",
               "Status" => true
            );
		}else{
			$message = array(
               "Message" => "Something went wrong, Please try again!",
               "Status" => false
            );
		}

		$this->response->setJSON($message);
        return $this->response;
	}

	public function stallFormSubmit()
	{
		$postData = $this->request->getPost();

		$commonModel = new CommonModel();

		$dataArray = array(
			'name' => $postData['wname'],
			'email' => $postData['wemail_id'],
			'mobile_no' => $postData['wmobile_no'],
			'company_name' => $postData['wcompany_name'],
			'designation' => $postData['wdesignation'],
			'stall_size' => $postData['stallSize'],
			'interested_in' => implode(',', $postData['interested_in']),
			'web_url' => $postData['web_url2'],
			'industry' => $postData['industry'],
			'other' => $postData['other'],
			'city' => $postData['wcity'],

		);

		$result = $commonModel->stallSubmit($dataArray);

		helper(['custom']);

		// $sheetName = 'why-Exhibitor';
		$sheetName = 'Exhibitor';
		$condition = 2;

		$blankData = '';
		$requestBody = '';
		$requestBody = [
			"range" => $sheetName . "!A2:Z2",
			"majorDimension" => "COLUMNS",
			"values" => [
				[
					$dataArray['name']
				],
				[
					$dataArray['email']
				],
				[
					$dataArray['mobile_no']
				],
				[
					$dataArray['company_name']
				],
				[
					$dataArray['designation']
				],
				[
					$dataArray['city']
				],
				[
					$dataArray['industry']
				],
				[
					$dataArray['interested_in']
				],
				[
					$blankData
				],
				[
					$dataArray['stall_size']
				],
				[
					date('d-m-Y')
				],
				[
					$dataArray['web_url']
				],
			]
		];
		
		insertToGoogleSheet($requestBody, $sheetName, $condition);

		$this->zohoExhibitorLeads($postData);
		
		if($result){
			$message = array(
               "Message" => "Thank you for your registration!",
               "Status" => true
            );
		}else{
			$message = array(
               "Message" => "Something went wrong, Please try again!",
               "Status" => false
            );
		}

		$this->response->setJSON($message);
        return $this->response;
	}

	public function brochureFormSubmit()
	{
		$postData = $this->request->getPost();

		$commonModel = new CommonModel();

		$dataArray = array(
			'name' => $postData['bname'],
			'email' => $postData['bemail_id'],
			'mobile_no' => $postData['bmobile_no'],
			'company_name' => $postData['bcompany_name'],
			'designation' => isset($postData['bdesignation']) ? $postData['bdesignation'] : '',
			'web_url' => $postData['web_url'],
			'type' => $postData['type'],
			'city' => isset($postData['bcity']) ? $postData['bcity'] : '',
			'industry' => isset($postData['bindustry']) ? $postData['bindustry'] : '' ,
			'topic_of_interest' => isset($postData['topic_of_interest']) ? $postData['topic_of_interest'] : '', 
		);
		
		$result = $commonModel->brochureSubmit($dataArray);
		helper(['custom']);

		$sheetName = 'Brochure-download'; $requestBody = '';
		

		$condition = false;

		if($postData['type'] == 'floor-plan'){
			$condition = 2;
			$sheetName = "Floor-plan";
			$formtype = '';
		}else{
			$formtype = $dataArray['type'];
		}

		$requestBody = [
			"range" => $sheetName . "!A2:Z2",
			"majorDimension" => "COLUMNS",
			"values" => [
				[
					$dataArray['name']
				],
				[
					$dataArray['email']
				],
				[
					$dataArray['mobile_no']
				],
				[
					$dataArray['company_name']
				],
				[
					$dataArray['designation']
				],

				[
					$dataArray['city']
				],
				
				[
					date('d-m-Y')
				],
				[
					$dataArray['web_url']
				],
				[
					$industry = $dataArray['industry']
				],
				[
					$topic_of_interest =  $dataArray['topic_of_interest']
				],
				/*[
					$formtype
				],*/
			]
		];

		insertToGoogleSheet($requestBody, $sheetName, $condition);
		
		if($postData['type'] != 'floor-plan' && $postData['type'] != 'BIS-Report'){
			// $this->sendBroucherEmail($dataArray);	
		}

		if($result){

			$message = array(
	               	"Message" => "Thank you for your registration!",
	               	"fileUrl" => 'https://events.asappinfoglobal.com/mumbai-redevelopment-summit/assets/uploads/mumbai-redevelopment-summit-dec25-brochure.pdf',
	               	"Status" => true
	            );
			
		}else{
			$message = array(
               "Message" => "Something went wrong, Please try again!",
               "Status" => false
            );
		}

		$this->response->setJSON($message);
        return $this->response;
	}

	function generateRandomString(){
	    $comb = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890';
	    $string = array(); 
	    $combLen = strlen($comb) - 1; 
	    for ($i = 0; $i < 8; $i++) {
	        $n = rand(0, $combLen);
	        $string[] = $comb[$n];
	    }
	    return (implode($string)); 
	}

	public function sendBroucherEmail($dataArray)
	{
		helper(['custom']);

		$subject = 'Your RAHSTA Expo Brochure Awaits!';
		$emailBody = '';
		$emailBody = '<p>Hi '.$dataArray['name'].', </p>';
		
		$emailBody .= "<p>Thank you for your interest in the RAHSTA Expo 2025. We're excited to send you your copy of our official brochure, packed with information about the event, exhibitors, and valuable resources.</p>";
		
		$emailBody .= "Click here to download the brochure: <a href='https://rahstaexpo.com/assets/uploads/rahsta-brochure-2025.pdf'>RAHSTA Expo 2025 - Brochure</a></p>";

		$emailBody .= "<p>We're confident your visit to the RAHSTA Expo 2025 will be informative, inspiring, and full of valuable connections.</p>";

		$emailBody .= "<p>Click here to register - <a href='https://rahstaexpo.com/register?utm_source=email&utm_medium=brochure&utm_campaign=emailbrochure_rahsta'>Register Now!</a></p>";

		$emailBody .= "<p>Need additional information or have questions? You can contact us at  +91 86524 93000 or  delegate1@asappinfoglobal.com</p>";

		$emailBody .= "<p>We look forward to seeing you at the RAHSTA Expo 2025!</p>";

		$emailBody .= "<p>Sincerely,<br>The RAHSTA Expo Team</p>";

		send_email($dataArray['email'], $subject, $emailBody);

	}

	public function sendEmail($postData)
	{	
		helper(['custom']);

		$data['postData'] = $postData;

		$emailBody = '';

		$subject = 'You’re One Step Closer to Attending Mumbai Redevelopment Summit 2025';

		$emailBody = view('emails/registrationEmail',$data);  // path to your view

		if($postData){
			// send_email($postData['email_id'], $subject, $emailBody, $condition = 'Event');
			send_email($postData['email_id'], $subject, $emailBody);
			return true;
		}else{
			return false;
		}
		
	}

	public function sendStudioEmail($userDetails)
	{	
		helper(['custom']);

		$emailBody = "";

        $emailBody .="<table id='Table_01' width='600' border='0' cellpadding='0' cellspacing='0' align='center' style='background-color:#fff;'>";
        
        // $emailBody .="<tr><td align='center' style='padding:10px 10px 20px 10px;'><img src='https://rahstaexpo.com/assets-home/img/logo/logo.jpg'></td></tr>";
        
        // $emailBody .="<tr><td style='padding:10px 10px 20px 10px; font-family:Arial, Helvetica, sans-serif; font-size:14px; line-height:22px; color:#555'><p><strong>Dear ".ucfirst($userDetails->first_name).",</strong></p>
        // <p>Thank you for nominating for RAHSTA Expo Awards 2024, Please find the below details for your reference.</p></td></tr>";
        
        $emailBody .="<tr><td style='padding:10px 10px 20px 10px;'><table width='70%' cellpadding='5' cellspacing='0' border='1' align='center' style='border-color:#fbfbfb; text-align:left;'>";
        	$emailBody .="<tr>";
	          	$emailBody .="<td>First Name</td>";
	          	$emailBody .="<td>".$userDetails['name']."</td>";
	        $emailBody .="</tr>";
	        
	        $emailBody .="<tr>";
	          	$emailBody .="<td>Last Name</td>";
	          	$emailBody .="<td>".$userDetails['lname']."</td>";
	        $emailBody .="</tr>";

	        $emailBody .="<tr>";
	          	$emailBody .="<td>Email</td>";
	          	$emailBody .="<td>".$userDetails['email_id']."</td>";
	        $emailBody .="</tr>";
	        
	        $emailBody .="<tr>";
	          	$emailBody .="<td>Mobile No</td>";
	          	$emailBody .="<td>".$userDetails['mobile_no']."</td>";
	        $emailBody .="</tr>";

	        $emailBody .="<tr>";
	          	$emailBody .="<td>Company Name</td>";
	          	$emailBody .="<td>".$userDetails['company_name']."</td>";
	        $emailBody .="</tr>";
	        	
	        $emailBody .="<tr>";
	          	$emailBody .="<td>Designation</td>";
	          	$emailBody .="<td>".$userDetails['designation']."</td>";
	        $emailBody .="</tr>";

	        $emailBody .="<tr>";
	          	$emailBody .="<td>Requirement</td>";
	          	$emailBody .="<td>".$userDetails['requirement']."</td>";
	        $emailBody .="</tr>";

        
        	$emailBody .="</table></td></tr>";
        $emailBody .="</table>";

        $subject = 'Asapp Studio | Lead - RahstaExpo';

		// send_email($postData['email_id'], $subject, $emailBody);
		send_email('dmteam@asappinfoglobal.com,simone.d@asappinfoglobal.com', $subject, $emailBody);
		return true;
		
	}
	public function zohoLeads($postData, $insertedId = '')
	{	
		$token = $this->getToken();

		$nameArray = explode(' ', $postData['name']);
		$lastName = '-';
		if(count($nameArray) > 1){
			$lastName = $nameArray[1];
		}

		$industry = '';
		if(isset($postData['industry'])){
			$industry = $postData['industry'];
		}

		$stallSize = '';
		if(isset($postData['stall_size'])){
			$stallSize = $postData['stall_size'];
		}

		$countryCode = "";
		if(isset($postData['country_code'])){
			$countryCode = '+'.$postData['country_code'];
		}

		$lead_data = [
		    'data' => [
		        [
		            'Name' => $nameArray[0],
		            'Last_Name' => $lastName,
		            'Email' => $postData['email_id'],
		            'Country_Code' => $countryCode,
		            // 'Mobile' => $postData['mobile_no'],
		            'Phone' => $postData['mobile_no'],
		            'company_name' => $postData['company_name'],
		            'Designation' => $postData['designation'],
		            'City' => $postData['city'],
		            // 'Event_Name' => 'RahstaExpo',
		            'Lead_From' => $postData['web_url'],
		            'Type_of_Lead' => $postData['interested_in'],
		            'Stall_Size' => $stallSize,
		            'Industry' => $industry,
		            // 'OrderID' => $insertedId,
		            'Payment_Status' => 'Pending',
		        ]
		    ]
		];

		$leads_url = 'https://www.zohoapis.com/crm/v2/RAHSTA_EXPO_2025';

		// Make the API request to insert the lead
		$ch = curl_init($leads_url);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($lead_data));
		curl_setopt($ch, CURLOPT_HTTPHEADER, [
		    'Authorization: Zoho-oauthtoken ' . $token,
		    'Content-Type: application/json',
		]);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		$response = curl_exec($ch);
		curl_close($ch);

		// Handle the response
		$lead_insert_response = json_decode($response, true);

		/*if($postData['email_id'] == 'rahuljadhav756@gmail.com'){
			echo '<pre>';
			print_r($lead_insert_response);
			exit();
		}*/
		
		// Check for errors
		if (isset($lead_insert_response['data']) && !empty($lead_insert_response['data'])) {
		    // echo "Lead inserted successfully. Lead ID: " . $lead_insert_response['data'][0]['details']['id'];
		    /*$zohoRecordId = $lead_insert_response['data'][0]['details']['id'];

		    $this->updateZohoId($zohoRecordId, $insertedId);*/
		    
		} else {
		    // echo "Error inserting lead. Response: " . print_r($lead_insert_response, true);
		    if($lead_insert_response['code'] == 'INVALID_TOKEN'){
		    	$this->generateAuthTokenFromRefresh(); // create new refresh code
		    	$this->zohoLeads($postData, $insertedId); // call function agains
		    }
		}

		return true;
	}

	public function createCode()
	{
		// Replace these values with your own
		$client_id = '1000.0BKFVFRCJEGN3RC62QAV7L4A63WLTR';
		$client_secret = 'cbfdb381aeb765f3aa0ff58fff0e5b57fb3bad1262';
		$redirect_uri = 'http://localhost/rahsta-expo/check';
		$authorization_code = '1000.04e265f7d868eade988ce9be34249348.01ca29c8208a2988499338160f028ae8';

		$url = 'https://accounts.zoho.in/oauth/v2/token';

		// Prepare data for POST request
		$data = [
		'grant_type' => 'authorization_code',
		'client_id' => $client_id,
		'client_secret' => $client_secret,
		'redirect_uri' => $redirect_uri,
		'code' => $authorization_code
		];

		// cURL POST request to get access token
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		$response = curl_exec($ch);
		curl_close($ch);

		// Decode JSON response
		$result = json_decode($response, true);

		if (isset($result['access_token'])) {
		echo "Access Token: " . $result['access_token'] . "\n";
		echo "Refresh Token: " . $result['refresh_token'] . "\n";
		// Save tokens securely for future use
		} else {
		echo "Error retrieving token:\n";
		print_r($result);
		}
	}
	public function checkZohoLeads()
	{	
		$token = $this->getToken();

		$lead_data = [
		    'data' => [
		        [
		            'Name' => 'Rahul',
		            'Last_Name' => 'Jadhav',
		            'Email' => 'rahul.j@asappmedia.com',
		            'Phone' => '72276463079',
		            'Company' => 'ASAPP Info Global',
		        ]
		    ]
		];

		$leads_url = 'https://www.zohoapis.com/crm/v2/RAHSTA_EXPO_2025';

		// Make the API request to insert the lead
		$ch = curl_init($leads_url);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($lead_data));
		curl_setopt($ch, CURLOPT_HTTPHEADER, [
		    'Authorization: Zoho-oauthtoken ' . $token,
		    'Content-Type: application/json',
		]);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		$response = curl_exec($ch);
		curl_close($ch);

		// Handle the response
		$lead_insert_response = json_decode($response, true);
		
		// Check for errors
		if (isset($lead_insert_response['data']) && !empty($lead_insert_response['data'])) {
		    // echo "Lead inserted successfully. Lead ID: " . $lead_insert_response['data'][0]['details']['id'];
		    // $zohoRecordId = $lead_insert_response['data'][0]['details']['id'];

		    // $this->updateZohoId($zohoRecordId, $insertedId);
		    
		} else {
		    // echo "Error inserting lead. Response: " . print_r($lead_insert_response, true);
		    if($lead_insert_response['code'] == 'INVALID_TOKEN'){
		    	// $this->generateAuthTokenFromRefresh(); // create new refresh code
		    	// $this->checkZohoLeads($postData, $insertedId); // call function agains
		    }
		}

		echo '<pre>';
		print_r($lead_insert_response);
		exit();
		// return true;
	}

	public function AddZohoLeads($lead_data)
	{	
		$token = $this->getToken();

		$leads_url = 'https://www.zohoapis.com/crm/v2/Leads';

		// Make the API request to insert the lead
		$ch = curl_init($leads_url);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($lead_data));
		curl_setopt($ch, CURLOPT_HTTPHEADER, [
		    'Authorization: Zoho-oauthtoken ' . $token,
		    'Content-Type: application/json',
		]);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		$response = curl_exec($ch);
		curl_close($ch);

		// Handle the response
		$lead_insert_response = json_decode($response, true);
		
		// Check for errors
		if (isset($lead_insert_response['data']) && !empty($lead_insert_response['data'])) {
		    // echo "Lead inserted successfully. Lead ID: " . $lead_insert_response['data'][0]['details']['id'];
		    $zohoRecordId = $lead_insert_response['data'][0]['details']['id'];
		    
		} else {
		    // echo "Error inserting lead. Response: " . print_r($lead_insert_response, true);
		    if($lead_insert_response['code'] == 'INVALID_TOKEN'){
		    	$this->generateAuthTokenFromRefresh(); // create new refresh code
		    	$this->AddZohoLeads($lead_data); // call function agains
		    }
		}

		return true;
	}

	public function AddZohoNewsletterLeads($lead_data)
	{	
		$token = $this->getToken();

		$leads_url = 'https://www.zohoapis.com/crm/v2/Website_Popup';

		// Make the API request to insert the lead
		$ch = curl_init($leads_url);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($lead_data));
		curl_setopt($ch, CURLOPT_HTTPHEADER, [
		    'Authorization: Zoho-oauthtoken ' . $token,
		    'Content-Type: application/json',
		]);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		$response = curl_exec($ch);
		curl_close($ch);

		// Handle the response
		$lead_insert_response = json_decode($response, true);
		
		// Check for errors
		if (isset($lead_insert_response['data']) && !empty($lead_insert_response['data'])) {
		    // echo "Lead inserted successfully. Lead ID: " . $lead_insert_response['data'][0]['details']['id'];
		    $zohoRecordId = $lead_insert_response['data'][0]['details']['id'];
		    
		} else {
		    // echo "Error inserting lead. Response: " . print_r($lead_insert_response, true);
		    if($lead_insert_response['code'] == 'INVALID_TOKEN'){
		    	$this->generateAuthTokenFromRefresh(); // create new refresh code
		    	$this->AddZohoNewsletterLeads($lead_data); // call function agains
		    }
		}

		return true;
	}

	public function updateZohoId($zohoRecordId, $insertedId)
	{
		$dataArray = array(
			'zoho_record_id' => $zohoRecordId
		);

		$db = \Config\Database::connect();
		$builder = $db->table('tbl_registration');
		$builder->set($dataArray);
		$builder->where(['id' => $insertedId]);
		$builder->update();
		return true;
	}
	
	public function zohoExhibitorLeads($postData)
	{	
		$token = $this->getToken();
		
		$nameArray = explode(' ', $postData['wname']);
		$lastName = '-';
		if(count($nameArray) > 1){
			$lastName = $nameArray[1];
		}

		$lead_data = [
		    'data' => [
		        [
		            'First_Name' => $nameArray[0],
		            'Last_Name' => $lastName,
		            'Email' => $postData['wemail_id'],
		            'Mobile' => $postData['wmobile_no'],
		            'Phone' => $postData['wmobile_no'],
		            'Company' => $postData['wcompany_name'],
		            'Designation_Name' => $postData['wdesignation'],
		            // 'City' => $postData['city'],
		            'Event_Name' => 'RahstaExpo',
		            'Lead_From' => $postData['web_url2'],
		            'Type_Of_Leads' => 'Exhibitor',
		            'Industry' => $postData['industry'],
		            'Stall_Size' => $postData['stallSize'],
		            'Ideal_Customer' => $postData['interested_in'],
		        ]
		    ]
		];

		$leads_url = 'https://www.zohoapis.com/crm/v2/Leads';

		// Make the API request to insert the lead
		$ch = curl_init($leads_url);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($lead_data));
		curl_setopt($ch, CURLOPT_HTTPHEADER, [
		    'Authorization: Zoho-oauthtoken ' . $token,
		    'Content-Type: application/json',
		]);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		$response = curl_exec($ch);
		curl_close($ch);

		// Handle the response
		$lead_insert_response = json_decode($response, true);

		// Check for errors
		if (isset($lead_insert_response['data']) && !empty($lead_insert_response['data'])) {
		    // echo "Lead inserted successfully. Lead ID: " . $lead_insert_response['data'][0]['details']['id'];
		} else {
		    // echo "Error inserting lead. Response: " . print_r($lead_insert_response, true);
		    if($lead_insert_response['code'] == 'INVALID_TOKEN'){
		    	$this->generateAuthTokenFromRefresh(); // create new refresh code
		    	$this->zohoExhibitorLeads($postData); // call function agains
		    }
		}

		return true;
	}

	public function getToken()
	{
		$zohoModel = new ZohotokenModel();

		$getToken = $zohoModel->getToken();
		$currentTime = time();
		$getTokenTime = strtotime($getToken->created_dt);
		$diff = ($currentTime - $getTokenTime);
		if ($diff > 3500) {
			$token = $this->generateAuthTokenFromRefresh();
		} else {
			$token = $getToken->authToken;
		}
		return $token;
	}

	public function generateAuthTokenFromRefresh()
	{
		// $url = 'https://accounts.zoho.in/oauth/v2/token';
		$url = 'https://accounts.zoho.com/oauth/v2/token';

		/*$refreshCode = '1000.2c2cf63746d6778f707bf59cdb553d9f.8716d9f806ce5cb8366aeab19ba1ca00';
		$fields = array(
			'refresh_token' => $refreshCode,
			'client_id' => '1000.JJHUOMSSQ2TVAH9B80IRIBSQKMKBNU',
			'client_secret' => '43eaf14e6fca77999a6e95ad3152857ddf5268612a',
			'redirect_uri' => 'http://localhost/rahsta-expo/check',
			'grant_type' => 'refresh_token'
		);*/

		$refreshCode = '1000.80a7482aa843f75d2f232d4d96e1a805.3bd40f9791cfb8f61f25902862effd7e';
		$fields = array(
			'refresh_token' => $refreshCode,
			'client_id' => '1000.0BKFVFRCJEGN3RC62QAV7L4A63WLTR',
			'client_secret' => 'cbfdb381aeb765f3aa0ff58fff0e5b57fb3bad1262',
			'redirect_uri' => 'https://rahstaexpo.com/check',
			'grant_type' => 'refresh_token'
		);

		$result = $this->postCurl($url, $fields);
		$result = json_decode($result);

		$access_token = $result->access_token;

		$zohoModel = new ZohotokenModel();
		$zohoModel->insertToken($access_token, $refreshCode);
		return $access_token;
	}

	public function postCurl($url, $fields = array(), $header = array())
	{
		//open connection
		$ch = curl_init();

		//set the url, number of POST vars, POST data
		curl_setopt($ch, CURLOPT_URL, $url);
		// curl_setopt($ch, CURLOPT_POST, count($fields));
		curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

		//execute post
		$result = curl_exec($ch);

		//close connection
		curl_close($ch);

		return $result;
	}

	public function newsletterSignup()
	{	
		helper(['custom']);
		$postData = $this->request->getPost();

		$dataArray = array(
			'name' => $postData['sName'],
			'mobile_no' => $postData['sMobileNo'],
			'email_id' => $postData['sEmail'],
			'privacy_policy' => $postData['sprivacyPolicy'],
			'web_url' => $postData['webURL']
		);

		$db = \Config\Database::connect();
		$builder = $db->table('newsletter');
		$builder->insert($dataArray);

		$result = $db->insertID();
		
		$sheetName = 'newsletter-form';	
		$condition = '';

		$requestBody = '';
		$requestBody = [
			"range" => $sheetName . "!A2:Z2",
			"majorDimension" => "COLUMNS",
			"values" => [
				[
					$dataArray['name']
				],
				[
					$dataArray['mobile_no']
				],
				[
					$dataArray['email_id']
				],
				[
					date('d-m-Y')
				],
				[
					$dataArray['web_url']
				],
			]
		];
		
		if(!empty($postData['sEmail']))
		{
			insertToGoogleSheet($requestBody, $sheetName, $condition);	
		}
			
		
		unset($dataArray['privacy_policy']);
		$dataArray['interested_in'] = 'Newsletter';

		$nameArray = explode(' ', $postData['sName']);
		$lastName = '-';
		if(count($nameArray) > 1){
			$lastName = $nameArray[1];
		}

		$lead_data = [
		    'data' => [
		        [
		            'First_Name' => $nameArray[0],
		            'Last_Name' => $lastName,
		            'Email' => $postData['sEmail'],
		            'Mobile' => $postData['sMobileNo'],
		            'Phone' => $postData['sMobileNo'],
		            'Event_Name' => 'RahstaExpo',
		            'Lead_From' => $postData['webURL'],
		            'Type_Of_Leads' => 'Newsletter',
		            'OrderId' => $result,
		            'Payment_Status' => 'NA',
		        ]
		    ]
		];

		$this->AddZohoLeads($lead_data);

		if($result){
			$message = array(
               "Message" => "Thank you for your registration!",
               "Status" => true
            );
		}else{
			$message = array(
               "Message" => "Something went wrong, Please try again!",
               "Status" => false
            );
		}

		$this->response->setJSON($message);
        return $this->response;
	}

	public function newsletterSignupAfterEvent()
	{	
		helper(['custom']);
		$postData = $this->request->getPost();

		$dataArray = array(
			'email_id' => $postData['newsletterEmail'],
		);

		$db = \Config\Database::connect();
		$builder = $db->table('newsletter');
		$builder->insert($dataArray);

		$result = $db->insertID();

		$sheetName = 'newsletter-signup';

		// insert data into google sheet
		// insertDataToGoogleSheet($postData, $sheetName);


		$lead_data = [
		    'data' => [
		        [
		            'Name' => '-',
		            'Email' => $postData['newsletterEmail'],
		        ]
		    ]
		];

		$this->AddZohoNewsletterLeads($lead_data);

		if($result){
			$message = array(
               "Message" => "Thank you for your registration!",
               "Status" => true
            );
		}else{
			$message = array(
               "Message" => "Something went wrong, Please try again!",
               "Status" => false
            );
		}

		$this->response->setJSON($message);
        return $this->response;
	}

	public function checkCoupon()
	{
		$postData = $this->request->getPost();
		$couponCode =  $postData['couponCode'];

		if($couponCode == ''){
			$session->remove('couponSession');
			$message = array(
				'Message' => 'Please enter coupon code!',
				'Status'=> false,
			);
		}

		$commonModel = new CommonModel();
		$checkCoupon = $commonModel->checkCoupon($couponCode);

		if($checkCoupon == false){
			$this->session->remove('couponSession');
			$message = array(
				'Message' => 'Invalid coupon code!',
				'Status'=> false,
			);
		}else{
			if($couponCode == $checkCoupon->coupon_name){
			
				$this->session->set('couponSession', $checkCoupon->id);

				$this->addCouponDetails($couponCode);

				$message = array(
					'Message' => 'Coupon code applied!',
					'Status'=> true,
				);
			}else{
				$this->session->remove('couponSession');
				$message = array(
					'Message' => 'Invalid coupon code!',
					'Status'=> false,
				);
			}
		}

		$this->response->setJSON($message);
        return $this->response;
	}

	public function addCouponDetails($couponCode=false)
	{	
		$insertedId = 0;
		$insertedId = session()->get('insertedId');

		$dataAarray = array(
			'user_id' => $insertedId,
			'coupon_code' => $couponCode,
		);

		$db = \Config\Database::connect();
		$builder = $db->table('tbl_track_coupon');
		$builder->insert($dataAarray);
		return true;
	}
}