<?php

namespace App\Controllers;

require(APPPATH . "Libraries/razorpay-php/Razorpay.php");

use Razorpay\Api\Api;
use Razorpay\Api\Errors\SignatureVerificationError;
use App\Models\DelegatePaymentModel;
use App\Models\ZohotokenModel;

class DelegatePayment extends BaseController{
	
	public function paymentView()
	{
		$paymentModel = new DelegatePaymentModel();

		$insertedId = session()->get('insertedId');

		if(isset($insertedId)){
			$data = array();

			$data['paymentData'] = $paymentModel->getDelegateDetails($insertedId);
			
			if($data){
				return view('payment/delegate-payment-view',$data);
			}else{
				
				return redirect()->to('/');
			}
		}else{
			return redirect()->to('/');
		}
		
	}

	public function addUsers()
	{	
		$paymentModel = new DelegatePaymentModel();

		$this->session->remove('couponSession');
		
		$insertedId = session()->get('insertedId');
		
		if(isset($insertedId)){
			$data['paymentData'] = $paymentModel->getDelegateDetails($insertedId);

			$delegateDetails = $paymentModel->getOtherDelegate($insertedId);

			if($data['paymentData']->qty == 1){
				$data['delegateDetails'] = $paymentModel->confirmDetails();

			}else if($data['paymentData']->qty > 1 && !empty($delegateDetails))
			{
				$data['delegateDetails'] = $paymentModel->confirmDetails();
			}else{
				$data['delegateDetails'] = '';
			}
			
			echo view('home/header');
			echo view('registration/add-users', $data);
			echo view('home/footer');
		}else{
			return redirect()->to('/register');
		}
	}

	public function addUsersSubmit()
	{	
		$paymentModel = new DelegatePaymentModel();

		$insertedId = session()->get('insertedId');

		$postData = $this->request->getPost();

		if(!empty($postData['details'][0])){
			$count = count($postData['details']);

			for($i =0 ; $i<$count; $i++ ){
				$dataArray = array(
					'name' => $postData['details'][$i]['name'],
					'email_id' => $postData['details'][$i]['email'],
					'mobile_no' => $postData['details'][$i]['mobile_no'],
					'designation' => $postData['details'][$i]['designation'],
					'user_id' => $insertedId,
				);

				$result = $paymentModel->insertDelegate($dataArray);
			}

			$paymentModel->updateGST($insertedId, $postData['gstNo']);

			/*$userDetails = $paymentModel->getDelegateDetails($insertedId);
			$userDelegateDetails = $paymentModel->getOtherDelegate($insertedId);*/
			$confirmDetails = $paymentModel->confirmDetails();
			if($result){
				$message = array(
	               "Message" => "Payment intiated!",
	               "userDetails"  => $confirmDetails,
	               "Status" => true
	            );
			}else{
				$message = array(
	               "Message" => "Something went wrong, Please try again!",
	               "PaymentLink"  => false,
	               "Status" => false
	            );
			}
		}else{
			$message = array(
               "Message" => "Enter all the details!",
               "PaymentLink"  => false,
               "Status" => false
            );
		}

		$this->response->setJSON($message);
        return $this->response;
	}

	public function generateOrder()
	{
		$paymentModel = new DelegatePaymentModel();

	    $key_id = RAZORPAY_LIVE_KEY;
	    $secret = RAZORPAY_LIVE_SECRET;

	    
	    $orderIdd = $this->request->getVar('orderIdd');

	    $api = new Api($key_id, $secret);

	    $insertedId = session()->get('insertedId');

	    $userDetails = $paymentModel->getDelegateDetails($insertedId);

	    $amount = 0;

	    if($userDetails->event_type == 'standard'){
	    	$curMonth = date('m');
	    	$extraAmt = 0;
	    	// $amount =  (9500 * 100) * $userDetails->qty;
	    	$amount =  (9500 * 100);
	    }
	    
	    if($userDetails->event_type == 'delegate'){
	    	/*if($userDetails->number_of_day == 'Early1'){
	    		$amount =  (30000 * 100) * $userDetails->qty;
	    	}else{
	    		$amount =  (35000 * 100) * $userDetails->qty;
	    	}*/

	    	$amount =  (11500 * 100);
	    }

	    /*if($userDetails->event_type == 'vip'){
	    	// $amount =  (50000 * 100) * $userDetails->qty;
	    	if($userDetails->number_of_day == 'Early2'){
	    		$amount =  (45000 * 100) * $userDetails->qty;
	    	}else{
	    		$amount =  (50000 * 100) * $userDetails->qty;
	    	}
	    }*/

	    $couponSessionId = session()->get('couponSession');

	    if(isset($couponSessionId)){

	    	$getCouponDetails = $paymentModel->checkCoupon($couponSessionId);

	    	if(!empty($getCouponDetails->disc_per)){
		    	$discPrice = ($amount * $getCouponDetails->disc_per ) / 100;
		    	$amount = ($amount - $discPrice);
		    }
	    }

	    $orderData = [
	        "receipt" => $orderIdd,
	        "amount" =>  $amount, // this is always in paise
	        "currency" => IND_CURRENCY
	    ];
	    $orderResponse = $api->order->create($orderData);
	    if($orderResponse['id'] != ''){
	        $data = array(
	            "key" => $key_id,
	            "orderId" => $orderResponse['id'],
	            "amount" => $amount
	        );

	        $result = array(
	            "data" =>$data,
	            "status" => true,
	            "message" => "Order Created"
	        );

	    } else {
	        $result = array(
	                // "orderId" => $orderResponse['id'], 
	            "status" => false,
	            "message" => "Order Not Created"
	        );
	    }	

	    $this->response->setJSON($result);
        return $this->response;
	}

	public function verfiySignature()
	{
	    $key_id = RAZORPAY_LIVE_KEY;
	    $secret = RAZORPAY_LIVE_SECRET;
	    
	    $paymentId = '';
	    $signature = '';
	    $orderId = '';
	    $amount = '';

	    if(!empty($this->request->getVar('paymentId'))){
	        $paymentId = $this->request->getVar('paymentId');
	    }

	    if(!empty($this->request->getVar('signature'))){
	        $signature = $this->request->getVar('signature');
	    }
	    
	    if(!empty($this->request->getVar('orderId'))){
	        $orderId = $this->request->getVar('orderId');
	    }
	    
	    if(!empty($this->request->getVar('amount'))){
	        $amount = $this->request->getVar('amount');
	    }
	    
	    $api = new Api($key_id, $secret);
	    
	    $success = true;

	    $error = "Payment Failed";
	    
	    try
	    {
	        // Please note that the razorpay order ID must
	        // come from a trusted source (session here, but could be database or something else)
	        $attributes = array(
	            'razorpay_order_id' => $orderId,
	            'razorpay_payment_id' => $paymentId,
	            'razorpay_signature' => $signature
	        );
	    
	        $api->utility->verifyPaymentSignature($attributes);
	        // print_r($response); exit()
	    }
	    catch(SignatureVerificationError $e)
	    {
	        $success = false;
	        $error = 'Razorpay Error : ' . $e->getMessage();
	    }
	    if ($success === true)
	    {
	        // Capture the Payment After Authorized
	        $captureData = [
		        "amount" =>  $amount,
		        "currency" => IND_CURRENCY
		    ];

		    // $api->payment->fetch($paymentId)->capture($captureData);

	        // $api->payment->fetch($paymentId)->capture(array('amount'=>$amount,'currency' => 'INR'));
	        // $res = $this->grantUserProduct($productId);
	    
	        $result = array(
	        	"remarks"=> true, 
	        	"message" => "Your payment was successful. Payment ID: {$paymentId}",
	        	"paymentId" => $paymentId,
	        	'amount' => $amount,
	        );
	    }
	    else
	    {
	        $result = array(
	        	"remarks"=> false, 
	        	"message" => "Payment Failed. {$error}"
	        );
	    }
		
		$this->response->setJSON($result);
        return $this->response;
	}

	public function updatePaymentStatus()
	{
		$postData = $this->request->getPost();

		$transactionStatus = '';
		if($postData['remarks'] == true){
			$transactionStatus = 'Success';
		}

		$paymentModel = new DelegatePaymentModel();

		$couponSessionId = session()->get('couponSession');

		$couponName = '';
	    if(isset($couponSessionId)){
			$getCouponDetails = $paymentModel->checkCoupon($couponSessionId);
			$couponName = $getCouponDetails->coupon_name;
		}else{
			$couponSessionId = 0;
		}

		$dataAarray = array(
			'transaction_id' => $postData['paymentId'],
			'transaction_status' => $transactionStatus,
			'transaction_date' => date('Y-m-d'),
			'user_id' => $postData['userId'],
			'order_id' => $postData['orderIdd'],
			'pay_for' => 'delegate',
			'form_name' => '-',
			'category_id' => 0,
			'coupon_id' => $couponSessionId,
			'coupon_code' => $couponName,
			'amount_paid' => ($postData['amount']/100),
		);

		// $paymentModel = new DelegatePaymentModel();
		$paymentModel->updatePaymentStatus($dataAarray);
		
		if($postData['remarks'] == true){
			$this->sendPaymentMail($postData);

			$message = array(
				'message' => 'Payment successful',
                'status' => true,
            );
		}else{
			$message = array(
				'message' => 'Payment failed!',
                'status' => false,
            );
		}
		
		$this->response->setJSON($message);
        return $this->response;
	}
	public function testPayment()
	{
		$dataAarray = array(
			'transaction_id' => 'pay_NXtsk0A2MnRR2t',
			'transaction_status' => 'success',
			'transaction_date' => date('Y-m-d'),
			'user_id' => 72,
			'orderIdd' => 'HhuOR7S3',
			'pay_for' => 'delegate',
			'form_name' => '-',
			'category_id' => 0,
		);

		$this->sendPaymentMail($dataAarray);
	}

	public function sendPaymentMail($postData)
	{	
		helper(['custom']);
		$paymentModel = new DelegatePaymentModel();

		$userDetails = $paymentModel->getUserDetailsByOrder($postData['orderIdd']);

		$sheetName = 'delegate-payment-details';

		$emailBody = "";

        $emailBody .="<table id='Table_01' width='600' border='0' cellpadding='0' cellspacing='0' align='center' style='background-color:#fff;'>";
        
        $emailBody .="<tr><td align='center' style='padding:10px 10px 20px 10px;'><img src='https://events.asappinfoglobal.com/mumbai-redevelopment-summit/assets/images/logos/logo.jpg'></td></tr>";
        
        $emailBody .="<tr><td style='padding:10px 10px 20px 10px; font-family:Arial, Helvetica, sans-serif; font-size:14px; line-height:22px; color:#555'><p><strong>Dear ".ucfirst($userDetails->name).",</strong></p>
        <p>Thank you for your payment! Your spot at the Mumbai Redevelopment Summit is secured – get ready for an insightful event.</p></td></tr>";
        
        $emailBody .="<tr><td style='padding:10px 10px 20px 10px;'><table width='70%' cellpadding='5' cellspacing='0' border='1' align='center' style='border-color:#fbfbfb; text-align:left;'>";

        $emailBody .="<tr>";
          	$emailBody .="<td>Name</td>";
          	$emailBody .="<td>".$userDetails->name."</td>";
        $emailBody .="</tr>";
        
        $emailBody .="<tr>";
          	$emailBody .="<td>Email</td>";
          	$emailBody .="<td>".$userDetails->email_id."</td>";
        $emailBody .="</tr>";
        
        $emailBody .="<tr>";
          	$emailBody .="<td>Mobile No</td>";
          	$emailBody .="<td>".$userDetails->mobile_no."</td>";
        $emailBody .="</tr>";

        $emailBody .="<tr>";
          	$emailBody .="<td>Company Name</td>";
          	$emailBody .="<td>".$userDetails->company_name."</td>";
        $emailBody .="</tr>";

        /*$emailBody .="<tr>";
          	$emailBody .="<td>No. Of Day</td>";
          	$emailBody .="<td>".$userDetails->number_of_day."</td>";
        $emailBody .="</tr>";

        $emailBody .="<tr>";
          	$emailBody .="<td>Pass Access</td>";
          	$emailBody .="<td>".ucfirst($userDetails->event_type)."</td>";
        $emailBody .="</tr>";*/

        $emailBody .="<tr>";
          	$emailBody .="<td>Payment Status</td>";
          	$emailBody .="<td>".$userDetails->transaction_status."</td>";
        $emailBody .="</tr>";

	        if($userDetails->transaction_status == 'Success' || $userDetails->transaction_status == 'success'){
	        	$emailBody .="<tr>";
	            	$emailBody .="<td>Payment Date</td>";
	            	$emailBody .="<td>".$userDetails->transaction_date."</td>";
	          	$emailBody .="</tr>";
	        }
        
        	$emailBody .="</table></td></tr>";
        $emailBody .="</table>";

        $subject = 'MRS | Payment - '.$userDetails->order_id;
		if($userDetails){
			send_email($userDetails->email_id, $subject, $emailBody);

			// insertDataToGoogleSheet($userDetails, $sheetName, $condition = 1);
			$condition = '';
			$blankData = '';
			$requestBody = '';
			$requestBody = [
				"range" => $sheetName . "!A2:Z2",
				"majorDimension" => "COLUMNS",
				"values" => [
					[
						$blankData
					],
					[
						$userDetails->name
					],
					/*[
						$userDetails->qty
					],*/
					[
						$userDetails->company_name
					],
					[
						$userDetails->designation
					],
					[
						$userDetails->mobile_no
					],
					[
						$userDetails->email_id
					],
					[
						$userDetails->city
					],
					[
						$userDetails->amount_paid
					],
					[
						$userDetails->gst_no
					],
					[
						'Razorpay'
					],
					[
						$userDetails->transaction_id
					],
					[
						date('d-m-Y')
					],
				]
			];
			
			insertToGoogleSheet($requestBody,$sheetName,$condition);

			// $this->zohoPaymentStatus($userDetails);
			return true;
		}else{
			return false;
		}
		
	}

	public function zohoPaymentStatus($userDetails){

		$token = $this->getToken();

		$lead_data = [
		    'data' => [
		        [
		            'Payment_Status' => $userDetails->transaction_status,
		            // 'Payment_Status' => 'Success',
		        ]
		    ]
		];

		$leads_url = 'https://www.zohoapis.in/crm/v2/Leads/'.$userDetails->zoho_record_id;
		// $leads_url = 'https://www.zohoapis.in/crm/v2/Leads/487607000001429077';

		$ch = curl_init($leads_url);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
		curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($lead_data));
		curl_setopt($ch, CURLOPT_HTTPHEADER, [
		    'Authorization: Zoho-oauthtoken ' . $token,
		    'Content-Type: application/json',
		]);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		$response = curl_exec($ch);
		curl_close($ch);

		$lead_insert_response = json_decode($response, true);
		return true;
		/*echo '<pre>';
		print_r($lead_insert_response);
		exit();*/
	}

	public function getToken()
	{
		$zohoModel = new ZohotokenModel();

		$getToken = $zohoModel->getToken();
		$currentTime = time();
		$getTokenTime = strtotime($getToken->created_dt);
		$diff = ($currentTime - $getTokenTime);
		if ($diff > 3500) {
			$token = $this->generateAuthTokenFromRefresh();
		} else {
			$token = $getToken->authToken;
		}
		return $token;
	}

	public function generateAuthTokenFromRefresh()
	{
		$url = 'https://accounts.zoho.in/oauth/v2/token';

		$refreshCode = '1000.2c2cf63746d6778f707bf59cdb553d9f.8716d9f806ce5cb8366aeab19ba1ca00';
		$fields = array(
			'refresh_token' => $refreshCode,
			'client_id' => '1000.JJHUOMSSQ2TVAH9B80IRIBSQKMKBNU',
			'client_secret' => '43eaf14e6fca77999a6e95ad3152857ddf5268612a',
			'redirect_uri' => 'http://localhost/rahsta-expo/check',
			'grant_type' => 'refresh_token'
		);

		$result = $this->postCurl($url, $fields);
		$result = json_decode($result);

		$access_token = $result->access_token;

		$zohoModel = new ZohotokenModel();
		$zohoModel->insertToken($access_token, $refreshCode);
		return $access_token;
	}
	
	public function postCurl($url, $fields = array(), $header = array())
	{
		//open connection
		$ch = curl_init();

		//set the url, number of POST vars, POST data
		curl_setopt($ch, CURLOPT_URL, $url);
		// curl_setopt($ch, CURLOPT_POST, count($fields));
		curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

		//execute post
		$result = curl_exec($ch);

		//close connection
		curl_close($ch);

		return $result;
	}

	public function paymentThankyou()
	{
		return view('payment/delegate-thankyou');
	}
}