<?php
namespace App\Controllers;

use CodeIgniter\RESTful\ResourceController;
use CodeIgniter\API\ResponseTrait;
use Firebase\JWT\JWT;
use Firebase\JWT\Key;

class Impacct extends ResourceController
{
    use ResponseTrait;

    private $secretKey;

    public function __construct()
    {
        $this->secretKey = getenv('JWT_SECRET_KEY') ?: "ASAPPSecretKey2025!@#"; // use .env or default
    }

    // Verify JWT token
    private function verifyJWT()
    {
        $authHeader = $this->request->getHeaderLine('Authorization');
        if (!$authHeader) return false;

        $arr = explode(" ", $authHeader);
        $jwt = $arr[1] ?? null;
        if (!$jwt) return false;

        try {
            $decoded = JWT::decode($jwt, new Key($this->secretKey, 'HS256'));
            return $decoded->data;
        } catch (\Exception $e) {
            return false;
        }
    }

    // Save details API
    public function saveDetails()
    {
        // Check JWT
        $userData = $this->verifyJWT();
        if (!$userData) {
            return $this->response->setStatusCode(401)->setJSON([
                'status'  => 'error',
                'message' => 'Unauthorized access. Invalid or missing token.'
            ]);
        }

        // Get JSON body
        $postData = $this->request->getJSON(true);

        // Google reCAPTCHA
        $secretKey = "6LeIhJUrAAAAACEd6p7TRXWhfuoWX1j1LnNk00zY";
        $captcha = $postData['g-recaptcha-response'] ?? '';

        $verifyResponse = file_get_contents(
            "https://www.google.com/recaptcha/api/siteverify?secret={$secretKey}&response={$captcha}"
        );
        $responseData = json_decode($verifyResponse);

        if (!$responseData->success) {
            return $this->response->setJSON([
                'status'  => 'error',
                'message' => 'Captcha verification failed.',
            ]);
        }

        // Prepare data
        $data = [
            'fname'         => $postData['fname'] ?? '',
            'lname'         => $postData['lname'] ?? '',
            'mobile_no'     => $postData['mobile_no'] ?? '',
            'email_id'      => strtolower($postData['email_id'] ?? ''),
            'designation'   => $postData['designation'] ?? '',
            'company_name'  => $postData['company_name'] ?? '',
            'web_site'      => $postData['web_site'] ?? '',
            'business_type' => $postData['business_type'] ?? '',
            'message'       => $postData['message'] ?? '',
        ];

        $db = \Config\Database::connect();
        $builder = $db->table('impacctleads');
        $insert = $builder->insert($data);

        if ($insert) {
            return $this->response->setJSON([
                'status'  => true,
                'message' => 'Your information has been submitted successfully.',
            ]);
        } else {
            return $this->response->setJSON([
                'status'  => false,
                'message' => 'Database insert failed.',
            ]);
        }
    }
}
?>
