<?php
	namespace App\Controllers;

	use App\Models\UsersModel;
	use App\Models\PassesModel;
	use App\Models\AttendeesModel;
	use App\Models\InvoiceModel;
	use App\Models\InvoiceDetailsModel;

	class Passes extends BaseController{

		public function getPasses()
		{
			$userId = session()->get('loginId'); // login id
	        if(isset($userId)){
	            $model = new UsersModel();
	            $eventsModel = new PassesModel();

	            $data['userDetails'] = $model->getUserDetails($userId); // get user details from db
	            $data['eventDetails'] = $eventsModel->getEventDetails();
	            $data['countryDetails'] = $model->getCountry();
	            $data['genderDetails'] = $model->getGender();
	            $data['jobRole'] = $model->getJobRole();
	        	return view('passes/passes-view', $data);
	        }
	        return view('passes/passes-view');
		}

		public function setTickets(){

			$postData = $this->request->getPost();
			
	        if($postData){
	            // set session

	        	$eventsModel = new PassesModel();
	        	$attData = $eventsModel->setAttDetails($postData);
	        	$purchaseData = $eventsModel->setPurchaseDetails($postData);
	            $ses_data = [
	                'qty' => $postData['qty'],
	                'selectEvent' => $postData['selectEvent'],
	            ];
	            
	            $this->session->set($ses_data);
	            
	            $message = array(
	               "Message" => "Event selected!",
	               "Data" => $attData,
	               "PurchaseData" => $purchaseData,
	               "Status" => true
	            );
	        }else{
	            $message = array(
	               "Message" => "Please select event!",
	               "Data" => '',
	               "PurchaseData" => '',
	               "Status" => false
	            );
	        }

	        $this->response->setJSON($message);
	        return $this->response;	    
		}

		public function getTickets(){

			$postData = $this->request->getPost();

			$userId = $this->session->get('loginId');
			$eventId = $postData['selectEvent'];

			$eventsModel = new PassesModel();

			$eventDetails = $eventsModel->getEventById($eventId);
			$qty = $postData['qty'];

			$totalAmount = $qty * $eventDetails->event_price;

			$invData = array(
				'user_id' => $userId,
				// 'invoice_no' => date('Ymd').$userId,
				'email_id' => $postData['billEmail'],
			    'first_name' => $postData['billFirstName'],
			    'last_name' => $postData['billLastName'],
			    'company_name' => $postData['billCompanyName'],
			    'country_id' => $postData['billCountry'],
			    'postal_code' => $postData['billPostalCode'],
			    // 'job_role' => $postData['billJobRole'],
			    'gende_id' => $postData['billGender'],
			    'mobile_no' => $postData['billMobileNo'],
			    'event_id' => $eventId,
			    'qty' => $postData['qty'],
			    'total_amount' => $totalAmount,
			);
			$invoiceModel = new InvoiceModel();
			$invoiceModel->insert($invData);
			
			$invId = $invoiceModel->insertID();

			$this->session->set('invoiceId', $invId);

			$invDetailsModel = new InvoiceDetailsModel();

			$qty = $postData['qty'];
			$attendeesArray = array();
			for ($i=1; $i <= $qty ; $i++) { 
				$attSession = $this->session->get('attenId'.$i);
				array_push($attendeesArray, $attSession);

				$invDetailsData = array(
					'invoice_id' => $invId,
					'user_id' => $userId,
					'attendees_id' => $attSession,
					'created_date' => date('Y-m-d'),
				);

				$invDetailsModel->insert($invDetailsData);
			}

	        if($postData){
	            // set session

	        	$eventsModel = new PassesModel();
	        	$billingDetails = $eventsModel->getPurchaseBillingDetails($postData, $invId);
	        	$purchaseData = $eventsModel->getPurchaseDetails($postData);
	            
	            $message = array(
	               "Message" => "Event selected!",
	               "Data" => $billingDetails,
	               "PurchaseData" => $purchaseData,
	               "Status" => true
	            );
	        }else{
	            $message = array(
	               "Message" => "Please select event!",
	               "Data" => '',
	               "PurchaseData" => '',
	               "Status" => false
	            );
	        }

	        $this->response->setJSON($message);
	        return $this->response;	    
		}

		public function submitAttenData(){


			$postData = $this->request->getPost();
			
	        if($postData){

	        	$attendModel = new AttendeesModel();
		        
		        $data = array(
					'user_id' => session()->get('loginId'),
					'first_name' => $postData['attFirstName'],
					'last_name' => $postData['attLastName'],
					'email_id' => $postData['attEmail'],
					'mobile_no' => $postData['attMobileNo'],
					'company_name' => $postData['attCompanyName'],
					'designation' => $postData['attDesignation'],
					'job_role' => $postData['attJobRole'],
					'country_id' => $postData['attCountry'],
					'state_name' => $postData['attState'],
					'city_name' => $postData['attCity'],
					'address' => $postData['attAddress'],
					'postal_code' => $postData['attPostalCode'],
					'gende_id' => $postData['attGender'],
					'website' => $postData['attWebsite'],
					'linkedin' => $postData['attLinkedIn'],
					'twitter' => $postData['attTwitter'],
					'company_size' => $postData['attCompnaySize'],
					'email_send_status' => $postData['sendEmailStatus'],
					'created_date' => date('Y-m-d'),
				);
				if($postData['updateVal'] != 0){
					$attendModel->updateAttendeesDetails($data, $postData['updateVal']);
					$insertedId = $postData['updateVal'];

					$message = array(
		               "Message" => "Attendees details updated!",
		               'InsertId' => $insertedId,
		               "Status" => true
		            );
				}else{
					$attendModel->insert($data);
					$insertedId = $attendModel->insertID();

					$message = array(
		               "Message" => "Attendees details saved!",
		               'InsertId' => $insertedId,
		               "Status" => true
		            );

		            $this->session->set('attenId'.$postData['attNo'], $insertedId);
				}
				
/*	            $attSession = $this->session->get('attenId');

	            if(isset($attSession)){
	            	$_SESSION['attenId'] .= $insertedId.',';
	            }else{
	            	$_SESSION['attenId'] = $insertedId.',';
	            	// $attSession = $this->session->get('attenId');
	            }*/
				
	        }else{
	            $message = array(
	               "Message" => "Please try again!",
	               'InsertId' => 0,
	               "Status" => false
	            );
	        }

	        $this->response->setJSON($message);
	        return $this->response;	    
		
		}
	}
?>