<?php
	namespace App\Controllers;

	use App\Models\UsersModel;

	class Users extends BaseController{

		public function index()
		{
			$userId = session()->get('loginId'); // login id
	        if(isset($userId)){
	            /*$model = new UsersModel();
	            $data['userDetails'] = $model->getUserDetails($userId); // get user details from db*/
	            // return view('nomination/register-form',$data);
	            return redirect()->to('/ticket');
	        }

	        return view('users/register-view');
		}

		public function registerNew()
		{
			return view('users/registration-view');
		}

		public function registerUser(){
	        helper(['custom']);
	        $model = new UsersModel();

	        // $request = \Config\Services::request();
	        // echo 1;
	        $postData = $this->request->getPost();

	        $mandatoryFields = array('first_name','last_name','email_id','company_name', 'designation', 'city', 'password');
	        
	        /*foreach($mandatoryFields as $mf) {
	            if(empty($postData->$mf)) {
	                $response = array(
	                   "Message" => "No ". $mf . " Found.",
	                   "Status" => false
	                );
	                return $response;
	            }
	        }*/

	        $checkUser  = $model->checkUser($postData['email_id']);
	        
	        if(empty($checkUser)){
	            $postData['password'] = base64_encode($postData['password']);
	            $postData['created_date'] = date('Y-m-d');

	            $result = $model->insert($postData);

	            $emailBody  = "<html><body>";
	            $emailBody .= "<table width='100%' bgcolor='#e0e0e0' cellpadding='0' cellspacing='0' border='0'>";
	            $emailBody .= "<tr><td>";
	            $emailBody .= "<table align='center' width='100%' border='0' cellpadding='0' cellspacing='0' style='max-width:650px; background-color:#fff; font-family:Verdana, Geneva, sans-serif;'>";
	            $emailBody .= "<thead>
	            <tr height='80'>
	            <th colspan='4' style='border-bottom:solid 1px #bdbdbd; font-family:Verdana, Geneva, sans-serif; color:#333; font-size:34px;' >
	            <img src='https://cementexpo.in/assets-home/img/logo/logo.png' alt='https://cementexpo.in/'></th></tr></thead>";
	            $emailBody .= "<tbody><tr><td colspan='4' style='padding:15px;'><p style='font-size:20px;'>Dear ".$postData['first_name'].",</p><p style='font-size:18px;'>
	            Thank you. We have received your registration for the CementExpo Awards 2023.</p>
	            <p style='font-size:18px;'>Please find your details below:</p>

	            <table border='1px solid;'>
	                <tr>
	                    <td>Name</td>
	                    <td>".$postData['first_name'] .' ' .$postData['last_name']. "</td>
	                </tr>
	                <tr>
	                    <td>Email</td>
	                    <td>".$postData['email_id']."</td>
	                </tr>

	                <tr>
	                    <td>Company Name</td>
	                    <td>".$postData['company_name']."</td>
	                </tr>

	                <tr>
	                    <td>City</td>
	                    <td>".$postData['city']."</td>
	                </tr>

	            </table>

	            <p style='font-size:18px;'>You may login to your account from this link to complete the nomination and payment process <a target='_blank' href='https://cementexpo.in/nomination'>https://cementexpo.in/nomination</a></p>

	            <p style='font-size:20px;'>Regards,</p><p style='font-size:18px;'>Team CementExpo</p></td></tr></tbody>";
	            $emailBody .= "</table>";
	            $emailBody .= "</td></tr>";
	            $emailBody .= "</table>";
	            $emailBody .= "</body></html>";

	            $emaiilSubject = 'CementExpo - Nomination Registration';
	            $condition = 1;
	            // send_email($postData['email_id'],$emaiilSubject, $emailBody, $condition);

	            $message = array(
	               "Message" => "Thank you for your registration, Please login to fill the form!",
	               "Status" => true
	            );

	            $sheetName = 'nomination-registration';
	            $requestBody = [
	                "range" => $sheetName . "!A2:I2",
	                "majorDimension" => "COLUMNS",
	                "values" => [
	                    [
	                        $postData['first_name']
	                    ],
	                    [
	                        $postData['last_name']
	                    ],
	                    [
	                        $postData['email_id']
	                    ],
	                    [
	                        $postData['mobile_no']
	                    ],
	                    [
	                        $postData['company_name']
	                    ],
	                    [
	                        $postData['designation']
	                    ],
	                    [
	                        $postData['city']
	                    ],
	                    [
	                        date('d-m-Y')
	                    ]
	                ]
	            ];
	            // insertToGoogleSheet($requestBody, $sheetName);
	        }else{
	            $message = array(
	               "Message" => "You are already a registered user. Please login to fill the form!",
	               "Status" => false
	            );
	        }
	        $this->response->setJSON($message);
	        return $this->response;
	    }

    	public function loginUser()
	    {
	        $model = new UsersModel();

	        $postData = $this->request->getPost();

	        $chkLogin = $model->checkLogin($postData);

	        if($chkLogin){
	            // set session

	            $ses_data = [
	                'userLogged' => true,
	                'loginId' => $chkLogin->id,
	                'userName' => $chkLogin->first_name .' '. $chkLogin->last_name,
	                'userEmail' => $chkLogin->email_id,
	            ];
	            
	            $this->session->set($ses_data);
	            // print_r(session()->get('loginId'));
	            $message = array(
	               "Message" => "Login successful, Redirection to dashboard!",
	               "Status" => true
	            );
	        }else{
	            $message = array(
	               "Message" => "Please enter valid email address and password!",
	               "Status" => false
	            );
	        }

	        $this->response->setJSON($message);
	        return $this->response;
	    }

	    public function SocialLogin()
	    {

			$postData = $this->request->getJSON();

			if(empty($postData)){
				$message = array(
		           	"Message" => "No data found!",
		           	"Status" => false
		        );

		        $this->response->setStatusCode(400);
		        $this->response->setContentType('application/json');
		        $this->response->setJSON($message);
		        return $this->response;
			}

			if(!empty($postData)){
				$userData = json_decode(base64_decode(str_replace('_', '/', str_replace('-','+',explode('.', $postData->credential)[1]))));

				$model = new UsersModel();
				$checkUser = $model->getUserByEmail($userData->email);

				if($checkUser){

					$this->setSession($checkUser); // set user seeion

					$message = array(
		               "Message" => "Login Successful, Redirecting...",
		               "Status" => true,
		            );

		            $this->response->setStatusCode(200);
		            $this->response->setContentType('application/json');
		            $this->response->setJSON($message);
		            return $this->response;
				}else{

					$nameArray = explode(' ', $userData->given_name);

					$userDataInsert = array(
						'email_id' => $userData->email,
						'first_name' => $nameArray[0],
						// 'last_name' => $lastName,
						'email_verified' => $userData->email_verified,
						'profile_image' => $userData->picture,
						'register_from' => 'google',
						'created_date' => date('Y-m-d'),
						'registeryear' => date('Y'),
					);

					// register user
					$result = $model->insert($userDataInsert);

					if($result){
						$checkUser = $model->getUserByEmail($userData->email);

						$this->setSession($checkUser); // set user seeion

						$message = array(
			               "Message" => "Login Successful, Redirecting...",
			               "Status" => true,
			            );

			            $this->response->setStatusCode(200);
			            $this->response->setContentType('application/json');
			            $this->response->setJSON($message);
			            return $this->response;
					}else{
						$message = array(
			               "Message" => "Something went wrong. ",
			               "Status" => false,
			            );
			            $this->response->setStatusCode(400);
			            $this->response->setContentType('application/json');
			            $this->response->setJSON($message);
			            return $this->response;
					}
				}
			}
		
	    }

	    public function setSession($checkUser)
	    {	
	    
	    	$ses_data = [
			                'userLogged' => true,
			                'loginId' => $checkUser[0]->id,
			                'userName' => $checkUser[0]->first_name .' '. $checkUser[0]->last_name,
			                'userEmail' => $checkUser[0]->email_id,
			            ];
			            
			$this->session->set($ses_data);
			return true;
	    }

	    public function getProfile()
	    {
	    	return view('users/profile-view');
	    }

	    public function logout()
	    {
	        $this->session->destroy();
	        return redirect()->to('/');
	    }
	}
?>