<?php
namespace App\Models;
use CodeIgniter\Model;

class NominationModel extends Model{
	
	/*function __construct(){
		$this->db = \Config\Database::connect();
	}*/

	protected $table = 'user_form';
	protected $primaryKey = 'user_form_make_id';
	protected $allowedFields = [
		'email_id',
		'password',
		'verfied_email',
		'encryption_key',
		'first_name',
		'last_name',
		'company_name',
		'product_name',
		'website_url',
		'company_type',
		'designation',
		'address',
		'city',
		'state',
		'postal_code',
		'phone_number',
		'mobile_number',
		'registeryear',
		'registerdate',
		'gst_number',
		'status',
		'nominate_id',
		'nomination_idd',
		'sourceURL',
	];

	protected $returnType = 'object';

	function checkUser($emailId)
	{	
		$db = \Config\Database::connect();
		$builder = $db->table('user_form');
		$builder->where(['email_id'=>$emailId]);
		$builder->where(['registeryear'=>date("Y")]);
		$query = $builder->get()->getResult();
		/*if(!empty($query)) {
            return $query;
        }*/
        return $query;
	}

	public function checkLogin($postData)
	{	
		$db = \Config\Database::connect();
		$builder = $db->table('user_form');
		$builder->where(['email_id'=>$postData['login_email']]);
		$builder->where(['password'=> base64_encode($postData['login_password'])]);
		$builder->where(['registeryear'=>$postData['login_year']]);
		$query = $builder->get()->getRow();
		return $query;
	}

	public function getUserDetails($userId)
	{	
		$db = \Config\Database::connect();
		$builder = $db->table('user_form');
		$builder->where(['user_form_make_id' => $userId]);
		// $builder->where(['registeryear'=> '2022']);
		$query = $builder->get()->getRow();
		return $query;
	}

	public function getNominationCategory()
	{	
		$db = \Config\Database::connect();
		$builder = $db->table('tbl_category_master');
		$builder->where(['status' => 0]);
		$builder->where(['year'=> '2024']);
		$query = $builder->get()->getResult();
		return $query;
	}

	public function getCategoryQuestions($nominationCategory)
	{	
		$db = \Config\Database::connect();

		$categoryArray = array();
		foreach ($nominationCategory as $key => $category) {
			$builder = $db->table('tbl_categoey_questions');
			$builder->where(['category_id' => $category->id]);
			$builder->where(['status' => 0]);
			$query = $builder->get()->getResult();
			array_push($categoryArray, $query);

			/*foreach ($query as $key => $value) {
				echo "var ".$value->column_name." = document.getElementById(".$value->column_name.").value;";
				echo 'if(!'.$value->column_name.')
				{
					document.getElementById('.$value->column_name.').focus();
					return false;
				}';
				echo '<br>';
			}
			echo '<br>';*/
		}

		if($categoryArray){
			return $categoryArray;
		}else{
			return false;
		}
	}

	public function getQuestionColumnById($nomId)
	{	
		$db = \Config\Database::connect();

		$builder = $db->table('tbl_categoey_questions');
		$builder->where(['category_id' => $nomId]);
		$builder->where(['status' => 0]);
		$query = $builder->get()->getResult();

		if($query){
			return $query;
		}else{
			return false;
		}
	}

	public function getOrderID($userId, $userDetails)
	{	
		$db = \Config\Database::connect();
		$builder = $db->table('user_form as user');
		$builder->join('tbl_transaction_details as trans','user.user_form_make_id = trans.user_id');
		$builder->where(['user_form_make_id' => $userId]);
		$builder->where(['trans.nomination_idd' => $userDetails->nomination_idd]);
		$builder->where(['trans.category_id' => $userDetails->nominate_id]);
		$query = $builder->get()->getRow();
		if($query){
			return $query;
		}else{
			return false;
		}
	}

	public function getNominatedDetails($userId,$nominationIdd)
	{
		$tblName = $this->getTableName($nominationIdd);

		$db = \Config\Database::connect();
		$builder = $db->table($tblName->db_table_name);
		$builder->where(['user_ref_id' => $userId]);
		$builder->where(['nomination_status = '=> '']);
		$query = $builder->get()->getRow();
		return $query;	
	}

	public function updateFormDetails($dataArray)
	{	
		$userId = session()->get('loginId'); // login id

		$db = \Config\Database::connect();
		$builder = $db->table('user_form');
		$builder->set($dataArray);
		$builder->where(['user_form_make_id' => $userId]);
		$builder->update();
		return true;
	}

	public function checkNomination($userId,$nomId)
	{	
		$tblName = $this->getTableName($nomId);

		$db = \Config\Database::connect();
		$builder = $db->table($tblName->db_table_name);
		$builder->where(['user_ref_id' => $userId]);
		$builder->where(['nomination_status = '=> '']);
		$query = $builder->get()->getRow();
		if($query){
			return $query;
		}
		return false;
	}

	public function updateNominationDetails($userId,$dataArray,$nomId)
	{	
		$tblName = $this->getTableName($nomId);

		$db = \Config\Database::connect();
		$builder = $db->table($tblName->db_table_name);
		$builder->set($dataArray);
		$builder->where(['user_ref_id' => $userId]);
		$builder->update();
		return true;
	}

	public function insertNominationDetails($userId,$dataArray,$nomId)
	{
		$tblName = $this->getTableName($nomId);

		$dataArray['user_ref_id'] = $userId;
		$db = \Config\Database::connect();
		$builder = $db->table($tblName->db_table_name);
		$builder->insert($dataArray);

		$insertedId = $db->insertID();

		$this->insertTransactionDetails($userId,$insertedId,$nomId,$tblName->category_name);
		if($insertedId){
			return $insertedId;
		}else{
			return false;
		}
	}

	public function insertTransactionDetails($userId,$insertedId,$nomId,$formName)
	{	
		$orderId = 'RAHSTAEXPO'.$nomId.date('Ymd').time().$insertedId;

		$dataArray = array(
			'nomination_idd' => $insertedId,
			'order_id' => $orderId,
			'category_id' => $nomId,
			'user_id' => $userId,
			'form_name' => $formName,
		);

		$db = \Config\Database::connect();
		$builder = $db->table('tbl_transaction_details');
		$builder->insert($dataArray);
		return true;
	}

	public function getOrderDetails($userId)
	{	
		$db = \Config\Database::connect();
		$builder = $db->table('user_form as user');
		$builder->join('tbl_transaction_details as trans','user.user_form_make_id = trans.user_id');
		$builder->where(['user_form_make_id' => $userId]);
		$query = $builder->get()->getResult();
		if($query){
			return $query;
		}else{
			return false;
		}
	}

	public function getTableName($nominationid)
	{	
		$db = \Config\Database::connect();
		$builder = $db->table('tbl_category_master');
		$builder->where(['id' => $nominationid]);
		$query = $builder->get()->getRow();
		if($query){
			return $query;
		}else{
			return false;
		}
	}

	public function mail(){
		/*$mail->IsHTML(true); 
        $message  = "<html><body>";
        $message .= "<table width='100%' bgcolor='#e0e0e0' cellpadding='0' cellspacing='0' border='0'>";
        $message .= "<tr><td>";
        $message .= "<table align='center' width='100%' border='0' cellpadding='0' cellspacing='0' style='max-width:650px; background-color:#fff; font-family:Verdana, Geneva, sans-serif;'>";
        $message .= "<thead>
        <tr height='80'>
        <th colspan='4' style='border-bottom:solid 1px #bdbdbd; font-family:Verdana, Geneva, sans-serif; color:#333; font-size:34px;' >
        <img src='https://makeinsteel.com/assets-home/img/logo.png' alt='https://makeinsteel.com'></th></tr></thead>";
        $message .= "<tbody><tr><td colspan='4' style='padding:15px;'><p style='font-size:20px;'>Dear ".$name.",</p><p style='font-size:18px;'>
        Thank you. We have received your registration for the MakeInSteel Awards ".date('Y').".</p>
        <p style='font-size:18px;'>Please find your details below:</p>

        <table border='1px solid;'>
            <tr>
                <td>Name</td>
                <td>".$name."</td>
            </tr>
            <tr>
                <td>Email</td>
                <td>".$email."</td>
            </tr>

            <tr>
                <td>Mobile No.</td>
                <td>".$user_mobile."</td>
            </tr>

            <tr>
                <td>Company Name</td>
                <td>".$company_name."</td>
            </tr>

            <tr>
                <td>Password</td>
                <td>".$password."</td>
            </tr>

        </table>

        <p style='font-size:18px;'>You may login to your account from this link to complete the nomination and payment process <a target='_blank' href='https://makeinsteel.com/nomination.php'>https://makeinsteel.com/nomination.php</a></p>

        <p style='font-size:20px;'>Regards,</p><p style='font-size:18px;'>Team MakeInSteel</p></td></tr></tbody>";
        $message .= "</table>";
        $message .= "</td></tr>";
        $message .= "</table>";
        $message .= "</body></html>";
        $mail->Subject = "MakeInSteel | Registration Details";
        $mail->Body = $message;
        $mail->AddAddress($email);
        $mail->AddBcc('rahul.j@asappmedia.com');
        $mail->Send();*/
	}
}