<?php $this->load->view('header');?>
<link rel="stylesheet" href="<?php echo base_url();?>assets/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
<link rel="stylesheet" href="<?php echo base_url();?>assets/plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
<link rel="stylesheet" href="<?php echo base_url();?>assets/plugins/datatables-buttons/css/buttons.bootstrap4.min.css">
<?php $this->load->view('nav-bar');?>

<?php $this->load->view('sidebar');?>

<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Profile</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">User Profile</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-md-3">

            <!-- Profile Image -->
            <div class="card card-primary card-outline">
              <div class="card-body box-profile">
                <div class="text-center">
                  <img class="profile-user-img img-fluid img-circle"
                       src="<?php echo base_url();?>assets/dist/img/boxed-bg.jpg"
                       alt="User profile picture">
                </div>

                <h3 class="profile-username text-center"><?php echo $userDetails->name; ?></h3>

              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->

            <!-- About Me Box -->
            <div class="card card-primary">
              <div class="card-header">
                <h3 class="card-title">About Me</h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">

                <strong><i class="fas fa-lg fa-envelope"></i> </strong> <?php echo $userDetails->email_id; ?>
                <hr>

                <strong><i class="fas fa-lg fa-phone"></i> </strong> <?php echo $userDetails->mobile_no; ?>
                <hr>

                <strong><i class="fas fa-lg fa-city"></i> </strong> <?php echo $userDetails->city; ?>
                <hr>

                <strong><i class="fas fa-lg fa-building"></i> </strong> <?php echo $userDetails->company_name; ?>
                <hr>

                <strong><i class="fas fa-lg fa-building"></i> </strong> <?php echo $userDetails->address; ?>
                <hr>

              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
          <div class="col-md-9">
            <div class="card">
              <div class="card-header p-2">
                <ul class="nav nav-pills">
                  <li class="nav-item"><a class="active nav-link" href="#timeline" data-toggle="tab">Follow Up</a></li>
                  <li class="nav-item"><a class="nav-link" href="#activity" data-toggle="tab">Subscription</a></li>
                  <li class="nav-item"><a class="nav-link" href="#settings" data-toggle="tab">Settings</a></li>
                </ul>
              </div><!-- /.card-header -->
              <div class="card-body">
                <div class="tab-content">
                  <!-- /.tab-pane -->
                  <div class="active tab-pane" id="timeline">
                    <!-- The timeline -->
                    <?php
                      if(!empty($followUp)){
                    ?>
                      <a class="btn btn-info btn-xs" href="<?= base_url();?>Subscription/viewSubDetails/<?php echo $followUp[0]->lead_id;?>">Add Follow Up</a>
                    <?php }else{?>
                      <a class="btn btn-info btn-xs" href="<?= base_url();?>Subscription/createFollowup/<?php echo $userDetails->id;?>">Add Follow Up</a>
                    <?php }?>
                    <div class="timeline timeline-inverse">
                      <!-- timeline time label -->
                      <?php
                        if(!empty($followUp)){
                        $i = 1;
                        foreach ($followUp as $key => $follow) {

                          if($i == 1){
                            $itemLabelClass = 'bg-success';
                            $itemClass = 'bg-success';
                          }else{
                            $itemLabelClass = 'bg-danger';
                            $itemClass = 'bg-warning';
                          }
                      ?>
                      <div class="time-label">
                        <span class="<?php echo $itemLabelClass;?>">
                          <?php echo date('d M. Y', strtotime($follow->created_date));?>
                        </span>
                      </div>
                      
                      <div>
                        <i class="fas fa-circle <?php echo $itemClass;?>"></i>

                        <div class="timeline-item">
                          <!-- <span class="time"><i class="far fa-clock"></i> 27 mins ago</span> -->

                          <!-- <h3 class="timeline-header"><a href="#">Jay White</a> commented on your post</h3> -->

                          <div class="timeline-body">
                            <!-- <?php echo $follow->remarks;?> -->
                            <table class="table">
                              <tr>
                                <th>Stage</th>
                                <th>Type</th>
                                <th>Status</th>
                                <th>Magazine</th>
                                <th>Magazine Plans</th>
                                <th>Qty</th>
                                <th>Follow Up Date</th>
                                <th>Remarks</th>
                              </tr>
                              <tr>
                                <td><?php echo $follow->stageName;?></td>
                                <td><?php echo $follow->type;?></td>
                                <td><?php echo $follow->statusName;?></td>
                                <td><?php echo $follow->magazineName;?></td>
                                <td><?php if(!empty($follow->magazinePlanName)){ echo $follow->magazinePlanName;} ?></td>
                                <td><?php echo $follow->qty;?></td>
                                <td><?php echo date('d M Y', strtotime($follow->follow_up_date));?></td>
                                <td><?php echo $follow->remarks;?></td>
                              </tr>
                            </table>
                          </div>
                        </div>
                      </div>
                      <?php $i++; } }?>
                      <!-- END timeline item -->
                      <div>
                        <i class="far fa-clock bg-gray"></i>
                      </div>
                    </div>
                  </div>
                  <!-- /.tab-pane -->

                  <div class="tab-pane" id="activity">
                    <!-- <button type="button" class="btn btn-info btn-xs" data-toggle="modal" data-target="#modal-xl">Add Subscription</button> -->
                    <table id="example1" class="table table-bordered table-striped">
                    <thead>
                      <tr>
                        <th>#</th>
                          <th>Magazine</th>
                          <th>Qty</th>
                          <th>Amount</th>
                          <th>Mode of Payment</th>
                          <th>Mode of Delivery</th>
                          <th>Start Date</th>
                          <th>End Date</th>
                          <th>Address</th>
                      </tr>
                    </thead>

                    <tbody>
                      <?php 
                        if(!empty($subscriptionDetails)){
                        $i = 1;
                        foreach($subscriptionDetails as $value){
                      ?>
                        <tr>
                          <td><?php echo $i;?></td>
                          <td><?php echo $value->news_scheme_name;?></td>
                          <td><?php echo $value->qty;?></td>
                          <td><?php echo $value->amoun_received;?></td>
                          <td><?php echo $value->mode_of_payment;?></td>
                          <td><?php echo $value->mode_of_delievry;?></td>
                          <td><?php echo $value->start_date;?></td>
                          <td><?php echo $value->end_date;?></td>
                          <td><?php echo $value->address1;?></td>
                        </tr>
                      <?php $i++; } }?>
                    </tbody>
                  </table>
                  </div>

                  <div class="tab-pane" id="settings">
                    <form class="form-horizontal" method="post" action="<?php echo base_url();?>Subscription/updateUserDetails">
                      <div class="form-group row">
                        <label for="inputName" class="col-sm-2 col-form-label">Name</label>
                        <div class="col-sm-10">
                          <input type="text" class="form-control" name="userName" id="inputName" placeholder="Name" value="<?php echo $userDetails->name;?>" required>
                        </div>
                      </div>
                      <div class="form-group row">
                        <label for="inputEmail" class="col-sm-2 col-form-label">Email</label>
                        <div class="col-sm-10">
                          <input type="email" class="form-control" name="userEmail" id="inputEmail" placeholder="Email" value="<?php echo $userDetails->email_id;?>" required>
                        </div>
                      </div>
                      <div class="form-group row">
                        <label for="inputName2" class="col-sm-2 col-form-label">Mobile No.</label>
                        <div class="col-sm-10">
                          <input type="text" class="form-control" name="userMobileNo" id="inputName2" placeholder="Mobile no." value="<?php echo $userDetails->mobile_no;?>" required>
                        </div>
                      </div>
                      <div class="form-group row">
                        <label for="inputExperience" class="col-sm-2 col-form-label">Address</label>
                        <div class="col-sm-10">
                          <textarea class="form-control" name="userAddress" id="inputExperience" placeholder="Address" required><?php echo $userDetails->address;?></textarea>
                        </div>
                      </div>
                      <div class="form-group row">
                        <label for="inputSkills" class="col-sm-2 col-form-label">City</label>
                        <div class="col-sm-10">
                          <input type="text" class="form-control" name="userCity" placeholder="City" value="<?php echo $userDetails->city;?>">
                        </div>
                      </div>

                      <div class="form-group row">
                        <label for="inputSkills" class="col-sm-2 col-form-label">Pincode</label>
                        <div class="col-sm-10">
                          <input type="hidden" name="submitId" value="<?= $userDetails->id;?>">
                          <input type="text" class="form-control" name="userPincode" placeholder="Pincode" value="<?php echo $userDetails->pincode;?>" required>
                        </div>
                      </div>

                      <!-- <div class="form-group row">
                        <div class="offset-sm-2 col-sm-10">
                          <div class="checkbox">
                            <label>
                              <input type="checkbox"> I agree to the <a href="#">terms and conditions</a>
                            </label>
                          </div>
                        </div>
                      </div> -->
                      <div class="form-group row">
                        <div class="offset-sm-2 col-sm-10">
                          <button type="submit" class="btn btn-info">Update</button>
                        </div>
                      </div>
                    </form>
                  </div>
                  <!-- /.tab-pane -->
                </div>
                <!-- /.tab-content -->
              </div><!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>

<!-- jQuery -->
<script src="<?php echo base_url();?>assets/plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="<?php echo base_url();?>assets/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- Select2 -->
<script src="<?php echo base_url();?>assets/plugins/select2/js/select2.full.min.js"></script>
<!-- Bootstrap4 Duallistbox -->
<script src="<?php echo base_url();?>assets/plugins/bootstrap4-duallistbox/jquery.bootstrap-duallistbox.min.js"></script>
<!-- InputMask -->
<script src="<?php echo base_url();?>assets/plugins/moment/moment.min.js"></script>
<script src="<?php echo base_url();?>assets/plugins/inputmask/jquery.inputmask.min.js"></script>
<!-- date-range-picker -->
<script src="<?php echo base_url();?>assets/plugins/daterangepicker/daterangepicker.js"></script>
<!-- bootstrap color picker -->
<script src="<?php echo base_url();?>assets/plugins/bootstrap-colorpicker/js/bootstrap-colorpicker.min.js"></script>
<!-- Tempusdominus Bootstrap 4 -->
<script src="<?php echo base_url();?>assets/plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>

<!-- DataTables  & Plugins -->
<script src="<?php echo base_url()?>assets/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo base_url()?>assets/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="<?php echo base_url()?>assets/plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="<?php echo base_url()?>assets/plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="<?php echo base_url()?>assets/plugins/datatables-buttons/js/dataTables.buttons.min.js"></script>
<script src="<?php echo base_url()?>assets/plugins/datatables-buttons/js/buttons.bootstrap4.min.js"></script>
<script src="<?php echo base_url()?>assets/plugins/jszip/jszip.min.js"></script>
<script src="<?php echo base_url()?>assets/plugins/pdfmake/pdfmake.min.js"></script>
<script src="<?php echo base_url()?>assets/plugins/pdfmake/vfs_fonts.js"></script>
<script src="<?php echo base_url()?>assets/plugins/datatables-buttons/js/buttons.html5.min.js"></script>
<script src="<?php echo base_url()?>assets/plugins/datatables-buttons/js/buttons.print.min.js"></script>
<script src="<?php echo base_url()?>assets/plugins/datatables-buttons/js/buttons.colVis.min.js"></script>
<!-- AdminLTE App -->
<script src="<?php echo base_url()?>assets/dist/js/adminlte.min.js"></script>
<!-- AdminLTE for demo purposes -->
<!-- <script src="<?php //echo base_url()?>assets/dist/js/demo.js"></script> -->
<!-- Page specific script -->
<script>
  $(function () {
    $("#example1").DataTable({
      "responsive": true, "lengthChange": false, "autoWidth": false,
      // "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');

    /*$('#example1').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": true,
      "ordering": false,
      "info": true,
      "autoWidth": false,
      "responsive": true,
    });*/
  });
</script>

<script type="text/javascript">

  $("#check_idd").click(function(){
    if($("#check_idd").is(":checked") == true){
      $(".check_id").prop("checked", true);
    }else{
      $(".check_id").prop("checked", false);
    }
  })
</script>

<script>
  $(function () {
    $('#reservationdate').datetimepicker({
        format: 'DD-MM-YYYY'
    });
    $('#reservationdate1').datetimepicker({
        format: 'DD-MM-YYYY'
    });

    $("#status").on('change', function(){
      var id = $("#status").val();
      if(id == 5){
        $("#followUpDiv").css('display','block');
      }else{
        $("#followUpDiv").css('display','none');
      }
    })
  });

</script>

<!-- Add follow up modal -->
  <div class="modal fade" id="modal-xl">
        <div class="modal-dialog modal-xl">
          <div class="modal-content">
            <div class="modal-header">
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <section class="content">
                <div class="container-fluid">
                  
                    <div class="card card-info">
                        <div class="card-header">
                          <h3 class="card-title">Add Subscription</h3>
                        </div>
                        <form method="post" action="<?= base_url();?>Subscription/updateLeadDetails" >

                        <div class="card-body">
                          <div class="row">

                            <div class="col-2">
                              <label>Type</label>
                              <select class="form-control" name="type" id="type" required>
                                <option value="">Select</option>
                                <option value="new">New</option>
                                <option value="renewal">Renewal</option>
                              </select>
                            </div>

                            <div class="col-2">
                              <label>Status</label>
                              <select class="form-control" name="status" id="status" required>
                                <option value="">Select</option>
                                <option value="payment_done">Payment Done</option>
                              </select>
                            </div>

                            <div class="col-2">
                              <label>Magazine</label>
                              <select class="form-control" name="magazine" id="magazine" required>
                                <option value="">Select</option>
                                <?php
                                  foreach($magazine as $mag){
                                ?>
                                  <option value="<?php echo $mag->id?>"><?php echo $mag->magazine_name?></option>
                                <?php }?>
                              </select>
                            </div>

                            <div class="col-2">
                              <label>Magazine Plans</label>
                              <select class="form-control" name="magazine_plane" id="magazine_plane">
                                <option value="">Select</option>
                                <?php
                                  foreach($magazinePlans as $plans){
                                ?>
                                  <option value="<?php echo $plans->id?>"><?php echo $plans->plan_name?></option>
                                <?php }?>
                              </select>
                            </div>

                            <div class="col-2">
                              <label>Qty</label>
                              <input type="number" class="form-control" name="qty" value="">
                            </div>

                          </div>
                        </div>

                        <div class="card-body">
                          <div class="row">

                            <div class="col-4">
                              <label>Remarks</label>
                              <textarea class="form-control" name="remarks" required></textarea>
                            </div>

                          </div>
                        </div>

                        <div class="card-body" id="followUpDiv" style="display: none;">
                          <div class="row">

                            <div class="col-sm-2">
                              <div class="form-group">
                                <label>Follow Up Date:</label>
                                <div class="input-group date" id="followupDate" data-target-input="nearest">
                                    <input type="text" class="form-control datetimepicker-input" value="<?php echo date('d-m-Y');?>" name="followupDate" data-target="#followupDate"/>
                                    <div class="input-group-append" data-target="#followupDate" data-toggle="datetimepicker">
                                        <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                    </div>
                                </div>
                              </div>
                            </div>

                          </div>
                        </div>


                        <div class="card-body">
                          <div class="row">
                            <div class="col-2">
                              <input type="hidden" class="form-control" value="" name="id">
                              <button class="btn btn-success">Create</button>
                            </div>
                          </div>
                        </div>
                      </form>
                    </div>
                </div><!-- /.container-fluid -->
              </section>
            </div>
            <div class="modal-footer justify-content-between">
              <!-- <button type="button" class="btn btn-default" data-dismiss="modal">Close</button> -->
              <!-- <button type="button" class="btn btn-primary">Save changes</button> -->
            </div>
          </div>
          <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
      </div>