<?php
  function getLimitedText($text, $limit) {
      // Check if the length of the text is greater than the limit
      /*if (strlen($text) > $limit) {
          // If yes, use substr to return the first 70 characters
          return substr($text, 0, $limit).'..';
      } else {
          // If not, return the original text
          return $text;
      }*/

      if (strlen($text) > $limit) {
        // Use substr to get the substring up to the limit
        $substring = substr($text, 0, $limit);

        // Find the position of the last space in the substring
        $lastSpacePos = strrpos($substring, ' ');

        // If the last space position is not at the end, truncate at that position
        if ($lastSpacePos !== false && $lastSpacePos < $limit) {
            $limitedText = substr($substring, 0, $lastSpacePos);
        } else {
            // If there are no spaces or the last space is at the end, use the whole substring
            $limitedText = $substring;
        }

        return $limitedText.'..';
      } else {
          // If the text is within the limit, return the original text
          return $text;
      }
  }
?>
<section class="ts-blog section-bg about-sec">
  <div class="container">
    <div class="row">
      <div class="col-lg-12">
        <div class="section-heading">
          <h1 class="section-title">News</h1>
        </div>
      </div>
      <!-- col end-->
    </div>
    <!-- row end-->
    <div class="row">
      <?php
         foreach($articles as $article){
      ?>
         <div class="col-lg-4 wow fadeInUp" data-wow-duration="1.5s" data-wow-delay="400ms">
           <div class="post">
             <div class="post-media post-image">
               <a href="<?php echo BASE_URL.'articles/news/'.$article->id;?>">
                 <img src="<?php echo $article->image_url;?>" class="img-fluid" alt="<?php echo $article->title;?>">
               </a>
             </div>
             <div class="post-body">
               <div class="post-meta">
                 <div class="post-meta-date">
                   <i class="fa fa-calendar" aria-hidden="true"></i> <?php echo date('M d Y', strtotime($article->date));?>
                 </div>
               </div>
               <div class="entry-header">
                 <h2 class="entry-title">
                   <a href="<?php echo BASE_URL.'articles/news/'.$article->id;?>"><?php echo $article->title;?></a>
                 </h2>
               </div>
               <!-- header end -->
               <div class="entry-content">
                <?php $description = getLimitedText($article->short_description, 68);?>
                 <p><?php echo $description; ?></p>
               </div>
               <div class="post-footer">
                 <a href="<?php echo BASE_URL.'articles/news/'.$article->id;?>" class="primary-button1">Read More <i class="fas fa-angle-double-right"></i>
                 </a>
               </div>
             </div>
             <!-- post-body end -->
           </div>
           <!-- post end-->
         </div>
      <?php }?>
      <!-- col end-->
      
    </div>
    <!-- row end-->
  </div>
  <!-- container end-->
  <!-- shap image-->
  <div class="speaker-shap">
    <img class="shap2" src="assets-home/img/news_memphis2.png" alt="">
    <img class="shap1" src="assets-home/img/news_memphis1.png" alt="">
  </div>
</section>