<?php
    function getLimitedText($text, $limit) {
      if (strlen($text) > $limit) {
        // Use substr to get the substring up to the limit
        $substring = substr($text, 0, $limit);

        // Find the position of the last space in the substring
        $lastSpacePos = strrpos($substring, ' ');

        // If the last space position is not at the end, truncate at that position
        if ($lastSpacePos !== false && $lastSpacePos < $limit) {
            $limitedText = substr($substring, 0, $lastSpacePos);
        } else {
            // If there are no spaces or the last space is at the end, use the whole substring
            $limitedText = $substring;
        }

        return $limitedText.'..';
      } else {
          // If the text is within the limit, return the original text
          return $text;
      }
  }

  function getReadTime($content) {
    $wordsPerMinute = 200;
    $wordCount = str_word_count(strip_tags($content));
    $readTime = ceil($wordCount / $wordsPerMinute);
    return $readTime;
  }

?>
<section class="exhibior-sec">
   <div class="container">
        <div class="row">
            <div class="col-lg-12">
               <div class="section-heading">
                  <h1 class="section-title">Blogs</h1>
               </div>
            </div>
         </div>
        <div class="row">
        <?php
            foreach ($blogs as $key => $blog) {
        ?>
            <div class="col-lg-6">
            <div class="bsingle__post mb-50">
               <div class="bsingle__post-thumb">
                        <img src="https://rahstaexpo.com/assets-home/blog/<?php echo $blog->image_url;?>"  alt="<?php echo !empty($blog->alt_tag) ? $blog->alt_tag: $blog->title;?>">
               </div>
               <div class="bsingle__content">
                  <div class="meta-info">

                    <?php
                        /*$wordCount = str_word_count($blog->description);
                        $readTime = round($wordCount/125);*/
                        $readTime = getReadTime($blog->description);
                    ?>
                     <ul>
                        <!-- <li><i class="fa fa-calendar-o"></i><?php //echo date('d M', strtotime($blog->date));?></li> -->
                        <?php if(!empty($readTime)){?>
                            <li><i class="fa fa-clock-o"></i><?= $readTime;?> Min</li>
                        <?php }?>
                        <!-- <li><i class="far fa-comments"></i>35 Comments</li> -->
                     </ul>
                  </div>
                  <h2><a href="<?php echo base_url().'/blog/insight/'.$blog->id;?>"><?php echo $blog->title;?></a>
                  </h2>
                  <?php $description = getLimitedText($blog->short_description, 160);?>
                 <p><?php echo $description; ?></p>
                  <div class="slider-btn">
                     <a href="<?php echo base_url().'/blog/insight/'.$blog->id;?>" class="btn ss-btn" data-animation="fadeInRight" data-delay=".8s">Read More</a>                 
                     <div class="btn-after" data-animation="fadeInRight" data-delay=".8s"></div>
                  </div>
               </div>
            </div>
            </div>
        <?php
            }
        ?>

      </div>
   </div>
</section>