<?php

// RSS feed header
header('Content-Type: application/rss+xml; charset=utf-8');
echo '<?xml version="1.0" encoding="UTF-8" ?>
<rss version="2.0">
    <channel>
        <title>Your RSS Feed Title</title>
        <description>Your RSS Feed Description</description>
        <link>http://example.com</link>
        <lastBuildDate>' . date('r') . '</lastBuildDate>
        <pubDate>' . date('r') . '</pubDate>
        <ttl>60</ttl>';

// RSS feed items

    function cleanText($text) {
      // Replace special characters and HTML entities
        return htmlspecialchars($text, ENT_QUOTES | ENT_XML1, 'UTF-8');
    }

foreach ($articles as $article) {

        $url = BASE_URL.'articles/news/'.$article->id;
        // $article->description
        echo '<item>
            <title>' . $article->title . '</title>
            <description>' . cleanText($article->short_description) . '</description>
            <link>' . cleanText($url) . '</link>
            <pubDate>' . date(DATE_RSS, strtotime($article->date)) . '</pubDate>
            <enclosure url="'.$article->image_medium_url.'" type="image/jpeg" />
            </item>';
}

echo '
    </channel>
</rss>';
?>
